/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.brave;

import com.github.kristofa.brave.LocalTracer;
import java.util.List;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.Nullable;
import zipkin.storage.QueryRequest;
import zipkin.storage.SpanStore;

final class TracedSpanStore
implements SpanStore {
    private final LocalTracer tracer;
    private final SpanStore delegate;
    private final String component;

    TracedSpanStore(LocalTracer tracer, SpanStore delegate) {
        this.tracer = tracer;
        this.delegate = delegate;
        this.component = delegate.getClass().getSimpleName();
    }

    public List<List<Span>> getTraces(QueryRequest request) {
        if (this.tracer.startNewSpan(this.component, "get-traces") != null) {
            this.tracer.submitBinaryAnnotation("request", request.toString());
        }
        try {
            List list = this.delegate.getTraces(request);
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Span> getTrace(long traceId) {
        this.tracer.startNewSpan(this.component, "get-trace");
        try {
            List list = this.delegate.getTrace(traceId);
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Span> getRawTrace(long traceId) {
        this.tracer.startNewSpan(this.component, "get-spans-by-trace-id");
        try {
            List list = this.delegate.getRawTrace(traceId);
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    public List<String> getServiceNames() {
        this.tracer.startNewSpan(this.component, "get-service-names");
        try {
            List list = this.delegate.getServiceNames();
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    public List<String> getSpanNames(String serviceName) {
        this.tracer.startNewSpan(this.component, "get-span-names");
        try {
            List list = this.delegate.getSpanNames(serviceName);
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DependencyLink> getDependencies(long endTs, @Nullable Long lookback) {
        this.tracer.startNewSpan(this.component, "get-dependencies");
        try {
            List list = this.delegate.getDependencies(endTs, lookback);
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }
}

