/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.brave;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerClientAndLocalSpanState;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanCollectorMetricsHandler;
import com.github.kristofa.brave.ThreadLocalServerClientAndLocalSpanState;
import com.github.kristofa.brave.local.LocalSpanCollector;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import zipkin.Endpoint;
import zipkin.collector.CollectorMetrics;
import zipkin.server.ConditionalOnSelfTracing;
import zipkin.server.brave.ApiTracerConfiguration;
import zipkin.storage.StorageComponent;

@Configuration
@ConditionalOnSelfTracing
@Import(value={ApiTracerConfiguration.class})
public class BraveConfiguration {
    @Bean
    @Scope
    Endpoint local(@Value(value="${server.port:9411}") int port) {
        int ipv4;
        try {
            ipv4 = Collections.list(NetworkInterface.getNetworkInterfaces()).stream().flatMap(i -> Collections.list(i.getInetAddresses()).stream()).filter(ip -> ip instanceof Inet4Address && ip.isSiteLocalAddress()).map(InetAddress::getAddress).map(bytes -> new BigInteger((byte[])bytes).intValue()).findAny().get();
        }
        catch (Exception ignored) {
            ipv4 = 2130706433;
        }
        return Endpoint.create((String)"zipkin-server", (int)ipv4, (int)port);
    }

    @Bean
    LocalSpanCollector spanCollector(StorageComponent storage, @Value(value="${zipkin.self-tracing.flush-interval:1}") int flushInterval, final CollectorMetrics metrics) {
        LocalSpanCollector.Config config = LocalSpanCollector.Config.builder().flushInterval(flushInterval).build();
        return LocalSpanCollector.create((StorageComponent)storage, (LocalSpanCollector.Config)config, (SpanCollectorMetricsHandler)new SpanCollectorMetricsHandler(){
            CollectorMetrics local;
            {
                this.local = metrics.forTransport("local");
            }

            public void incrementAcceptedSpans(int i) {
                this.local.incrementSpans(i);
            }

            public void incrementDroppedSpans(int i) {
                this.local.incrementSpansDropped(i);
            }
        });
    }

    @Bean
    ServerClientAndLocalSpanState braveState(@Qualifier(value="local") Endpoint localEndpoint) {
        return new ThreadLocalServerClientAndLocalSpanState(localEndpoint.ipv4, (int)localEndpoint.port.shortValue(), localEndpoint.serviceName);
    }

    @Bean
    Brave brave(ServerClientAndLocalSpanState braveState, LocalSpanCollector spanCollector) {
        return new Brave.Builder(braveState).spanCollector((SpanCollector)spanCollector).build();
    }
}

