/*
 * Decompiled with CFR 0.152.
 */
package zipkin.junit;

import java.io.IOException;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import okio.Buffer;
import okio.GzipSource;
import okio.Source;
import zipkin.Codec;
import zipkin.SpanDecoder;
import zipkin.collector.Collector;
import zipkin.collector.CollectorMetrics;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.internal.V2JsonSpanDecoder;
import zipkin.internal.V2StorageComponent;
import zipkin.storage.Callback;
import zipkin.storage.QueryRequest;
import zipkin2.Span;
import zipkin2.codec.DependencyLinkBytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.internal.Platform;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;

final class ZipkinDispatcher
extends Dispatcher {
    static final long DEFAULT_LOOKBACK = 86400000L;
    static final SpanDecoder JSON2_DECODER = new V2JsonSpanDecoder();
    private final zipkin.storage.SpanStore store;
    private final SpanStore store2;
    private final Collector consumer;
    private final CollectorMetrics metrics;
    private final MockWebServer server;

    ZipkinDispatcher(StorageComponent storage, CollectorMetrics metrics, MockWebServer server) {
        V2StorageComponent adapted = V2StorageComponent.create((StorageComponent)storage);
        this.store = adapted.spanStore();
        this.store2 = storage.spanStore();
        this.consumer = Collector.builder(((Object)((Object)this)).getClass()).storage((zipkin.storage.StorageComponent)adapted).metrics(metrics).build();
        this.metrics = metrics;
        this.server = server;
    }

    public MockResponse dispatch(RecordedRequest request) {
        HttpUrl url = this.server.url(request.getPath());
        if (request.getMethod().equals("GET")) {
            if (url.encodedPath().equals("/health")) {
                return new MockResponse().setBody("OK\n");
            }
            if (url.encodedPath().startsWith("/api/v1/")) {
                return this.queryV1(url);
            }
            if (url.encodedPath().startsWith("/api/v2/")) {
                try {
                    return this.queryV2(url);
                }
                catch (IOException e) {
                    throw Platform.get().uncheckedIOException(e);
                }
            }
        } else if (request.getMethod().equals("POST")) {
            if (url.encodedPath().equals("/api/v1/spans")) {
                String type = request.getHeader("Content-Type");
                SpanDecoder decoder = type != null && type.contains("/x-thrift") ? SpanDecoder.THRIFT_DECODER : SpanDecoder.JSON_DECODER;
                return this.acceptSpans(request, decoder);
            }
            if (url.encodedPath().equals("/api/v2/spans")) {
                return this.acceptSpans(request, JSON2_DECODER);
            }
        } else {
            return new MockResponse().setResponseCode(405);
        }
        return new MockResponse().setResponseCode(404);
    }

    MockResponse queryV1(HttpUrl url) {
        if (url.encodedPath().equals("/api/v1/services")) {
            return ZipkinDispatcher.jsonResponse(Codec.JSON.writeStrings(this.store.getServiceNames()));
        }
        if (url.encodedPath().equals("/api/v1/spans")) {
            String serviceName = url.queryParameter("serviceName");
            return ZipkinDispatcher.jsonResponse(Codec.JSON.writeStrings(this.store.getSpanNames(serviceName)));
        }
        if (url.encodedPath().equals("/api/v1/dependencies")) {
            Long endTs = ZipkinDispatcher.maybeLong(url.queryParameter("endTs"));
            Long lookback = ZipkinDispatcher.maybeLong(url.queryParameter("lookback"));
            List result = this.store.getDependencies(endTs.longValue(), lookback);
            return ZipkinDispatcher.jsonResponse(Codec.JSON.writeDependencyLinks(result));
        }
        if (url.encodedPath().equals("/api/v1/traces")) {
            QueryRequest queryRequest = ZipkinDispatcher.toQueryRequest(url);
            return ZipkinDispatcher.jsonResponse(Codec.JSON.writeTraces(this.store.getTraces(queryRequest)));
        }
        if (url.encodedPath().startsWith("/api/v1/trace/")) {
            List trace;
            String traceIdHex = url.encodedPath().replace("/api/v1/trace/", "");
            long traceIdHigh = traceIdHex.length() == 32 ? Util.lowerHexToUnsignedLong((String)traceIdHex, (int)0) : 0L;
            long traceIdLow = Util.lowerHexToUnsignedLong((String)traceIdHex);
            List list = trace = url.queryParameterNames().contains("raw") ? this.store.getRawTrace(traceIdHigh, traceIdLow) : this.store.getTrace(traceIdHigh, traceIdLow);
            if (trace != null) {
                return ZipkinDispatcher.jsonResponse(Codec.JSON.writeSpans(trace));
            }
        }
        return new MockResponse().setResponseCode(404);
    }

    MockResponse queryV2(HttpUrl url) throws IOException {
        String traceIdHex;
        List trace;
        if (url.encodedPath().equals("/api/v2/services")) {
            return ZipkinDispatcher.jsonResponse(Codec.JSON.writeStrings((List)this.store2.getServiceNames().execute()));
        }
        if (url.encodedPath().equals("/api/v2/spans")) {
            String serviceName = url.queryParameter("serviceName");
            return ZipkinDispatcher.jsonResponse(Codec.JSON.writeStrings((List)this.store2.getSpanNames(serviceName).execute()));
        }
        if (url.encodedPath().equals("/api/v2/dependencies")) {
            Long endTs = ZipkinDispatcher.maybeLong(url.queryParameter("endTs"));
            Long lookback = ZipkinDispatcher.maybeLong(url.queryParameter("lookback"));
            List result = (List)this.store2.getDependencies(endTs != null ? endTs : System.currentTimeMillis(), lookback != null ? lookback : 86400000L).execute();
            return ZipkinDispatcher.jsonResponse(DependencyLinkBytesEncoder.JSON_V1.encodeList(result));
        }
        if (url.encodedPath().equals("/api/v2/traces")) {
            List traces = (List)this.store2.getTraces(ZipkinDispatcher.toQueryRequest2(url)).execute();
            return ZipkinDispatcher.jsonResponse(ZipkinDispatcher.writeTraces(SpanBytesEncoder.JSON_V2, traces));
        }
        if (url.encodedPath().startsWith("/api/v2/trace/") && !(trace = (List)this.store2.getTrace(Span.normalizeTraceId((String)(traceIdHex = url.encodedPath().replace("/api/v2/trace/", "")))).execute()).isEmpty()) {
            return ZipkinDispatcher.jsonResponse(SpanBytesEncoder.JSON_V2.encodeList(trace));
        }
        return new MockResponse().setResponseCode(404);
    }

    static byte[] writeTraces(SpanBytesEncoder codec, List<List<Span>> traces) {
        int length = traces.size();
        int sizeInBytes = 2;
        if (length > 1) {
            sizeInBytes += length - 1;
        }
        for (int i = 0; i < length; ++i) {
            List<Span> spans = traces.get(i);
            int jLength = spans.size();
            sizeInBytes += 2;
            if (jLength > 1) {
                sizeInBytes += jLength - 1;
            }
            for (int j = 0; j < jLength; ++j) {
                sizeInBytes += codec.sizeInBytes((Object)spans.get(j));
            }
        }
        byte[] out = new byte[sizeInBytes];
        int pos = 0;
        out[pos++] = 91;
        for (int i = 0; i < length; ++i) {
            pos += codec.encodeList(traces.get(i), out, pos);
            if (i + 1 >= length) continue;
            out[pos++] = 44;
        }
        out[pos] = 93;
        return out;
    }

    MockResponse acceptSpans(RecordedRequest request, SpanDecoder decoder) {
        MockResponse result;
        this.metrics.incrementMessages();
        byte[] body = request.getBody().readByteArray();
        String encoding = request.getHeader("Content-Encoding");
        if (encoding != null && encoding.contains("gzip")) {
            try {
                result = new Buffer();
                GzipSource source = new GzipSource((Source)new Buffer().write(body));
                while (source.read((Buffer)result, Integer.MAX_VALUE) != -1L) {
                }
                body = result.readByteArray();
            }
            catch (IOException e) {
                this.metrics.incrementMessagesDropped();
                return new MockResponse().setResponseCode(400).setBody("Cannot gunzip spans");
            }
        }
        result = new MockResponse();
        this.consumer.acceptSpans(body, decoder, (Callback)new Callback<Void>(){

            public void onSuccess(@Nullable Void value) {
                result.setResponseCode(202);
            }

            public void onError(Throwable t) {
                String message = t.getMessage();
                result.setBody(message).setResponseCode(message.startsWith("Cannot store") ? 500 : 400);
            }
        });
        return result;
    }

    static QueryRequest toQueryRequest(HttpUrl url) {
        return QueryRequest.builder().serviceName(url.queryParameter("serviceName")).spanName(url.queryParameter("spanName")).parseAnnotationQuery(url.queryParameter("annotationQuery")).minDuration(ZipkinDispatcher.maybeLong(url.queryParameter("minDuration"))).maxDuration(ZipkinDispatcher.maybeLong(url.queryParameter("maxDuration"))).endTs(ZipkinDispatcher.maybeLong(url.queryParameter("endTs"))).lookback(ZipkinDispatcher.maybeLong(url.queryParameter("lookback"))).limit(ZipkinDispatcher.maybeInteger(url.queryParameter("limit"))).build();
    }

    static zipkin2.storage.QueryRequest toQueryRequest2(HttpUrl url) {
        Long endTs = ZipkinDispatcher.maybeLong(url.queryParameter("endTs"));
        Long lookback = ZipkinDispatcher.maybeLong(url.queryParameter("lookback"));
        Integer limit = ZipkinDispatcher.maybeInteger(url.queryParameter("limit"));
        return zipkin2.storage.QueryRequest.newBuilder().serviceName(url.queryParameter("serviceName")).spanName(url.queryParameter("spanName")).parseAnnotationQuery(url.queryParameter("annotationQuery")).minDuration(ZipkinDispatcher.maybeLong(url.queryParameter("minDuration"))).maxDuration(ZipkinDispatcher.maybeLong(url.queryParameter("maxDuration"))).endTs(endTs != null ? endTs : System.currentTimeMillis()).lookback(lookback != null ? lookback : 86400000L).limit(limit != null ? limit : 10).build();
    }

    @Nullable
    static Long maybeLong(@Nullable String input) {
        return input != null ? Long.valueOf(input) : null;
    }

    @Nullable
    static Integer maybeInteger(@Nullable String input) {
        return input != null ? Integer.valueOf(input) : null;
    }

    static MockResponse jsonResponse(byte[] content) {
        return new MockResponse().addHeader("Content-Type", (Object)"application/json").setBody(new Buffer().write(content));
    }
}

