/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;
import io.vertx.ext.mail.MailService;
import io.vertx.serviceproxy.ProxyHandler;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MailServiceVertxProxyHandler
extends ProxyHandler {
    public static final long DEFAULT_CONNECTION_TIMEOUT = 300L;
    private final Vertx vertx;
    private final MailService service;
    private final long timerID;
    private long lastAccessed;
    private final long timeoutSeconds;

    public MailServiceVertxProxyHandler(Vertx vertx, MailService service) {
        this(vertx, service, 300L);
    }

    public MailServiceVertxProxyHandler(Vertx vertx, MailService service, long timeoutInSecond) {
        this(vertx, service, true, timeoutInSecond);
    }

    public MailServiceVertxProxyHandler(Vertx vertx, MailService service, boolean topLevel, long timeoutSeconds) {
        this.vertx = vertx;
        this.service = service;
        this.timeoutSeconds = timeoutSeconds;
        try {
            this.vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (timeoutSeconds != -1L && !topLevel) {
            long period = timeoutSeconds * 1000L / 2L;
            if (period > 10000L) {
                period = 10000L;
            }
            this.timerID = vertx.setPeriodic(period, this::checkTimedOut);
        } else {
            this.timerID = -1L;
        }
        this.accessed();
    }

    public MessageConsumer<JsonObject> registerHandler(String address) {
        MessageConsumer consumer = this.vertx.eventBus().consumer(address).handler((Handler)this);
        this.setConsumer(consumer);
        return consumer;
    }

    private void checkTimedOut(long id) {
        long now = System.nanoTime();
        if (now - this.lastAccessed > this.timeoutSeconds * 1000000000L) {
            this.close();
        }
    }

    public void close() {
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        super.close();
    }

    private void accessed() {
        this.lastAccessed = System.nanoTime();
    }

    public void handle(Message<JsonObject> msg) {
        try {
            JsonObject json = (JsonObject)msg.body();
            String action = msg.headers().get("action");
            if (action == null) {
                throw new IllegalStateException("action not specified");
            }
            this.accessed();
            switch (action) {
                case "sendMail": {
                    this.service.sendMail(json.getJsonObject("email") == null ? null : new MailMessage(json.getJsonObject("email")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((MailResult)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "close": {
                    this.service.close();
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid action: " + action);
                }
            }
        }
        catch (Throwable t) {
            msg.reply((Object)new ServiceException(500, t.getMessage()));
            throw t;
        }
    }

    private <T> Handler<AsyncResult<T>> createHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else if (res.result() != null && res.result().getClass().isEnum()) {
                msg.reply((Object)((Enum)res.result()).name());
            } else {
                msg.reply(res.result());
            }
        };
    }

    private <T> Handler<AsyncResult<List<T>>> createListHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else {
                msg.reply((Object)new JsonArray((List)res.result()));
            }
        };
    }

    private <T> Handler<AsyncResult<Set<T>>> createSetHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else {
                msg.reply((Object)new JsonArray(new ArrayList((Collection)res.result())));
            }
        };
    }

    private Handler<AsyncResult<List<Character>>> createListCharHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else {
                JsonArray arr = new JsonArray();
                for (Character chr : (List)res.result()) {
                    arr.add(Integer.valueOf(chr.charValue()));
                }
                msg.reply((Object)arr);
            }
        };
    }

    private Handler<AsyncResult<Set<Character>>> createSetCharHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else {
                JsonArray arr = new JsonArray();
                for (Character chr : (Set)res.result()) {
                    arr.add(Integer.valueOf(chr.charValue()));
                }
                msg.reply((Object)arr);
            }
        };
    }

    private <T> Map<String, T> convertMap(Map map) {
        return map;
    }

    private <T> List<T> convertList(List list) {
        return list;
    }

    private <T> Set<T> convertSet(List list) {
        return new HashSet(list);
    }
}

