/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqpbridge.impl;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.proton.amqp.Symbol;

public class BridgeMetaDataSupportImpl {
    private static final Logger LOG;
    public static final String PRODUCT = "vertx-amqp-bridge";
    public static final Symbol PRODUCT_KEY;
    public static final String VERSION;
    public static final Symbol VERSION_KEY;

    static {
        String version;
        block27: {
            LOG = LoggerFactory.getLogger(BridgeMetaDataSupportImpl.class);
            PRODUCT_KEY = Symbol.valueOf((String)"product");
            VERSION_KEY = Symbol.valueOf((String)"version");
            version = "unknown";
            try {
                String path = BridgeMetaDataSupportImpl.class.getPackage().getName().replace(".", "/");
                try (InputStream in = BridgeMetaDataSupportImpl.class.getResourceAsStream("/" + path + "/version.txt");){
                    if (in == null) break block27;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                        String line = reader.readLine();
                        if (line != null && !line.isEmpty()) {
                            version = line;
                        }
                    }
                }
            }
            catch (Throwable err) {
                LOG.warn((Object)"Problem determining version details", err);
            }
        }
        VERSION = version;
    }
}

