/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqpbridge.impl;

import io.vertx.amqpbridge.impl.AmqpBridgeImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonHelper;

public class AmqpMessageImpl
implements Message<JsonObject> {
    private final JsonObject body;
    private final AmqpBridgeImpl bridge;
    private final org.apache.qpid.proton.message.Message protonMessage;
    private final ProtonDelivery delivery;
    private final String amqpAddress;
    private final String amqpReplyAddress;

    public AmqpMessageImpl(JsonObject body, AmqpBridgeImpl bridge, org.apache.qpid.proton.message.Message protonMessage, ProtonDelivery delivery, String amqpAddress, String amqpReplyAddress) {
        this.body = body;
        this.bridge = bridge;
        this.protonMessage = protonMessage;
        this.delivery = delivery;
        this.amqpAddress = amqpAddress;
        this.amqpReplyAddress = amqpReplyAddress;
    }

    public String address() {
        return this.amqpAddress;
    }

    public MultiMap headers() {
        throw new UnsupportedOperationException("Use the AMQP application-properties section via the JsonObject payload body, headers method is not supported");
    }

    public JsonObject body() {
        return this.body;
    }

    public String replyAddress() {
        return this.amqpReplyAddress;
    }

    private <R> void doReply(Object replyMessageBody, Handler<AsyncResult<Message<R>>> replyHandler) {
        if (!(replyMessageBody instanceof JsonObject)) {
            throw new IllegalArgumentException("The reply body must be an instance of JsonObject");
        }
        this.bridge.sendReply(this.protonMessage, (JsonObject)replyMessageBody, replyHandler);
    }

    public void reply(Object replyMessageBody) {
        this.doReply(replyMessageBody, null);
    }

    public <R> void reply(Object replyMessageBody, Handler<AsyncResult<Message<R>>> replyHandler) {
        this.doReply(replyMessageBody, replyHandler);
    }

    public void reply(Object messageBody, DeliveryOptions options) {
        throw new UnsupportedOperationException("DeliveryOptions are not supported");
    }

    public <R> void reply(Object messageBody, DeliveryOptions options, Handler<AsyncResult<Message<R>>> replyHandler) {
        throw new UnsupportedOperationException("DeliveryOptions are not supported");
    }

    public void fail(int failureCode, String message) {
        throw new UnsupportedOperationException("Implicit failure responses are not supported, send a message explicitly.");
    }

    void accept() {
        ProtonHelper.accepted((ProtonDelivery)this.delivery, (boolean)true);
    }
}

