/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqpbridge;

import io.vertx.amqpbridge.AmqpBridgeOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.proton.ProtonClientOptions;

@DataObject(generateConverter=true, inheritConverter=true)
public class AmqpBridgeOptions
extends ProtonClientOptions {
    private boolean replyHandlingSupport = true;
    private String containerId;
    private String vhost;

    public AmqpBridgeOptions() {
    }

    public AmqpBridgeOptions(JsonObject json) {
        AmqpBridgeOptionsConverter.fromJson(json, this);
    }

    public AmqpBridgeOptions setContainerId(String containerId) {
        this.containerId = containerId;
        return this;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public AmqpBridgeOptions setVhost(String vhost) {
        this.vhost = vhost;
        return this;
    }

    public String getVhost() {
        return this.vhost;
    }

    public AmqpBridgeOptions setReplyHandlingSupport(boolean replyHandlingSupport) {
        this.replyHandlingSupport = replyHandlingSupport;
        return this;
    }

    public boolean isReplyHandlingSupport() {
        return this.replyHandlingSupport;
    }

    public AmqpBridgeOptions addEnabledSaslMechanism(String saslMechanism) {
        super.addEnabledSaslMechanism(saslMechanism);
        return this;
    }

    public AmqpBridgeOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    public AmqpBridgeOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    public AmqpBridgeOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    public AmqpBridgeOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    public AmqpBridgeOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    public AmqpBridgeOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    public AmqpBridgeOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    public AmqpBridgeOptions setUsePooledBuffers(boolean usePooledBuffers) {
        super.setUsePooledBuffers(usePooledBuffers);
        return this;
    }

    public AmqpBridgeOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    public AmqpBridgeOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    public AmqpBridgeOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    public AmqpBridgeOptions setPfxKeyCertOptions(PfxOptions options) {
        super.setPfxKeyCertOptions(options);
        return this;
    }

    public AmqpBridgeOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        super.setPemKeyCertOptions(options);
        return this;
    }

    public AmqpBridgeOptions setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    public AmqpBridgeOptions setPemTrustOptions(PemTrustOptions options) {
        super.setPemTrustOptions(options);
        return this;
    }

    public AmqpBridgeOptions setPfxTrustOptions(PfxOptions options) {
        super.setPfxTrustOptions(options);
        return this;
    }

    public AmqpBridgeOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    public AmqpBridgeOptions addCrlPath(String crlPath) throws NullPointerException {
        super.addCrlPath(crlPath);
        return this;
    }

    public AmqpBridgeOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        super.addCrlValue(crlValue);
        return this;
    }

    public AmqpBridgeOptions setTrustAll(boolean trustAll) {
        super.setTrustAll(trustAll);
        return this;
    }

    public AmqpBridgeOptions setConnectTimeout(int connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    public AmqpBridgeOptions setReconnectAttempts(int attempts) {
        super.setReconnectAttempts(attempts);
        return this;
    }

    public AmqpBridgeOptions setReconnectInterval(long interval) {
        super.setReconnectInterval(interval);
        return this;
    }

    public AmqpBridgeOptions setUseAlpn(boolean useAlpn) {
        throw new UnsupportedOperationException();
    }

    public AmqpBridgeOptions addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public AmqpBridgeOptions setHostnameVerificationAlgorithm(String hostnameVerificationAlgorithm) {
        super.setHostnameVerificationAlgorithm(hostnameVerificationAlgorithm);
        return this;
    }

    public AmqpBridgeOptions setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    public AmqpBridgeOptions setLogActivity(boolean logEnabled) {
        super.setLogActivity(logEnabled);
        return this;
    }

    public AmqpBridgeOptions setMetricsName(String metricsName) {
        super.setMetricsName(metricsName);
        return this;
    }

    public AmqpBridgeOptions setProxyOptions(ProxyOptions proxyOptions) {
        super.setProxyOptions(proxyOptions);
        return this;
    }

    public AmqpBridgeOptions setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    public AmqpBridgeOptions setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        super.setJdkSslEngineOptions(sslEngineOptions);
        return this;
    }

    public AmqpBridgeOptions setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        super.setOpenSslEngineOptions(sslEngineOptions);
        return this;
    }

    public AmqpBridgeOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        super.setSslEngineOptions(sslEngineOptions);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.replyHandlingSupport ? 1231 : 1237);
        result = 31 * result + (this.containerId == null ? 0 : this.containerId.hashCode());
        result = 31 * result + (this.vhost == null ? 0 : this.vhost.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AmqpBridgeOptions other = (AmqpBridgeOptions)((Object)obj);
        if (this.replyHandlingSupport != other.replyHandlingSupport) {
            return false;
        }
        if (this.containerId == null ? other.containerId != null : !this.containerId.equals(other.containerId)) {
            return false;
        }
        return !(this.vhost == null ? other.vhost != null : !this.vhost.equals(other.vhost));
    }
}

