/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.model;

import io.sundr.codegen.model.AbstractTypeRef;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.PrimitiveRefBuilder;
import io.sundr.codegen.model.TypeRef;
import java.util.Map;

public class PrimitiveRef
extends AbstractTypeRef {
    private final String name;
    private final int dimensions;

    public PrimitiveRef(String name, int dimensions, Map<String, Object> attributes) {
        super(attributes);
        this.name = name;
        this.dimensions = dimensions;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public PrimitiveRef withDimensions(int dimensions) {
        return ((PrimitiveRefBuilder)new PrimitiveRefBuilder(this).withDimensions(dimensions)).build();
    }

    @Override
    public boolean isAssignableFrom(TypeRef o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ClassRef) {
            if (!((ClassRef)o).getDefinition().getPackageName().equals("java.lang")) {
                return false;
            }
            return ((ClassRef)o).getDefinition().getName().toUpperCase().startsWith(this.name.toUpperCase());
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimitiveRef that = (PrimitiveRef)o;
        if (this.dimensions != that.dimensions) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimitiveRef that = (PrimitiveRef)o;
        if (this.dimensions != that.dimensions) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.dimensions;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        for (int i = 0; i < this.dimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }
}

