/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.model;

import io.sundr.codegen.model.AbstractTypeRef;
import io.sundr.codegen.model.ClassRefBuilder;
import io.sundr.codegen.model.PrimitiveRef;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.utils.StringUtils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassRef
extends AbstractTypeRef {
    public static final String UNKWNON = "<unkwnon>";
    public static final String BRACKETS = "[]";
    public static final ClassRef OBJECT = ((ClassRefBuilder)new ClassRefBuilder().withDefinition(TypeDef.OBJECT)).build();
    private final TypeDef definition;
    private final int dimensions;
    private final List<TypeRef> arguments;

    public ClassRef(TypeDef definition, int dimensions, List<TypeRef> arguments, Map<String, Object> attributes) {
        super(attributes);
        this.definition = definition != null ? definition : new TypeDefBuilder().build();
        this.dimensions = dimensions;
        this.arguments = arguments;
    }

    public TypeDef getDefinition() {
        return this.definition;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    public List<TypeRef> getArguments() {
        return this.arguments;
    }

    @Override
    public ClassRef withDimensions(int dimensions) {
        return ((ClassRefBuilder)new ClassRefBuilder(this).withDimensions(dimensions)).build();
    }

    @Override
    public boolean isAssignableFrom(TypeRef other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof PrimitiveRef) {
            if (!this.getDefinition().getPackageName().equals("java.lang")) {
                return false;
            }
            return this.getDefinition().getName().toUpperCase().startsWith(((PrimitiveRef)other).getName().toUpperCase());
        }
        if (!(other instanceof ClassRef)) {
            return false;
        }
        if (this == other || this.equals(other)) {
            return true;
        }
        return this.definition.isAssignableFrom(((ClassRef)other).getDefinition());
    }

    public Set<ClassRef> getReferences() {
        LinkedHashSet<ClassRef> refs = new LinkedHashSet<ClassRef>();
        for (TypeRef argument : this.arguments) {
            if (!(argument instanceof ClassRef)) continue;
            refs.addAll(((ClassRef)argument).getReferences());
        }
        refs.add(this);
        return refs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassRef classRef = (ClassRef)o;
        if (this.dimensions != classRef.dimensions) {
            return false;
        }
        if (this.definition != null ? !this.definition.equals(classRef.definition) : classRef.definition != null) {
            return false;
        }
        return this.arguments != null ? this.arguments.equals(classRef.arguments) : classRef.arguments == null;
    }

    public int hashCode() {
        int result = this.definition != null ? this.definition.hashCode() : 0;
        result = 31 * result + this.dimensions;
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.definition == null) {
            sb.append(UNKWNON);
        } else if (this.definition.getOuterType() != null) {
            sb.append(this.definition.getOuterType().getName()).append(".").append(this.definition.getName());
        } else {
            sb.append(this.definition.getName());
        }
        if (this.arguments.size() > 0) {
            sb.append("<");
            sb.append(StringUtils.join(this.arguments, ","));
            sb.append(">");
        }
        for (int i = 0; i < this.dimensions; ++i) {
            sb.append(BRACKETS);
        }
        return sb.toString();
    }
}

