/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.functions;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.NamedNode;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.TypeParameter;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.QualifiedNameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.type.WildcardType;
import io.sundr.builder.Function;
import io.sundr.codegen.DefinitionRepository;
import io.sundr.codegen.model.Block;
import io.sundr.codegen.model.BlockBuilder;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.ClassRefBuilder;
import io.sundr.codegen.model.ClassRefFluent;
import io.sundr.codegen.model.EditableClassRef;
import io.sundr.codegen.model.Kind;
import io.sundr.codegen.model.Method;
import io.sundr.codegen.model.MethodBuilder;
import io.sundr.codegen.model.PrimitiveRef;
import io.sundr.codegen.model.PrimitiveRefBuilder;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.PropertyBuilder;
import io.sundr.codegen.model.StringStatement;
import io.sundr.codegen.model.StringStatementBuilder;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeParamDef;
import io.sundr.codegen.model.TypeParamDefBuilder;
import io.sundr.codegen.model.TypeParamRef;
import io.sundr.codegen.model.TypeParamRefBuilder;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.model.VoidRef;
import io.sundr.codegen.model.WildcardRef;
import io.sundr.codegen.model.WildcardRefBuilder;
import io.sundr.codegen.utils.IOUtils;
import io.sundr.codegen.utils.TypeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class Sources {
    private static final String JAVA_LANG = "java.lang";
    private static final String SEPARATOR = ".";
    public static final String INIT = "INIT";
    private static Function<Node, String> PACKAGENAME = new Function<Node, String>(){

        public String apply(Node node) {
            if (node instanceof NamedNode) {
                String name = ((NamedNode)node).getName();
                Node current = node;
                while (!(current instanceof CompilationUnit)) {
                    current = current.getParentNode();
                }
                CompilationUnit compilationUnit = (CompilationUnit)current;
                for (ImportDeclaration importDecl : compilationUnit.getImports()) {
                    NameExpr importExpr = importDecl.getName();
                    if (importExpr instanceof QualifiedNameExpr) {
                        QualifiedNameExpr qualifiedNameExpr = (QualifiedNameExpr)importExpr;
                        String className = qualifiedNameExpr.getName();
                        if (!name.equals(className)) continue;
                        return qualifiedNameExpr.getQualifier().toString();
                    }
                    if (!importDecl.getName().getName().endsWith(Sources.SEPARATOR + name)) continue;
                    String importName = importDecl.getName().getName();
                    return importName.substring(0, importName.length() - name.length() - 1);
                }
                try {
                    Class.forName("java.lang." + name);
                    return Sources.JAVA_LANG;
                }
                catch (ClassNotFoundException ex) {
                    return compilationUnit.getPackage().getPackageName();
                }
            }
            return null;
        }
    };
    private static Function<Node, Set<ClassRef>> IMPORTS = new Function<Node, Set<ClassRef>>(){

        public Set<ClassRef> apply(Node node) {
            LinkedHashSet<ClassRef> imports = new LinkedHashSet<ClassRef>();
            if (node instanceof NamedNode) {
                String name = ((NamedNode)node).getName();
                Node current = node;
                while (!(current instanceof CompilationUnit)) {
                    current = current.getParentNode();
                }
                CompilationUnit compilationUnit = (CompilationUnit)current;
                for (ImportDeclaration importDecl : compilationUnit.getImports()) {
                    String className = null;
                    String packageName = null;
                    NameExpr importExpr = importDecl.getName();
                    if (importExpr instanceof QualifiedNameExpr) {
                        QualifiedNameExpr qualifiedNameExpr = (QualifiedNameExpr)importExpr;
                        className = qualifiedNameExpr.getName();
                        packageName = qualifiedNameExpr.getQualifier().toString();
                    } else if (importDecl.getName().getName().endsWith(Sources.SEPARATOR + name)) {
                        String importName = importDecl.getName().getName();
                        packageName = importName.substring(0, importName.length() - name.length() - 1);
                    }
                    if (className == null || className.isEmpty()) continue;
                    imports.add(((ClassRefBuilder)((ClassRefFluent.DefinitionNested)((ClassRefFluent.DefinitionNested)new ClassRefBuilder().withNewDefinition().withName(className)).withPackageName(packageName)).and()).build());
                }
            }
            return imports;
        }
    };
    private static Function<ClassOrInterfaceType, TypeRef> CLASS_OR_TYPEPARAM_REF = new Function<ClassOrInterfaceType, TypeRef>(){

        public TypeRef apply(ClassOrInterfaceType classOrInterfaceType) {
            String boundPackage = (String)PACKAGENAME.apply((Object)classOrInterfaceType);
            String boundName = classOrInterfaceType.getName();
            ArrayList<TypeRef> arguments = new ArrayList<TypeRef>();
            for (Type arg : classOrInterfaceType.getTypeArgs()) {
                if (arg instanceof ReferenceType) {
                    ReferenceType referenceType = (ReferenceType)arg;
                    Type type = referenceType.getType();
                    int dimensions = referenceType.getArrayCount();
                    if (type instanceof ClassOrInterfaceType) {
                        TypeRef intermediateRef = (TypeRef)CLASS_OR_TYPEPARAM_REF.apply((Object)((ClassOrInterfaceType)type));
                        if (intermediateRef instanceof ClassRef) {
                            arguments.add(((ClassRefBuilder)new ClassRefBuilder((ClassRef)intermediateRef).withDimensions(dimensions)).build());
                            continue;
                        }
                        if (intermediateRef instanceof TypeParamRef) {
                            arguments.add(((TypeParamRefBuilder)new TypeParamRefBuilder((TypeParamRef)intermediateRef).withDimensions(dimensions)).build());
                            continue;
                        }
                        throw new IllegalStateException("Expected class or type param reference");
                    }
                    String name = referenceType.toString();
                    arguments.add(((TypeParamRefBuilder)((TypeParamRefBuilder)new TypeParamRefBuilder().withName(name)).withDimensions(dimensions)).build());
                    continue;
                }
                if (!(arg instanceof WildcardType)) continue;
                WildcardType wildcardType = (WildcardType)arg;
                if (wildcardType.getExtends() != null) {
                    TypeRef bound = (TypeRef)TYPEREF.apply((Object)wildcardType.getExtends());
                    arguments.add(((WildcardRefBuilder)new WildcardRefBuilder().addToBounds(bound)).build());
                    continue;
                }
                arguments.add(new WildcardRef());
            }
            EditableClassRef tmpRef = ((ClassRefBuilder)((ClassRefBuilder)((ClassRefFluent.DefinitionNested)((ClassRefFluent.DefinitionNested)new ClassRefBuilder().withNewDefinition().withPackageName(boundPackage)).withName(boundName)).endDefinition()).withArguments(arguments)).build();
            TypeDef knwonDefition = DefinitionRepository.getRepository().getDefinition(tmpRef);
            if (knwonDefition != null) {
                return ((ClassRefBuilder)new ClassRefBuilder(tmpRef).withDefinition(knwonDefition)).build();
            }
            if (classOrInterfaceType.getTypeArgs().isEmpty() && boundName.length() == 1) {
                return ((TypeParamRefBuilder)new TypeParamRefBuilder().withName(boundName)).build();
            }
            return tmpRef;
        }
    };
    private static Function<Type, TypeRef> TYPEREF = new Function<Type, TypeRef>(){

        public TypeRef apply(Type type) {
            if (type instanceof VoidType) {
                return new VoidRef();
            }
            if (type instanceof WildcardType) {
                return new WildcardRef();
            }
            if (type instanceof ReferenceType) {
                ReferenceType referenceType = (ReferenceType)type;
                int dimensions = referenceType.getArrayCount();
                TypeRef typeRef = (TypeRef)TYPEREF.apply((Object)referenceType.getType());
                if (dimensions == 0) {
                    return typeRef;
                }
                if (typeRef instanceof ClassRef) {
                    return ((ClassRefBuilder)new ClassRefBuilder((ClassRef)typeRef).withDimensions(dimensions)).build();
                }
                if (typeRef instanceof PrimitiveRef) {
                    return ((PrimitiveRefBuilder)new PrimitiveRefBuilder((PrimitiveRef)typeRef).withDimensions(dimensions)).build();
                }
                if (typeRef instanceof TypeParamRef) {
                    return ((TypeParamRefBuilder)new TypeParamRefBuilder((TypeParamRef)typeRef).withDimensions(dimensions)).build();
                }
            } else {
                if (type instanceof PrimitiveType) {
                    PrimitiveType primitiveType = (PrimitiveType)type;
                    return ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName(primitiveType.getType().name())).build();
                }
                if (type instanceof ClassOrInterfaceType) {
                    return (TypeRef)CLASS_OR_TYPEPARAM_REF.apply((Object)((ClassOrInterfaceType)type));
                }
            }
            throw new IllegalArgumentException("Can't handle type:[" + type + "].");
        }
    };
    private static Function<TypeParameter, TypeParamDef> TYPEPARAMDEF = new Function<TypeParameter, TypeParamDef>(){

        public TypeParamDef apply(TypeParameter typeParameter) {
            ArrayList<ClassRef> bounds = new ArrayList<ClassRef>();
            for (ClassOrInterfaceType classOrInterfaceType : typeParameter.getTypeBound()) {
                bounds.add((ClassRef)CLASS_OR_TYPEPARAM_REF.apply((Object)classOrInterfaceType));
            }
            return ((TypeParamDefBuilder)((TypeParamDefBuilder)new TypeParamDefBuilder().withName(typeParameter.getName())).withBounds(bounds)).build();
        }
    };
    private static Function<AnnotationExpr, ClassRef> ANNOTATIONREF = new Function<AnnotationExpr, ClassRef>(){

        public ClassRef apply(AnnotationExpr annotation) {
            String name = annotation.getName().getName();
            String packageName = (String)PACKAGENAME.apply((Object)annotation);
            return ((ClassRefBuilder)((ClassRefFluent.DefinitionNested)((ClassRefFluent.DefinitionNested)new ClassRefBuilder().withNewDefinition().withName(name)).withPackageName(packageName)).endDefinition()).build();
        }
    };
    private static final Function<Statement, StringStatement> STATEMENT = new Function<Statement, StringStatement>(){

        public StringStatement apply(Statement stmt) {
            return ((StringStatementBuilder)new StringStatementBuilder().withData(stmt.toString())).build();
        }
    };
    private static final Function<BlockStmt, Block> BLOCK = new Function<BlockStmt, Block>(){

        public Block apply(BlockStmt block) {
            ArrayList<io.sundr.codegen.model.Statement> statements = new ArrayList<io.sundr.codegen.model.Statement>();
            if (block != null) {
                for (Statement stmt : block.getStmts()) {
                    statements.add((io.sundr.codegen.model.Statement)STATEMENT.apply((Object)stmt));
                }
            }
            return ((BlockBuilder)new BlockBuilder().withStatements(statements)).build();
        }
    };
    public static Function<TypeDeclaration, TypeDef> TYPEDEF = new Function<TypeDeclaration, TypeDef>(){

        public TypeDef apply(TypeDeclaration type) {
            if (type instanceof ClassOrInterfaceDeclaration) {
                ClassOrInterfaceDeclaration decl = (ClassOrInterfaceDeclaration)type;
                Kind kind = decl.isInterface() ? Kind.INTERFACE : Kind.CLASS;
                ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>();
                LinkedHashSet<ClassRef> extendsList = new LinkedHashSet<ClassRef>();
                LinkedHashSet<ClassRef> implementsList = new LinkedHashSet<ClassRef>();
                LinkedHashSet<Property> properties = new LinkedHashSet<Property>();
                LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
                LinkedHashSet<Method> constructors = new LinkedHashSet<Method>();
                for (TypeParameter typeParameter : decl.getTypeParameters()) {
                    parameters.add((TypeParamDef)TYPEPARAMDEF.apply((Object)typeParameter));
                }
                for (ClassOrInterfaceType classOrInterfaceType : decl.getExtends()) {
                    extendsList.add((ClassRef)CLASS_OR_TYPEPARAM_REF.apply((Object)classOrInterfaceType));
                }
                for (ClassOrInterfaceType classOrInterfaceType : decl.getImplements()) {
                    implementsList.add((ClassRef)CLASS_OR_TYPEPARAM_REF.apply((Object)classOrInterfaceType));
                }
                for (BodyDeclaration bodyDeclaration : decl.getMembers()) {
                    LinkedHashSet<ClassRef> exceptions;
                    ArrayList<Property> arguments;
                    if (bodyDeclaration instanceof FieldDeclaration) {
                        FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                        for (VariableDeclarator var : fieldDeclaration.getVariables()) {
                            TypeRef typeRef = this.checkAgainstTypeParamRef((TypeRef)TYPEREF.apply((Object)fieldDeclaration.getType()), parameters);
                            properties.add(((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(var.getId().getName())).withTypeRef(typeRef)).withModifiers(fieldDeclaration.getModifiers())).addToAttributes(Sources.INIT, var.getInit() != null ? var.getInit().toStringWithoutComments() : null)).build());
                        }
                        continue;
                    }
                    if (bodyDeclaration instanceof MethodDeclaration) {
                        MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                        arguments = new ArrayList<Property>();
                        exceptions = new LinkedHashSet<ClassRef>();
                        for (ReferenceType referenceType : methodDeclaration.getThrows()) {
                            TypeRef exceptionRef = (TypeRef)TYPEREF.apply((Object)referenceType.getType());
                            if (!(exceptionRef instanceof ClassRef)) continue;
                            exceptions.add((ClassRef)exceptionRef);
                        }
                        Boolean preferVarArg = false;
                        for (Parameter parameter : methodDeclaration.getParameters()) {
                            LinkedHashSet<ClassRef> annotations = new LinkedHashSet<ClassRef>();
                            for (AnnotationExpr annotationExpr : parameter.getAnnotations()) {
                                annotations.add((ClassRef)ANNOTATIONREF.apply((Object)annotationExpr));
                            }
                            TypeRef typeRef = (TypeRef)TYPEREF.apply((Object)parameter.getType());
                            if (parameter.isVarArgs()) {
                                preferVarArg = true;
                                typeRef = typeRef.withDimensions(typeRef.getDimensions() + 1);
                            }
                            arguments.add(((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(parameter.getId().getName())).withTypeRef(typeRef)).withModifiers(parameter.getModifiers())).withAnnotations(annotations)).build());
                        }
                        LinkedHashSet<TypeParamDef> typeParamDefs = new LinkedHashSet<TypeParamDef>();
                        for (TypeParameter typeParameter : methodDeclaration.getTypeParameters()) {
                            typeParamDefs.add((TypeParamDef)TYPEPARAMDEF.apply((Object)typeParameter));
                        }
                        TypeRef returnType = this.checkAgainstTypeParamRef((TypeRef)TYPEREF.apply((Object)methodDeclaration.getType()), parameters);
                        methods.add(((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withName(methodDeclaration.getName())).withModifiers(methodDeclaration.getModifiers())).withParameters(typeParamDefs)).withVarArgPreferred(preferVarArg)).withReturnType(returnType)).withExceptions(exceptions)).withArguments(arguments)).withBlock((Block)BLOCK.apply((Object)methodDeclaration.getBody()))).build());
                        continue;
                    }
                    if (!(bodyDeclaration instanceof ConstructorDeclaration)) continue;
                    ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)bodyDeclaration;
                    arguments = new ArrayList();
                    exceptions = new LinkedHashSet();
                    for (NameExpr nameExpr : constructorDeclaration.getThrows()) {
                        String name = nameExpr.getName();
                        String packageName = (String)PACKAGENAME.apply((Object)nameExpr);
                        exceptions.add(((ClassRefBuilder)((ClassRefFluent.DefinitionNested)((ClassRefFluent.DefinitionNested)new ClassRefBuilder().withNewDefinition().withName(name)).withPackageName(packageName)).endDefinition()).build());
                    }
                    for (Parameter parameter : constructorDeclaration.getParameters()) {
                        LinkedHashSet<ClassRef> annotations = new LinkedHashSet<ClassRef>();
                        for (AnnotationExpr annotationExpr : parameter.getAnnotations()) {
                            annotations.add((ClassRef)ANNOTATIONREF.apply((Object)annotationExpr));
                        }
                        TypeRef typeRef = this.checkAgainstTypeParamRef((TypeRef)TYPEREF.apply((Object)parameter.getType()), parameters);
                        arguments.add(((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(parameter.getId().getName())).withTypeRef(typeRef)).withModifiers(parameter.getModifiers())).withAnnotations(annotations)).build());
                    }
                    constructors.add(((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(constructorDeclaration.getModifiers())).withExceptions(exceptions)).withArguments(arguments)).withBlock((Block)BLOCK.apply((Object)constructorDeclaration.getBlock()))).build());
                }
                return DefinitionRepository.getRepository().register(((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withKind(kind)).withPackageName((String)PACKAGENAME.apply((Object)type))).withName(decl.getName())).withModifiers(type.getModifiers())).withParameters(parameters)).withExtendsList(extendsList)).withImplementsList(implementsList)).withProperties(properties)).withMethods(methods)).withConstructors(constructors)).addToAttributes("ALSO_IMPORT", IMPORTS.apply((Object)type))).build());
            }
            throw new IllegalArgumentException("Unsupported TypeDeclaration:[" + type + "].");
        }

        private TypeRef checkAgainstTypeParamRef(TypeRef typeRef, Collection<TypeParamDef> parameters) {
            TypeParamDef parameterDef = TypeUtils.getParamterDefinition(typeRef, parameters);
            if (parameterDef != null) {
                return parameterDef.toReference();
            }
            return typeRef;
        }
    };
    public static Function<File, CompilationUnit> FROM_FILE_TO_COMPILATIONUNIT = new Function<File, CompilationUnit>(){

        public CompilationUnit apply(File file) {
            CompilationUnit compilationUnit;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                compilationUnit = JavaParser.parse((InputStream)fis);
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException("Failed to load file: [" + file.getAbsolutePath() + "] from file system.");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(fis);
            return compilationUnit;
        }
    };
    public static Function<String, CompilationUnit> FROM_CLASSPATH_TO_COMPILATIONUNIT = new Function<String, CompilationUnit>(){

        public CompilationUnit apply(String resource) {
            CompilationUnit compilationUnit;
            InputStream is = null;
            try {
                is = this.getClass().getClassLoader().getResourceAsStream(resource);
                compilationUnit = JavaParser.parse((InputStream)is);
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException("Failed to load resource: [" + resource + "] from classpath.");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(is);
            return compilationUnit;
        }
    };
    public static Function<InputStream, CompilationUnit> FROM_INPUTSTREAM_TO_COMPILATIONUNIT = new Function<InputStream, CompilationUnit>(){

        public CompilationUnit apply(InputStream is) {
            CompilationUnit compilationUnit;
            try {
                compilationUnit = JavaParser.parse((InputStream)is);
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException("Failed to parse stream.", ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(is);
            return compilationUnit;
        }
    };
    public static Function<String, TypeDef> FROM_CLASSPATH_TO_SINGLE_TYPEDEF = new Function<String, TypeDef>(){

        public TypeDef apply(String resource) {
            CompilationUnit cu = (CompilationUnit)FROM_CLASSPATH_TO_COMPILATIONUNIT.apply((Object)resource);
            TypeDeclaration typeDeclaration = (TypeDeclaration)cu.getTypes().get(0);
            return (TypeDef)TYPEDEF.apply((Object)typeDeclaration);
        }
    };
    public static Function<InputStream, TypeDef> FROM_INPUTSTEAM_TO_SINGLE_TYPEDEF = new Function<InputStream, TypeDef>(){

        public TypeDef apply(InputStream is) {
            CompilationUnit cu = (CompilationUnit)FROM_INPUTSTREAM_TO_COMPILATIONUNIT.apply((Object)is);
            TypeDeclaration typeDeclaration = (TypeDeclaration)cu.getTypes().get(0);
            return (TypeDef)TYPEDEF.apply((Object)typeDeclaration);
        }
    };
}

