/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.functions;

import io.sundr.Function;
import io.sundr.FunctionFactory;
import io.sundr.codegen.CodegenContext;
import io.sundr.codegen.DefinitionRepository;
import io.sundr.codegen.converters.TypeRefTypeVisitor;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.ClassRefBuilder;
import io.sundr.codegen.model.EditableTypeDef;
import io.sundr.codegen.model.EditableTypeParamDef;
import io.sundr.codegen.model.Kind;
import io.sundr.codegen.model.Method;
import io.sundr.codegen.model.MethodBuilder;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.PropertyBuilder;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeParamDef;
import io.sundr.codegen.model.TypeParamDefBuilder;
import io.sundr.codegen.model.TypeParamRef;
import io.sundr.codegen.model.TypeParamRefBuilder;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.model.VoidRef;
import io.sundr.codegen.utils.ModelUtils;
import io.sundr.codegen.utils.TypeUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;

public class ElementTo {
    private static final String OBJECT_BOUND = "java.lang.Object";
    private static final String JAVA_PEFIX = "java.";
    private static final String JAVAX_PEFIX = "javax.";
    private static final String COM_SUN_PREFIX = "com.sun.";
    private static final Function<TypeMirror, Boolean> IS_JAVA_TYPE_MIRROR = new Function<TypeMirror, Boolean>(){

        public Boolean apply(TypeMirror item) {
            String fqn = item.toString();
            return fqn.startsWith(ElementTo.JAVA_PEFIX) || fqn.startsWith(ElementTo.JAVAX_PEFIX) || fqn.startsWith(ElementTo.COM_SUN_PREFIX);
        }
    };
    private static final Function<TypeElement, Boolean> IS_JAVA_ELEMENT = new Function<TypeElement, Boolean>(){

        public Boolean apply(TypeElement item) {
            String fqn = item.toString();
            return fqn.startsWith(ElementTo.JAVA_PEFIX) || fqn.startsWith(ElementTo.JAVAX_PEFIX) || fqn.startsWith(ElementTo.COM_SUN_PREFIX);
        }
    };
    private static final Function<TypeMirror, TypeRef> DEEP_MIRROR_TO_TYPEREF = new Function<TypeMirror, TypeRef>(){

        public TypeRef apply(TypeMirror item) {
            TypeRef typeRef;
            TypeDef known;
            if (item instanceof NoType) {
                return new VoidRef();
            }
            Element element = CodegenContext.getContext().getTypes().asElement(item);
            TypeDef typeDef = known = element != null ? CodegenContext.getContext().getDefinitionRepository().getDefinition(element.toString()) : null;
            if (known == null && element instanceof TypeElement) {
                known = (TypeDef)TYPEDEF.apply((Object)((TypeElement)element));
            }
            if ((typeRef = item.accept(new TypeRefTypeVisitor(), 0)) instanceof ClassRef && known != null) {
                return ((ClassRefBuilder)new ClassRefBuilder((ClassRef)typeRef).withDefinition(known)).build();
            }
            return typeRef;
        }
    };
    private static final Function<TypeMirror, TypeRef> SHALLOW_MIRROR_TO_TYPEREF = new Function<TypeMirror, TypeRef>(){

        public TypeRef apply(TypeMirror item) {
            return item.accept(new TypeRefTypeVisitor(), 0);
        }
    };
    public static final Function<TypeMirror, TypeRef> MIRROR_TO_TYPEREF = FunctionFactory.cache(DEEP_MIRROR_TO_TYPEREF).withFallback(SHALLOW_MIRROR_TO_TYPEREF).withFallbackPredicate(IS_JAVA_TYPE_MIRROR).withMaximumRecursionLevel(10).withMaximumNestingDepth(10);
    public static final Function<TypeParameterElement, TypeParamDef> TYPEPARAMDEF = new Function<TypeParameterElement, TypeParamDef>(){

        public TypeParamDef apply(TypeParameterElement item) {
            ArrayList typeRefs = new ArrayList();
            for (TypeMirror typeMirror : item.getBounds()) {
            }
            return ((TypeParamDefBuilder)((TypeParamDefBuilder)new TypeParamDefBuilder().withName(item.getSimpleName().toString())).withBounds(typeRefs.toArray(new ClassRef[typeRefs.size()]))).build();
        }
    };
    public static final Function<TypeVariable, TypeParamRef> TYPEVARIABLE_TO_TYPEPARAM_REF = new Function<TypeVariable, TypeParamRef>(){

        public TypeParamRef apply(TypeVariable item) {
            return ((TypeParamRefBuilder)new TypeParamRefBuilder().withName(item.asElement().getSimpleName().toString())).build();
        }
    };
    public static final Function<VariableElement, Property> PROPERTY = new Function<VariableElement, Property>(){

        public Property apply(VariableElement variableElement) {
            String name = variableElement.getSimpleName().toString();
            TypeRef type = (TypeRef)MIRROR_TO_TYPEREF.apply((Object)variableElement.asType());
            LinkedHashSet<ClassRef> annotations = new LinkedHashSet<ClassRef>();
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                TypeRef annotationType = annotationMirror.getAnnotationType().accept(new TypeRefTypeVisitor(), 0);
                if (annotationType instanceof ClassRef) {
                    annotations.add((ClassRef)annotationType);
                    continue;
                }
                throw new IllegalStateException();
            }
            return ((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(name)).withTypeRef(type)).withAnnotations(annotations)).withModifiers(TypeUtils.modifiersToInt(variableElement.getModifiers()))).build();
        }
    };
    public static final Function<ExecutableElement, Method> METHOD = new Function<ExecutableElement, Method>(){

        public Method apply(ExecutableElement executableElement) {
            MethodBuilder methodBuilder = (MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt(executableElement.getModifiers()))).withName(executableElement.getSimpleName().toString())).withReturnType((TypeRef)MIRROR_TO_TYPEREF.apply((Object)executableElement.getReturnType()));
            for (VariableElement variableElement : executableElement.getParameters()) {
                methodBuilder = (MethodBuilder)methodBuilder.addToArguments((Property)PROPERTY.apply((Object)variableElement));
                LinkedHashSet<ClassRef> linkedHashSet = new LinkedHashSet<ClassRef>();
                for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
                    if (!(typeMirror instanceof ClassRef)) continue;
                    linkedHashSet.add((ClassRef)((Object)typeMirror));
                }
                methodBuilder = (MethodBuilder)methodBuilder.withExceptions(linkedHashSet);
            }
            LinkedHashSet<ClassRef> annotationRefs = new LinkedHashSet<ClassRef>();
            for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
                TypeRef annotationType = (TypeRef)MIRROR_TO_TYPEREF.apply((Object)annotationMirror.getAnnotationType());
                if (annotationType instanceof ClassRef) {
                    annotationRefs.add((ClassRef)annotationType);
                }
                methodBuilder.withAnnotations(annotationRefs);
            }
            return methodBuilder.build();
        }
    };
    public static final Function<TypeElement, TypeDef> INTERNAL_TYPEDEF = new Function<TypeElement, TypeDef>(){

        public TypeDef apply(TypeElement classElement) {
            Kind kind = Kind.CLASS;
            TypeMirror superClass = classElement.getSuperclass();
            TypeRef superClassType = TypeDef.OBJECT_REF;
            if (superClass != null && !(superClass instanceof NoType) && !superClass.toString().equals(TypeDef.OBJECT.getFullyQualifiedName())) {
                superClassType = (TypeRef)MIRROR_TO_TYPEREF.apply((Object)superClass);
            }
            ArrayList<EditableTypeParamDef> genericTypes = new ArrayList<EditableTypeParamDef>();
            ArrayList<ClassRef> interfaces = new ArrayList<ClassRef>();
            if (classElement.getKind() == ElementKind.INTERFACE) {
                kind = Kind.INTERFACE;
            } else if (classElement.getKind() == ElementKind.CLASS) {
                kind = Kind.CLASS;
            }
            for (TypeMirror typeMirror : classElement.getInterfaces()) {
                TypeRef interfaceType = (TypeRef)MIRROR_TO_TYPEREF.apply((Object)typeMirror);
                if (interfaceType instanceof ClassRef) {
                    interfaces.add((ClassRef)interfaceType);
                    continue;
                }
                throw new IllegalStateException("Interface: [" + interfaceType + "] not mapped to a class ref.");
            }
            for (TypeParameterElement typeParameterElement : classElement.getTypeParameters()) {
                TypeMirror bound;
                ArrayList<ClassRef> genericBounds = new ArrayList<ClassRef>();
                if (!typeParameterElement.getBounds().isEmpty() && !ElementTo.OBJECT_BOUND.equals((bound = typeParameterElement.getBounds().get(0)).toString())) {
                    TypeRef boundRef = (TypeRef)MIRROR_TO_TYPEREF.apply((Object)bound);
                    if (boundRef instanceof ClassRef) {
                        genericBounds.add((ClassRef)boundRef);
                    } else {
                        throw new IllegalStateException("Parameter bound: [" + boundRef + "] not mapped to a class ref.");
                    }
                }
                EditableTypeParamDef genericType = ((TypeParamDefBuilder)((TypeParamDefBuilder)new TypeParamDefBuilder().withName(typeParameterElement.getSimpleName().toString())).withBounds(genericBounds.toArray(new ClassRef[genericBounds.size()]))).build();
                genericTypes.add(genericType);
            }
            EditableTypeDef baseType = ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withKind(kind)).withModifiers(TypeUtils.modifiersToInt(classElement.getModifiers()))).withPackageName(ModelUtils.getPackageName(classElement))).withName(ModelUtils.getClassName(classElement))).withParameters(genericTypes.toArray(new TypeParamDef[genericTypes.size()]))).withExtendsList(new ClassRef[]{superClassType instanceof ClassRef ? superClassType : null})).withImplementsList(interfaces.toArray(new ClassRef[interfaces.size()]))).build();
            LinkedHashSet<TypeDef> linkedHashSet = new LinkedHashSet<TypeDef>();
            for (TypeElement innerElement : ElementFilter.typesIn(classElement.getEnclosedElements())) {
                TypeDef innerType = (TypeDef)TYPEDEF.apply((Object)innerElement);
                innerType = ((TypeDefBuilder)new TypeDefBuilder(innerType).withOuterType(baseType)).build();
                DefinitionRepository.getRepository().register(innerType);
                linkedHashSet.add(innerType);
            }
            TypeDefBuilder builder = (TypeDefBuilder)new TypeDefBuilder(baseType).withInnerTypes(linkedHashSet);
            for (ExecutableElement constructor : ElementFilter.constructorsIn(classElement.getEnclosedElements())) {
                builder.addToConstructors((Method)METHOD.apply((Object)constructor));
            }
            for (VariableElement variableElement : ElementFilter.fieldsIn(classElement.getEnclosedElements())) {
                builder.addToProperties((Property)PROPERTY.apply((Object)variableElement));
            }
            LinkedHashSet<ExecutableElement> allMethods = new LinkedHashSet<ExecutableElement>();
            allMethods.addAll(ElementFilter.methodsIn(classElement.getEnclosedElements()));
            allMethods.addAll(this.getInheritedMethods(classElement));
            for (ExecutableElement executableElement : allMethods) {
                builder.addToMethods((Method)METHOD.apply((Object)executableElement));
            }
            for (AnnotationMirror annotationMirror : classElement.getAnnotationMirrors()) {
                TypeRef annotationType = (TypeRef)MIRROR_TO_TYPEREF.apply((Object)annotationMirror.getAnnotationType());
                if (annotationType instanceof ClassRef) {
                    builder.addToAnnotations((ClassRef)annotationType);
                    continue;
                }
                throw new IllegalStateException("Annotation type: [" + annotationType + "] not mapped to a class ref.");
            }
            return DefinitionRepository.getRepository().register(builder.build());
        }

        public Set<ExecutableElement> getInheritedMethods(TypeElement typeElement) {
            LinkedHashSet<ExecutableElement> result = new LinkedHashSet<ExecutableElement>();
            if (typeElement != null) {
                for (ExecutableElement method : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                    if (method.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                    result.add(method);
                }
                result.addAll(this.getInheritedMethods(typeElement.getSuperclass() != null ? CodegenContext.getContext().getElements().getTypeElement(typeElement.getSuperclass().toString()) : null));
            }
            return result;
        }
    };
    public static final Function<TypeElement, TypeDef> SHALLOW_TYPEDEF = new Function<TypeElement, TypeDef>(){

        public TypeDef apply(TypeElement classElement) {
            LinkedHashSet<ClassRef> extendsList = new LinkedHashSet<ClassRef>();
            Kind kind = Kind.CLASS;
            if (classElement.getKind() == ElementKind.INTERFACE) {
                kind = Kind.INTERFACE;
            } else if (classElement.getKind() == ElementKind.CLASS) {
                kind = Kind.CLASS;
                extendsList.add(TypeDef.OBJECT_REF);
            }
            return ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withKind(kind)).withModifiers(TypeUtils.modifiersToInt(classElement.getModifiers()))).withPackageName(ModelUtils.getPackageName(classElement))).withName(ModelUtils.getClassName(classElement))).withExtendsList(extendsList)).build();
        }
    };
    public static final Function<TypeElement, TypeDef> TYPEDEF = FunctionFactory.cache(INTERNAL_TYPEDEF).withFallback(SHALLOW_TYPEDEF).withFallbackPredicate(IS_JAVA_ELEMENT).withMaximumRecursionLevel(10).withMaximumNestingDepth(10);
}

