/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen;

import io.sundr.builder.Builder;
import io.sundr.builder.Visitor;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.ClassRefBuilder;
import io.sundr.codegen.model.ClassRefFluent;
import io.sundr.codegen.model.MethodBuilder;
import io.sundr.codegen.model.PropertyBuilder;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeRef;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class ReplacePackage
implements Visitor<Builder> {
    private final String target;
    private final String replacement;

    public ReplacePackage(String target, String replacement) {
        this.target = target;
        this.replacement = replacement;
    }

    public void visit(Builder builder) {
        if (builder instanceof TypeDefBuilder) {
            this.visitTypeDefBuilder((TypeDefBuilder)builder);
        } else if (builder instanceof ClassRefBuilder) {
            this.visitClassRefBuilder((ClassRefBuilder)builder);
        } else if (builder instanceof PropertyBuilder) {
            this.visitPropertyBuilder((PropertyBuilder)builder);
        } else if (builder instanceof MethodBuilder) {
            this.visitMethodBuilder((MethodBuilder)builder);
        }
    }

    private void visitMethodBuilder(MethodBuilder builder) {
        if (builder.getReturnType() instanceof ClassRef) {
            ClassRefBuilder classRefBuilder = new ClassRefBuilder((ClassRef)builder.getReturnType());
            if (classRefBuilder.getDefinition().getPackageName().equals(this.target)) {
                ((ClassRefFluent.DefinitionNested)classRefBuilder.editDefinition().withPackageName(this.replacement)).endDefinition();
            }
            builder.withReturnType(((ClassRefBuilder)classRefBuilder.accept(this)).build());
        }
    }

    private void visitPropertyBuilder(PropertyBuilder builder) {
        if (builder.getTypeRef() instanceof ClassRef) {
            ClassRefBuilder classRefBuilder = new ClassRefBuilder((ClassRef)builder.getTypeRef());
            if (classRefBuilder.getDefinition().getPackageName().equals(this.target)) {
                ((ClassRefFluent.DefinitionNested)classRefBuilder.editDefinition().withPackageName(this.replacement)).endDefinition();
            }
            builder.withTypeRef(((ClassRefBuilder)classRefBuilder.accept(this)).build());
        }
    }

    private void visitClassRefBuilder(ClassRefBuilder builder) {
        if (builder.getDefinition().getPackageName().equals(this.target)) {
            ((ClassRefFluent.DefinitionNested)builder.editDefinition().withPackageName(this.replacement)).endDefinition();
        }
        ArrayList<TypeRef> updatedArguments = new ArrayList<TypeRef>();
        for (TypeRef arg : builder.getArguments()) {
            if (arg instanceof ClassRef && ((ClassRef)arg).getDefinition().getPackageName().equals(this.target)) {
                updatedArguments.add(((ClassRefBuilder)((ClassRefFluent.DefinitionNested)new ClassRefBuilder((ClassRef)arg).editDefinition().withPackageName(this.replacement)).endDefinition()).build());
            }
            updatedArguments.add(arg);
        }
        builder.withArguments(updatedArguments);
    }

    private void visitTypeDefBuilder(TypeDefBuilder builder) {
        if (this.target.equals(builder.getPackageName())) {
            builder.withPackageName(this.replacement);
        }
        if (builder.getAttributes().containsKey("ALSO_IMPORT")) {
            LinkedHashSet<ClassRef> updatedImports = new LinkedHashSet<ClassRef>();
            for (ClassRef classRef : (Set)builder.getAttributes().get("ALSO_IMPORT")) {
                if (this.target.equals(classRef.getDefinition().getPackageName())) {
                    updatedImports.add(((ClassRefBuilder)new ClassRefBuilder(classRef).accept(this)).build());
                    continue;
                }
                updatedImports.add(classRef);
            }
            builder.getAttributes().put("ALSO_IMPORT", updatedImports);
        }
    }
}

