/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen;

import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeRef;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DefinitionRepository {
    private static DefinitionRepository INSTANCE;
    private final Map<String, TypeDef> definitions = new HashMap<String, TypeDef>();

    private DefinitionRepository() {
    }

    public static final synchronized DefinitionRepository getRepository() {
        if (INSTANCE == null) {
            INSTANCE = new DefinitionRepository();
        }
        return INSTANCE;
    }

    public TypeDef register(TypeDef definition) {
        if (definition != null) {
            this.definitions.put(definition.getFullyQualifiedName(), definition);
        }
        return definition;
    }

    public TypeDef register(TypeDef definition, String ... flags) {
        TypeDefBuilder builder = new TypeDefBuilder(definition);
        for (String flag : flags) {
            builder.addToAttributes(flag, true);
        }
        return this.register(builder.build());
    }

    public Set<TypeDef> getDefinitions(String ... flags) {
        LinkedHashSet<TypeDef> result = new LinkedHashSet<TypeDef>();
        for (TypeDef candidate : this.definitions.values()) {
            boolean matches = true;
            for (String flag : flags) {
                if (candidate.getAttributes().containsKey(flag) && ((Boolean)candidate.getAttributes().get(flag)).booleanValue()) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            result.add(candidate);
        }
        return Collections.unmodifiableSet(result);
    }

    public TypeDef getDefinition(String fullyQualifiedName) {
        return this.definitions.get(fullyQualifiedName);
    }

    public TypeDef getDefinition(TypeRef type) {
        if (type instanceof ClassRef) {
            return this.definitions.get(((ClassRef)type).getDefinition().getFullyQualifiedName());
        }
        return null;
    }

    public void clear() {
        this.definitions.clear();
    }
}

