/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.spi.service.RequestHandlerCombiner;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.plugins.CombinedRequestHandler;
import springfox.documentation.spring.web.plugins.PathAndParametersEquivalence;

class DefaultRequestHandlerCombiner
implements RequestHandlerCombiner {
    private static final PathAndParametersEquivalence EQUIVALENCE = new PathAndParametersEquivalence();

    DefaultRequestHandlerCombiner() {
    }

    public List<RequestHandler> combine(List<RequestHandler> source) {
        ArrayList<? extends RequestHandler> combined = new ArrayList<RequestHandler>();
        LinkedListMultimap byPath = LinkedListMultimap.create();
        for (RequestHandler each : BuilderDefaults.nullToEmptyList(source)) {
            byPath.put((Object)Orderings.patternsCondition((RequestHandler)each).toString(), (Object)each);
        }
        for (String key : byPath.keySet()) {
            combined.addAll(this.combined(byPath.get((Object)key)));
        }
        return Orderings.byPatternsCondition().sortedCopy(combined);
    }

    private Collection<? extends RequestHandler> combined(Collection<RequestHandler> requestHandlers) {
        ArrayList source = Lists.newArrayList(requestHandlers);
        if (source.size() == 0 || source.size() == 1) {
            return requestHandlers;
        }
        ImmutableListMultimap groupByEquality = Multimaps.index((Iterable)source, this.equivalenceAsKey());
        ArrayList combined = Lists.newArrayList();
        for (Equivalence.Wrapper path : groupByEquality.keySet()) {
            List handlers = groupByEquality.get((Object)path);
            RequestHandler toCombine = (RequestHandler)path.get();
            if (handlers.size() > 1) {
                for (RequestHandler each : handlers) {
                    toCombine = this.combine(toCombine, each);
                }
            }
            combined.add(toCombine);
        }
        return combined;
    }

    private Function<RequestHandler, Equivalence.Wrapper<RequestHandler>> equivalenceAsKey() {
        return new Function<RequestHandler, Equivalence.Wrapper<RequestHandler>>(){

            public Equivalence.Wrapper<RequestHandler> apply(RequestHandler input) {
                return EQUIVALENCE.wrap(input);
            }
        };
    }

    private RequestHandler combine(RequestHandler first, RequestHandler second) {
        return new CombinedRequestHandler(first, second);
    }
}

