/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.histogram;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.histogram.NoopHistogram;
import io.micrometer.core.instrument.histogram.TimeWindowHistogramBase;
import io.micrometer.core.instrument.histogram.pause.ClockDriftPauseDetector;
import io.micrometer.core.instrument.histogram.pause.NoPauseDetector;
import io.micrometer.core.instrument.histogram.pause.PauseDetector;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.HdrHistogram.Histogram;
import org.LatencyUtils.LatencyStats;
import org.LatencyUtils.SimplePauseDetector;

@Incubating(since="1.0.0-rc.3")
public class TimeWindowLatencyHistogram
extends TimeWindowHistogramBase<LatencyStats, Histogram> {
    private static Map<PauseDetector, org.LatencyUtils.PauseDetector> pauseDetectorCache = new ConcurrentHashMap<PauseDetector, org.LatencyUtils.PauseDetector>();
    private final org.LatencyUtils.PauseDetector pauseDetector;

    public TimeWindowLatencyHistogram(Clock clock, HistogramConfig histogramConfig) {
        this(clock, histogramConfig, new ClockDriftPauseDetector(Duration.ofMillis(100L), Duration.ofMillis(100L)));
    }

    public TimeWindowLatencyHistogram(Clock clock, HistogramConfig histogramConfig, PauseDetector pauseDetector) {
        super(clock, histogramConfig, LatencyStats.class);
        this.pauseDetector = pauseDetectorCache.computeIfAbsent(pauseDetector, detector -> {
            if (detector instanceof ClockDriftPauseDetector) {
                ClockDriftPauseDetector clockDriftPauseDetector = (ClockDriftPauseDetector)detector;
                return new SimplePauseDetector(clockDriftPauseDetector.getSleepInterval().toNanos(), clockDriftPauseDetector.getPauseThreshold().toNanos(), 1, false);
            }
            if (detector instanceof NoPauseDetector) {
                return new NoopPauseDetector();
            }
            return new NoopPauseDetector();
        });
    }

    @Override
    LatencyStats newBucket(HistogramConfig histogramConfig) {
        return new LatencyStats.Builder().pauseDetector(this.pauseDetector).lowestTrackableLatency(histogramConfig.getMinimumExpectedValue().longValue()).highestTrackableLatency(histogramConfig.getMaximumExpectedValue().longValue()).numberOfSignificantValueDigits(2).build();
    }

    @Override
    void recordLong(LatencyStats bucket, long value) {
        bucket.recordLatency(value);
    }

    @Override
    void recordDouble(LatencyStats bucket, double value) {
        bucket.recordLatency((long)value);
    }

    @Override
    void resetBucket(LatencyStats bucket) {
        bucket.getIntervalHistogramInto((Histogram)NoopHistogram.INSTANCE);
    }

    Histogram newAccumulatedHistogram(LatencyStats[] ringBuffer) {
        return ringBuffer[0].getIntervalHistogram();
    }

    @Override
    void accumulate(LatencyStats sourceBucket, Histogram accumulatedHistogram) {
        sourceBucket.addIntervalHistogramTo(accumulatedHistogram);
    }

    @Override
    void resetAccumulatedHistogram(Histogram accumulatedHistogram) {
        accumulatedHistogram.reset();
    }

    @Override
    double valueAtPercentile(Histogram accumulatedHistogram, double percentile) {
        return accumulatedHistogram.getValueAtPercentile(percentile);
    }

    @Override
    double countAtValue(Histogram accumulatedHistogram, long value) {
        return accumulatedHistogram.getCountBetweenValues(0L, value);
    }

    private static class NoopPauseDetector
    extends org.LatencyUtils.PauseDetector {
        NoopPauseDetector() {
            this.shutdown();
        }
    }
}

