/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.histogram;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.CountAtValue;
import io.micrometer.core.instrument.HistogramSnapshot;
import io.micrometer.core.instrument.ValueAtPercentile;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.util.TimeUtils;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class TimeWindowHistogramBase<T, U> {
    static final int NUM_SIGNIFICANT_VALUE_DIGITS = 2;
    private static final AtomicIntegerFieldUpdater<TimeWindowHistogramBase> rotatingUpdater = AtomicIntegerFieldUpdater.newUpdater(TimeWindowHistogramBase.class, "rotating");
    private final Clock clock;
    private final HistogramConfig histogramConfig;
    private final T[] ringBuffer;
    private final U accumulatedHistogram;
    private volatile boolean accumulatedHistogramStale;
    private final long durationBetweenRotatesMillis;
    private int currentBucket;
    private volatile long lastRotateTimestampMillis;
    private volatile int rotating;

    TimeWindowHistogramBase(Clock clock, HistogramConfig histogramConfig, Class<T> bucketType) {
        this.clock = clock;
        this.histogramConfig = TimeWindowHistogramBase.validateHistogramConfig(histogramConfig);
        int ageBuckets = histogramConfig.getHistogramBufferLength();
        if (ageBuckets <= 0) {
            TimeWindowHistogramBase.rejectHistogramConfig("histogramBufferLength (" + ageBuckets + ") must be greater than 0.");
        }
        this.ringBuffer = this.newRingBuffer(bucketType, ageBuckets, histogramConfig);
        this.accumulatedHistogram = this.newAccumulatedHistogram(this.ringBuffer);
        this.durationBetweenRotatesMillis = histogramConfig.getHistogramExpiry().toMillis() / (long)ageBuckets;
        if (this.durationBetweenRotatesMillis <= 0L) {
            TimeWindowHistogramBase.rejectHistogramConfig("histogramExpiry (" + histogramConfig.getHistogramExpiry().toMillis() + "ms) / histogramBufferLength (" + ageBuckets + ") must be greater than 0.");
        }
        this.currentBucket = 0;
        this.lastRotateTimestampMillis = clock.wallTime();
    }

    private static HistogramConfig validateHistogramConfig(HistogramConfig histogramConfig) {
        for (double p : histogramConfig.getPercentiles()) {
            if (!(p < 0.0) && !(p > 1.0)) continue;
            TimeWindowHistogramBase.rejectHistogramConfig("percentiles must contain only the values between 0.0 and 1.0. Found " + p);
        }
        long minimumExpectedValue = histogramConfig.getMinimumExpectedValue();
        long maximumExpectedValue = histogramConfig.getMaximumExpectedValue();
        if (minimumExpectedValue <= 0L) {
            TimeWindowHistogramBase.rejectHistogramConfig("minimumExpectedValue (" + minimumExpectedValue + ") must be greater than 0.");
        }
        if (maximumExpectedValue < minimumExpectedValue) {
            TimeWindowHistogramBase.rejectHistogramConfig("maximumExpectedValue (" + maximumExpectedValue + ") must be equal to or greater than minimumExpectedValue (" + minimumExpectedValue + ").");
        }
        for (long sla : histogramConfig.getSlaBoundaries()) {
            if (sla > 0L) continue;
            TimeWindowHistogramBase.rejectHistogramConfig("slaBoundaries must contain only the values greater than 0. Found " + sla);
        }
        return histogramConfig;
    }

    private T[] newRingBuffer(Class<T> bucketType, int ageBuckets, HistogramConfig histogramConfig) {
        Object[] ringBuffer = (Object[])Array.newInstance(bucketType, ageBuckets);
        for (int i = 0; i < ageBuckets; ++i) {
            ringBuffer[i] = this.newBucket(histogramConfig);
        }
        return ringBuffer;
    }

    private static void rejectHistogramConfig(String msg) {
        throw new IllegalStateException("Invalid HistogramConfig: " + msg);
    }

    abstract T newBucket(HistogramConfig var1);

    abstract void recordLong(T var1, long var2);

    abstract void recordDouble(T var1, double var2);

    abstract void resetBucket(T var1);

    abstract U newAccumulatedHistogram(T[] var1);

    abstract void accumulate(T var1, U var2);

    abstract void resetAccumulatedHistogram(U var1);

    abstract double valueAtPercentile(U var1, double var2);

    abstract double countAtValue(U var1, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double percentile(double percentile) {
        this.rotate();
        TimeWindowHistogramBase timeWindowHistogramBase = this;
        synchronized (timeWindowHistogramBase) {
            this.accumulateIfStale();
            return this.valueAtPercentile(this.accumulatedHistogram, percentile * 100.0);
        }
    }

    public final double percentile(double percentile, TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.percentile(percentile), unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double histogramCountAtValue(long value) {
        this.rotate();
        TimeWindowHistogramBase timeWindowHistogramBase = this;
        synchronized (timeWindowHistogramBase) {
            this.accumulateIfStale();
            return this.countAtValue(this.accumulatedHistogram, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HistogramSnapshot takeSnapshot(long count, double total, double max, boolean supportsAggregablePercentiles) {
        CountAtValue[] counts;
        ValueAtPercentile[] values;
        this.rotate();
        TimeWindowHistogramBase timeWindowHistogramBase = this;
        synchronized (timeWindowHistogramBase) {
            this.accumulateIfStale();
            values = this.takeValueSnapshot();
            counts = this.takeCountSnapshot(supportsAggregablePercentiles);
        }
        return HistogramSnapshot.of(count, total, max, values, counts);
    }

    private void accumulateIfStale() {
        if (this.accumulatedHistogramStale) {
            this.accumulate(this.ringBuffer[this.currentBucket], this.accumulatedHistogram);
            this.accumulatedHistogramStale = false;
        }
    }

    private ValueAtPercentile[] takeValueSnapshot() {
        double[] monitoredPercentiles = this.histogramConfig.getPercentiles();
        if (monitoredPercentiles.length == 0) {
            return null;
        }
        ValueAtPercentile[] values = new ValueAtPercentile[monitoredPercentiles.length];
        for (int i = 0; i < monitoredPercentiles.length; ++i) {
            double p = monitoredPercentiles[i];
            values[i] = ValueAtPercentile.of(p, this.valueAtPercentile(this.accumulatedHistogram, p * 100.0));
        }
        return values;
    }

    private CountAtValue[] takeCountSnapshot(boolean supportsAggregablePercentiles) {
        if (!this.histogramConfig.isPublishingHistogram()) {
            return null;
        }
        NavigableSet<Long> monitoredValues = this.histogramConfig.getHistogramBuckets(supportsAggregablePercentiles);
        if (monitoredValues.isEmpty()) {
            return null;
        }
        CountAtValue[] counts = new CountAtValue[monitoredValues.size()];
        Iterator iterator = monitoredValues.iterator();
        for (int i = 0; i < counts.length; ++i) {
            long v = (Long)iterator.next();
            counts[i] = CountAtValue.of(v, this.countAtValue(this.accumulatedHistogram, v));
        }
        return counts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recordLong(long value) {
        this.rotate();
        try {
            for (T bucket : this.ringBuffer) {
                this.recordLong(bucket, value);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            this.accumulatedHistogramStale = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recordDouble(double value) {
        this.rotate();
        try {
            for (T bucket : this.ringBuffer) {
                this.recordDouble(bucket, value);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            this.accumulatedHistogramStale = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotate() {
        long timeSinceLastRotateMillis = this.clock.wallTime() - this.lastRotateTimestampMillis;
        if (timeSinceLastRotateMillis < this.durationBetweenRotatesMillis) {
            return;
        }
        if (!rotatingUpdater.compareAndSet(this, 0, 1)) {
            return;
        }
        try {
            TimeWindowHistogramBase timeWindowHistogramBase = this;
            synchronized (timeWindowHistogramBase) {
                do {
                    this.resetBucket(this.ringBuffer[this.currentBucket]);
                    if (++this.currentBucket >= this.ringBuffer.length) {
                        this.currentBucket = 0;
                    }
                    this.lastRotateTimestampMillis += this.durationBetweenRotatesMillis;
                } while ((timeSinceLastRotateMillis -= this.durationBetweenRotatesMillis) >= this.durationBetweenRotatesMillis);
                this.resetAccumulatedHistogram(this.accumulatedHistogram);
                this.accumulatedHistogramStale = true;
            }
        }
        finally {
            this.rotating = 0;
        }
    }
}

