/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.cumulative;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.util.TimeDecayingMax;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;

public class CumulativeDistributionSummary
extends AbstractDistributionSummary {
    private final AtomicLong count = new AtomicLong();
    private final DoubleAdder total = new DoubleAdder();
    private final TimeDecayingMax max;

    public CumulativeDistributionSummary(Meter.Id id, Clock clock, HistogramConfig histogramConfig) {
        super(id, clock, histogramConfig);
        this.max = new TimeDecayingMax(clock, histogramConfig);
    }

    @Override
    protected void recordNonNegative(double amount) {
        this.count.incrementAndGet();
        this.total.add(amount);
        this.max.record(amount);
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public double totalAmount() {
        return this.total.sum();
    }

    @Override
    public double max() {
        return this.max.poll();
    }

    @Override
    public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.Count), new Measurement(this::totalAmount, Statistic.Total), new Measurement(this::max, Statistic.Max));
    }
}

