/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.system;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Objects;

public class FileDescriptorMetrics
implements MeterBinder {
    private final OperatingSystemMXBean osBean;
    private final Iterable<Tag> tags;
    private Method openFdsMethod;
    private Method maxFdsMethod;

    public FileDescriptorMetrics() {
        this(Collections.emptyList());
    }

    public FileDescriptorMetrics(Iterable<Tag> tags) {
        this(ManagementFactory.getOperatingSystemMXBean(), tags);
    }

    FileDescriptorMetrics(OperatingSystemMXBean osBean, Iterable<Tag> tags) {
        this.osBean = Objects.requireNonNull(osBean);
        this.tags = tags;
        this.openFdsMethod = this.detectMethod("getOpenFileDescriptorCount");
        this.maxFdsMethod = this.detectMethod("getMaxFileDescriptorCount");
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Gauge.builder("process.open.fds", this.osBean, x -> this.invoke(this.openFdsMethod)).tags(this.tags).description("The open file descriptor count").register(registry);
        Gauge.builder("process.max.fds", this.osBean, x -> this.invoke(this.maxFdsMethod)).tags(this.tags).description("The maximum file descriptor count").register(registry);
    }

    private double invoke(Method method) {
        try {
            return method != null ? (double)((Long)method.invoke((Object)this.osBean, new Object[0])).longValue() : Double.NaN;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return Double.NaN;
        }
    }

    private Method detectMethod(String name) {
        Objects.requireNonNull(name);
        try {
            Method method = this.osBean.getClass().getDeclaredMethod(name, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }
}

