/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jetty;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import org.eclipse.jetty.server.handler.StatisticsHandler;

public class JettyStatisticsMetrics
implements MeterBinder {
    private final StatisticsHandler statisticsHandler;
    private Iterable<Tag> tags;

    public static void monitor(MeterRegistry meterRegistry, StatisticsHandler statisticsHandler, String ... tags) {
        JettyStatisticsMetrics.monitor(meterRegistry, statisticsHandler, Tags.zip(tags));
    }

    public static void monitor(MeterRegistry meterRegistry, StatisticsHandler statisticsHandler, Iterable<Tag> tags) {
        new JettyStatisticsMetrics(statisticsHandler, tags).bindTo(meterRegistry);
    }

    public JettyStatisticsMetrics(StatisticsHandler statisticsHandler, Iterable<Tag> tags) {
        this.tags = tags;
        this.statisticsHandler = statisticsHandler;
    }

    @Override
    public void bindTo(MeterRegistry reg) {
        this.bindTimer(reg, "jetty.requests", "Request duration", StatisticsHandler::getRequests, StatisticsHandler::getRequestTimeTotal);
        this.bindTimer(reg, "jetty.dispatched", "Dispatch duration", StatisticsHandler::getDispatched, StatisticsHandler::getDispatchedTimeTotal);
        this.bindCounter(reg, "jetty.async.requests", "Total number of async requests", StatisticsHandler::getAsyncRequests);
        this.bindCounter(reg, "jetty.async.dispatches", "Total number of requests that have been asynchronously dispatched", StatisticsHandler::getAsyncDispatches);
        this.bindCounter(reg, "jetty.async.expires", "Total number of async requests that have expired", StatisticsHandler::getExpires);
        FunctionCounter.builder("jetty.responses.size", this.statisticsHandler, StatisticsHandler::getResponsesBytesTotal).description("Total number of bytes across all responses").baseUnit("bytes").register(reg);
        this.bindGauge(reg, "jetty.requests.active", "Number of requests currently active", StatisticsHandler::getRequestsActive);
        this.bindGauge(reg, "jetty.dispatched.active", "Number of dispatches currently active", StatisticsHandler::getDispatchedActive);
        this.bindGauge(reg, "jetty.dispatched.active.max", "Maximum number of active dispatches being handled", StatisticsHandler::getDispatchedActiveMax);
        this.bindTimeGauge(reg, "jetty.dispatched.time.max", "Maximum time spent in dispatch handling", StatisticsHandler::getDispatchedTimeMax);
        this.bindGauge(reg, "jetty.async.requests.waiting", "Currently waiting async requests", StatisticsHandler::getAsyncRequestsWaiting);
        this.bindGauge(reg, "jetty.async.requests.waiting.max", "Maximum number of waiting async requests", StatisticsHandler::getAsyncRequestsWaitingMax);
        this.bindTimeGauge(reg, "jetty.request.time.max", "Maximum time spent handling requests", StatisticsHandler::getRequestTimeMax);
        this.bindTimeGauge(reg, "jetty.stats", "Time stats have been collected for", StatisticsHandler::getStatsOnMs);
        this.bindStatusCounters(reg);
    }

    private void bindStatusCounters(MeterRegistry reg) {
        this.buildStatusCounter(reg, "1xx", StatisticsHandler::getResponses1xx);
        this.buildStatusCounter(reg, "2xx", StatisticsHandler::getResponses2xx);
        this.buildStatusCounter(reg, "3xx", StatisticsHandler::getResponses3xx);
        this.buildStatusCounter(reg, "4xx", StatisticsHandler::getResponses4xx);
        this.buildStatusCounter(reg, "5xx", StatisticsHandler::getResponses5xx);
    }

    private void bindGauge(MeterRegistry reg, String name, String desc, ToDoubleFunction<StatisticsHandler> func) {
        Gauge.builder(name, this.statisticsHandler, func).tags(this.tags).description(desc).register(reg);
    }

    private void bindTimer(MeterRegistry reg, String name, String desc, ToLongFunction<StatisticsHandler> countFunc, ToDoubleFunction<StatisticsHandler> consumer) {
        FunctionTimer.builder(name, this.statisticsHandler, countFunc, consumer, TimeUnit.MILLISECONDS).tags(this.tags).description(desc).register(reg);
    }

    private void bindTimeGauge(MeterRegistry reg, String name, String desc, ToDoubleFunction<StatisticsHandler> consumer) {
        TimeGauge.builder(name, this.statisticsHandler, TimeUnit.MILLISECONDS, consumer).tags(this.tags).description(desc).register(reg);
    }

    private void bindCounter(MeterRegistry reg, String name, String desc, ToDoubleFunction<StatisticsHandler> consumer) {
        FunctionCounter.builder(name, this.statisticsHandler, consumer).tags(this.tags).description(desc).register(reg);
    }

    private void buildStatusCounter(MeterRegistry reg, String status, ToDoubleFunction<StatisticsHandler> consumer) {
        FunctionCounter.builder("jetty.responses", this.statisticsHandler, consumer).tags(this.tags).description("Number of requests with response status").tags("status", status).register(reg);
    }
}

