/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Tags {
    private Tags() {
    }

    public static List<Tag> zip(String ... keyValues) {
        if (keyValues.length % 2 == 1) {
            throw new IllegalArgumentException("size must be even, it is a set of key=value pairs");
        }
        ArrayList<Tag> ts = new ArrayList<Tag>(keyValues.length / 2);
        for (int i = 0; i < keyValues.length; i += 2) {
            ts.add(Tag.of(keyValues[i], keyValues[i + 1]));
        }
        return ts;
    }

    public static Iterable<Tag> concat(Iterable<Tag> tags, Iterable<Tag> otherTags) {
        if (!otherTags.iterator().hasNext()) {
            return tags;
        }
        return Stream.concat(StreamSupport.stream(tags.spliterator(), false), StreamSupport.stream(otherTags.spliterator(), false)).collect(Collectors.toList());
    }

    public static Iterable<Tag> concat(Iterable<Tag> tags, String ... keyValues) {
        return Tags.concat(tags, Tags.zip(keyValues));
    }

    public static Iterable<Tag> of(String tagKey, String tagValue) {
        return Collections.singletonList(Tag.of(tagKey, tagValue));
    }
}

