/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;

public class Bucket<T> {
    private final T tag;
    private final Integer index;
    private String tagStr;
    LongAdder value = new LongAdder();

    public Bucket(T tag, int index) {
        this.tag = tag;
        this.index = index;
    }

    public T getTag() {
        return this.tag;
    }

    public String getTagString() {
        return this.getTagString(Object::toString);
    }

    public String getTagString(Function<T, String> tagSerializer) {
        if (this.tagStr != null) {
            return this.tagStr;
        }
        this.tagStr = tagSerializer == null ? this.tag.toString() : tagSerializer.apply(this.tag);
        return this.tagStr;
    }

    public Bucket<T> increment() {
        this.value.increment();
        return this;
    }

    public long getValue() {
        return this.value.longValue();
    }

    public String toString() {
        return "Bucket{tag=" + this.tag + ", value=" + this.value + '}';
    }

    public Integer getIndex() {
        return this.index;
    }
}

