/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator.step;

import com.netflix.spectator.api.AbstractRegistry;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.RegistryConfig;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.impl.Scheduler;
import io.micrometer.core.instrument.spectator.step.StepClock;
import io.micrometer.core.instrument.spectator.step.StepCounter;
import io.micrometer.core.instrument.spectator.step.StepDistributionSummary;
import io.micrometer.core.instrument.spectator.step.StepGauge;
import io.micrometer.core.instrument.spectator.step.StepRegistryConfig;
import io.micrometer.core.instrument.spectator.step.StepTimer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class AbstractStepRegistry
extends AbstractRegistry {
    private final Clock clock;
    private final boolean enabled;
    private final Duration step;
    private final long stepMillis;
    protected final int connectTimeout;
    protected final int readTimeout;
    private final int batchSize;
    private final int numThreads;
    private Scheduler scheduler;

    public AbstractStepRegistry(StepRegistryConfig config, Clock clock) {
        super((Clock)new StepClock(clock, config.step().toMillis()), (RegistryConfig)config);
        this.clock = clock;
        this.enabled = config.enabled();
        this.step = config.step();
        this.stepMillis = this.step.toMillis();
        this.connectTimeout = (int)config.connectTimeout().toMillis();
        this.readTimeout = (int)config.readTimeout().toMillis();
        this.batchSize = config.batchSize();
        this.numThreads = config.numThreads();
    }

    public void start() {
        if (this.scheduler == null) {
            if (this.enabled) {
                Scheduler.Options options = new Scheduler.Options().withFrequency(Scheduler.Policy.FIXED_RATE_SKIP_IF_LONG, this.step).withInitialDelay(Duration.ofMillis(this.getInitialDelay(this.stepMillis))).withStopOnFailure(false);
                this.scheduler = new Scheduler((Registry)this, "micrometer-publisher", this.numThreads);
                this.scheduler.schedule(options, this::pushMetrics);
                this.logger.info("started collecting metrics every {}", (Object)this.step);
            } else {
                this.logger.info("publishing is not enabled");
            }
        } else {
            this.logger.warn("registry already started, ignoring duplicate request");
        }
    }

    private long getInitialDelay(long stepSize) {
        long offset;
        long stepBoundary;
        long now = this.clock.wallTime();
        long delay = now - (stepBoundary = now / stepSize * stepSize);
        if (delay < (offset = stepSize / 10L)) {
            return delay + offset;
        }
        if (delay > stepSize - offset) {
            return stepSize - offset;
        }
        return delay;
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
            this.logger.info("stopped collecting metrics every {}ms", (Object)this.step);
        } else {
            this.logger.warn("registry stopped, but was never started");
        }
    }

    protected abstract void pushMetrics();

    List<Measurement> getMeasurements() {
        return this.stream().flatMap(m -> StreamSupport.stream(m.measure().spliterator(), false)).collect(Collectors.toList());
    }

    protected List<List<Measurement>> getBatches() {
        ArrayList<List<Measurement>> batches = new ArrayList<List<Measurement>>();
        List<Measurement> ms = this.getMeasurements();
        for (int i = 0; i < ms.size(); i += this.batchSize) {
            List<Measurement> batch = ms.subList(i, Math.min(ms.size(), i + this.batchSize));
            batches.add(batch);
        }
        return batches;
    }

    protected Counter newCounter(Id id) {
        return new StepCounter(id, this.clock, this.stepMillis);
    }

    protected DistributionSummary newDistributionSummary(Id id) {
        return new StepDistributionSummary(id, this.clock, this.stepMillis);
    }

    protected Timer newTimer(Id id) {
        return new StepTimer(id, this.clock, this.stepMillis);
    }

    protected Gauge newGauge(Id id) {
        return new StepGauge(id, this.clock());
    }
}

