/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator;

import com.netflix.spectator.api.AbstractMeter;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import io.micrometer.core.instrument.AbstractMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.spectator.CustomSpectatorToDoubleGauge;
import io.micrometer.core.instrument.spectator.SpectatorConf;
import io.micrometer.core.instrument.spectator.SpectatorCounter;
import io.micrometer.core.instrument.spectator.SpectatorDistributionSummary;
import io.micrometer.core.instrument.spectator.SpectatorGauge;
import io.micrometer.core.instrument.spectator.SpectatorLongTaskTimer;
import io.micrometer.core.instrument.spectator.SpectatorTimer;
import io.micrometer.core.instrument.stats.hist.Bucket;
import io.micrometer.core.instrument.stats.hist.BucketFilter;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.hist.PercentileTimeHistogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class SpectatorMeterRegistry
extends AbstractMeterRegistry {
    private final Registry registry;
    private final SpectatorConf spectatorConf;

    public SpectatorMeterRegistry(SpectatorConf config, Registry registry, Clock clock) {
        super(clock);
        this.registry = registry;
        this.spectatorConf = config;
    }

    protected Collection<com.netflix.spectator.api.Tag> toSpectatorTags(Iterable<Tag> tags) {
        return StreamSupport.stream(tags.spliterator(), false).map(t -> new BasicTag(t.getKey(), t.getValue())).collect(Collectors.toList());
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        com.netflix.spectator.api.Counter counter = this.registry.counter(this.getConventionName(id), this.toSpectatorTags(this.getConventionTags(id)));
        return new SpectatorCounter(id, counter);
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        this.registerQuantilesGaugeIfNecessary(id, quantiles, UnaryOperator.identity());
        com.netflix.spectator.api.DistributionSummary ds = this.registry.distributionSummary(this.getConventionName(id), this.toSpectatorTags(this.getConventionTags(id)));
        return new SpectatorDistributionSummary(id, ds, quantiles, this.registerHistogramCounterIfNecessary(id, histogram));
    }

    @Override
    protected Timer newTimer(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        this.registerQuantilesGaugeIfNecessary(id, quantiles, t -> t / 1000000.0);
        com.netflix.spectator.api.Timer timer = this.registry.timer(this.getConventionName(id), this.toSpectatorTags(this.getConventionTags(id)));
        return new SpectatorTimer(id, timer, this.clock, quantiles, this.registerHistogramCounterIfNecessary(id, histogram));
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        Id gaugeId = this.registry.createId(this.getConventionName(id), this.toSpectatorTags(this.getConventionTags(id)));
        CustomSpectatorToDoubleGauge<T> gauge = new CustomSpectatorToDoubleGauge<T>(this.registry.clock(), gaugeId, obj, f);
        this.registry.register(gauge);
        return new SpectatorGauge(id, gauge);
    }

    protected Histogram<?> registerHistogramCounterIfNecessary(Meter.Id id, Histogram.Builder<?> builder) {
        if (builder != null) {
            if (builder instanceof PercentileTimeHistogram.Builder) {
                PercentileTimeHistogram.Builder percentileHistBuilder = (PercentileTimeHistogram.Builder)builder;
                if (this.spectatorConf.timerPercentilesMax() != null) {
                    double max = this.spectatorConf.timerPercentilesMax().toNanos();
                    percentileHistBuilder.filterBuckets((BucketFilter)BucketFilter.clampMax(max));
                }
                if (this.spectatorConf.timerPercentilesMin() != null) {
                    double min = this.spectatorConf.timerPercentilesMin().toNanos();
                    percentileHistBuilder.filterBuckets((BucketFilter)BucketFilter.clampMin(min));
                }
            }
            Histogram<?> hist = builder.create(Histogram.Summation.Normal);
            for (Bucket<?> bucket : hist.getBuckets()) {
                this.more().counter(this.createId(id.getName(), Tags.concat(id.getTags(), "bucket", bucket.getTagString()), null), bucket, Bucket::getValue);
            }
            return hist;
        }
        return null;
    }

    protected void registerQuantilesGaugeIfNecessary(Meter.Id id, Quantiles quantiles, UnaryOperator<Double> scaling) {
        if (quantiles != null) {
            for (Double q : quantiles.monitored()) {
                if (Double.isNaN(q)) continue;
                this.gauge(id.getName(), Tags.concat(id.getTags(), "quantile", Double.toString(q)), q, q2 -> (Double)scaling.apply(quantiles.get((double)q2)));
            }
        }
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        com.netflix.spectator.api.LongTaskTimer timer = this.registry.longTaskTimer(id.getName(), this.toSpectatorTags(id.getTags()));
        return new SpectatorLongTaskTimer(id, timer);
    }

    @Override
    protected void newMeter(Meter.Id id, Meter.Type type, final Iterable<Measurement> measurements) {
        Id spectatorId = SpectatorMeterRegistry.spectatorId(this.registry, this.getConventionName(id), this.getConventionTags(id));
        AbstractMeter<Id> spectatorMeter = new AbstractMeter<Id>(this.registry.clock(), spectatorId, spectatorId){

            public Iterable<com.netflix.spectator.api.Measurement> measure() {
                return StreamSupport.stream(measurements.spliterator(), false).map(m -> new com.netflix.spectator.api.Measurement(this.id, this.clock.wallTime(), m.getValue())).collect(Collectors.toList());
            }
        };
        this.registry.register((Meter)spectatorMeter);
    }

    public Registry getSpectatorRegistry() {
        return this.registry;
    }

    private static Id spectatorId(Registry registry, String name, Iterable<Tag> tags) {
        String[] flattenedTags = (String[])StreamSupport.stream(tags.spliterator(), false).flatMap(t -> Stream.of(t.getKey(), t.getValue())).toArray(String[]::new);
        return registry.createId(name, flattenedTags);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.NANOSECONDS;
    }
}

