/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class SimpleTimer
extends AbstractTimer {
    private LongAdder count = new LongAdder();
    private LongAdder totalTime = new LongAdder();
    private final Quantiles quantiles;
    private final Histogram<?> histogram;

    public SimpleTimer(Meter.Id id, Clock clock, Quantiles quantiles, Histogram<?> histogram) {
        super(id, clock);
        this.quantiles = quantiles;
        this.histogram = histogram;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            this.count.increment();
            long nanoAmount = TimeUnit.NANOSECONDS.convert(amount, unit);
            this.totalTime.add(nanoAmount);
            if (this.quantiles != null) {
                this.quantiles.observe(nanoAmount);
            }
            if (this.histogram != null) {
                this.histogram.observe(nanoAmount);
            }
        }
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.totalTime.doubleValue(), unit);
    }
}

