/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeCounter;
import io.micrometer.core.instrument.composite.CompositeCustomMeter;
import io.micrometer.core.instrument.composite.CompositeDistributionSummary;
import io.micrometer.core.instrument.composite.CompositeFunctionTimer;
import io.micrometer.core.instrument.composite.CompositeGauge;
import io.micrometer.core.instrument.composite.CompositeLongTaskTimer;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.composite.CompositeTimeGauge;
import io.micrometer.core.instrument.composite.CompositeTimer;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class CompositeMeterRegistry
extends AbstractMeterRegistry {
    private final Set<MeterRegistry> registries = ConcurrentHashMap.newKeySet();
    private Collection<CompositeMeter> compositeMeters = new CopyOnWriteArrayList<CompositeMeter>();

    public CompositeMeterRegistry() {
        this(Clock.SYSTEM);
    }

    public CompositeMeterRegistry(Clock clock) {
        super(clock);
        this.config().namingConvention(NamingConvention.identity);
    }

    @Override
    protected Timer newTimer(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        CompositeTimer timer = new CompositeTimer(id, quantiles, histogram, this.clock);
        this.compositeMeters.add(timer);
        this.registries.forEach(timer::add);
        return timer;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        CompositeDistributionSummary ds = new CompositeDistributionSummary(id, quantiles, histogram);
        this.compositeMeters.add(ds);
        this.registries.forEach(ds::add);
        return ds;
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        CompositeCounter counter = new CompositeCounter(id);
        this.compositeMeters.add(counter);
        this.registries.forEach(counter::add);
        return counter;
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        CompositeLongTaskTimer longTaskTimer = new CompositeLongTaskTimer(id);
        this.compositeMeters.add(longTaskTimer);
        this.registries.forEach(longTaskTimer::add);
        return longTaskTimer;
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        CompositeGauge<T> gauge = new CompositeGauge<T>(id, obj, f);
        this.compositeMeters.add(gauge);
        this.registries.forEach(gauge::add);
        return gauge;
    }

    @Override
    protected <T> Gauge newTimeGauge(Meter.Id id, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
        CompositeTimeGauge<T> gauge = new CompositeTimeGauge<T>(id, obj, fUnit, f);
        this.compositeMeters.add(gauge);
        this.registries.forEach(gauge::add);
        return gauge;
    }

    @Override
    protected <T> Meter newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        CompositeFunctionTimer<T> ft = new CompositeFunctionTimer<T>(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits);
        this.compositeMeters.add(ft);
        this.registries.forEach(ft::add);
        return ft;
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return null;
    }

    @Override
    protected void newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        CompositeCustomMeter meter = new CompositeCustomMeter(id, type, measurements);
        this.compositeMeters.add(meter);
        this.registries.forEach(meter::add);
    }

    public CompositeMeterRegistry add(MeterRegistry registry) {
        if (this.registries.add(registry)) {
            this.compositeMeters.forEach(m -> m.add(registry));
        }
        return this;
    }

    public CompositeMeterRegistry remove(MeterRegistry registry) {
        if (this.registries.remove(registry)) {
            this.compositeMeters.forEach(m -> m.remove(registry));
        }
        return this;
    }

    public Set<MeterRegistry> getRegistries() {
        return this.registries;
    }
}

