/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.noop.NoopGauge;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.ToDoubleFunction;

public class CompositeGauge<T>
extends AbstractMeter
implements Gauge,
CompositeMeter {
    protected final WeakReference<T> ref;
    protected final ToDoubleFunction<T> f;
    protected final Map<MeterRegistry, Gauge> gauges = Collections.synchronizedMap(new LinkedHashMap());

    CompositeGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        super(id);
        this.ref = new WeakReference<T>(obj);
        this.f = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double value() {
        Map<MeterRegistry, Gauge> map = this.gauges;
        synchronized (map) {
            return this.gauges.values().stream().findFirst().orElse(NoopGauge.INSTANCE).value();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MeterRegistry registry) {
        Object obj = this.ref.get();
        if (obj != null) {
            Map<MeterRegistry, Gauge> map = this.gauges;
            synchronized (map) {
                this.gauges.put(registry, registry.gauge(this.getId(), obj, this.f));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(MeterRegistry registry) {
        Map<MeterRegistry, Gauge> map = this.gauges;
        synchronized (map) {
            this.gauges.remove(registry);
        }
    }
}

