/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.policy.internal;

import io.gravitee.plugin.policy.PolicyPlugin;
import io.gravitee.plugin.policy.PolicyPluginManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PolicyPluginManagerImpl
implements PolicyPluginManager {
    private static final String SCHEMAS_DIRECTORY = "schemas";
    private final Map<String, PolicyPlugin> definitions = new HashMap<String, PolicyPlugin>();

    @Override
    public void register(PolicyPlugin policyPlugin) {
        this.definitions.putIfAbsent(policyPlugin.id(), policyPlugin);
    }

    @Override
    public Collection<PolicyPlugin> findAll() {
        return this.definitions.values();
    }

    @Override
    public PolicyPlugin get(String policy) {
        return this.definitions.get(policy);
    }

    @Override
    public String getPolicyConfiguration(String policy) throws IOException {
        File schemaDir;
        Path policyWorkspace = this.get(policy).path();
        File[] schemas = policyWorkspace.toFile().listFiles(pathname -> pathname.isDirectory() && pathname.getName().equals(SCHEMAS_DIRECTORY));
        if (schemas.length == 1 && (schemaDir = schemas[0]).listFiles().length > 0) {
            return new String(Files.readAllBytes(schemaDir.listFiles()[0].toPath()));
        }
        return null;
    }
}

