/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.policy.internal;

import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginHandler;
import io.gravitee.plugin.core.api.PluginType;
import io.gravitee.plugin.policy.PolicyPluginManager;
import io.gravitee.plugin.policy.internal.PolicyConfigurationClassFinder;
import io.gravitee.plugin.policy.internal.PolicyContextClassFinder;
import io.gravitee.plugin.policy.internal.PolicyPluginImpl;
import java.io.IOException;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ClassUtils;

public class PolicyPluginHandler
implements PluginHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyPluginHandler.class);
    @Autowired
    private PolicyPluginManager policyPluginManager;

    public boolean canHandle(Plugin plugin) {
        return plugin.type() == PluginType.POLICY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Plugin plugin) {
        URLClassLoader policyClassLoader = null;
        try {
            policyClassLoader = new URLClassLoader(plugin.dependencies(), this.getClass().getClassLoader());
            Class pluginClass = ClassUtils.forName((String)plugin.clazz(), (ClassLoader)policyClassLoader);
            LOGGER.info("Register a new policy: {} [{}]", (Object)plugin.id(), (Object)pluginClass.getName());
            PolicyPluginImpl policy = new PolicyPluginImpl(plugin, pluginClass);
            policy.setConfiguration(new PolicyConfigurationClassFinder().lookupFirst(pluginClass, policyClassLoader));
            policy.setContext(new PolicyContextClassFinder().lookupFirst(pluginClass, policyClassLoader));
            this.policyPluginManager.register(policy);
        }
        catch (Exception iae) {
            LOGGER.error("Unexpected error while creating policy instance", (Throwable)iae);
        }
        finally {
            if (policyClassLoader != null) {
                try {
                    policyClassLoader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

