/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePathToElementMap;
import io.github.lukehutch.fastclasspathscanner.scanner.FailureHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResultProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.FastPathResolver;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import io.github.lukehutch.fastclasspathscanner.utils.Recycler;
import io.github.lukehutch.fastclasspathscanner.utils.WorkQueue;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class Scanner
implements Callable<ScanResult> {
    private final boolean removeTemporaryFilesAfterScan;
    private final ScanSpec scanSpec;
    private final ExecutorService executorService;
    private final int numParallelTasks;
    private final boolean enableRecursiveScanning;
    private final InterruptionChecker interruptionChecker = new InterruptionChecker();
    private final ScanResultProcessor scanResultProcessor;
    private final FailureHandler failureHandler;
    private final LogNode log;
    private static final int NUM_FILES_PER_CHUNK = 200;

    public Scanner(ScanSpec scanSpec, ExecutorService executorService, int numParallelTasks, boolean enableRecursiveScanning, boolean removeTemporaryFilesAfterScan, ScanResultProcessor scannResultProcessor, FailureHandler failureHandler, LogNode log) {
        this.removeTemporaryFilesAfterScan = removeTemporaryFilesAfterScan;
        this.scanSpec = scanSpec;
        this.executorService = executorService;
        this.numParallelTasks = numParallelTasks;
        this.enableRecursiveScanning = enableRecursiveScanning;
        this.scanResultProcessor = scannResultProcessor;
        this.failureHandler = failureHandler;
        this.log = log;
    }

    private static void findClasspathOrder(ClasspathElement currSingleton, ClasspathRelativePathToElementMap classpathElementMap, HashSet<ClasspathElement> visitedClasspathElts, ArrayList<ClasspathElement> order) throws InterruptedException {
        if (visitedClasspathElts.add(currSingleton)) {
            order.add(currSingleton);
            if (currSingleton.childClasspathElts != null) {
                for (ClasspathRelativePath childClasspathElt : currSingleton.childClasspathElts) {
                    ClasspathElement childSingleton = (ClasspathElement)classpathElementMap.get(childClasspathElt);
                    if (childSingleton == null || childSingleton.ioExceptionOnOpen) continue;
                    Scanner.findClasspathOrder(childSingleton, classpathElementMap, visitedClasspathElts, order);
                }
            }
        }
    }

    private static List<ClasspathElement> findClasspathOrder(List<ClasspathRelativePath> rawClasspathElements, ClasspathRelativePathToElementMap classpathElementMap) throws InterruptedException {
        HashSet<ClasspathElement> visitedClasspathElts = new HashSet<ClasspathElement>();
        ArrayList<ClasspathElement> order = new ArrayList<ClasspathElement>();
        for (ClasspathRelativePath toplevelClasspathElt : rawClasspathElements) {
            ClasspathElement toplevelSingleton = (ClasspathElement)classpathElementMap.get(toplevelClasspathElt);
            if (toplevelSingleton == null || toplevelSingleton.ioExceptionOnOpen) continue;
            Scanner.findClasspathOrder(toplevelSingleton, classpathElementMap, visitedClasspathElts, order);
        }
        return order;
    }

    private static List<ClassfileParserChunk> getClassfileParserChunks(List<ClasspathElement> classpathOrder) {
        LinkedList chunks = new LinkedList();
        for (ClasspathElement classpathElement : classpathOrder) {
            LinkedList<ClassfileParserChunk> chunksForClasspathElt = new LinkedList<ClassfileParserChunk>();
            int n = classpathElement.getNumClassfileMatches();
            if (n > 0) {
                int numChunks = (int)Math.ceil((float)n / 200.0f);
                float filesPerChunk = (float)n / (float)numChunks;
                for (int i = 0; i < numChunks; ++i) {
                    int classfileEndIdx;
                    int classfileStartIdx = (int)((float)i * filesPerChunk);
                    int n2 = classfileEndIdx = i < numChunks - 1 ? (int)((float)(i + 1) * filesPerChunk) : n;
                    if (classfileEndIdx <= classfileStartIdx) continue;
                    chunksForClasspathElt.add(new ClassfileParserChunk(classpathElement, classfileStartIdx, classfileEndIdx));
                }
            }
            chunks.add(chunksForClasspathElt);
        }
        ArrayList<ClassfileParserChunk> interleavedChunks = new ArrayList<ClassfileParserChunk>();
        while (!chunks.isEmpty()) {
            LinkedList<LinkedList> nextChunks = new LinkedList<LinkedList>();
            for (LinkedList linkedList : chunks) {
                if (linkedList.isEmpty()) continue;
                ClassfileParserChunk head = (ClassfileParserChunk)linkedList.remove();
                interleavedChunks.add(head);
                if (linkedList.isEmpty()) continue;
                nextChunks.add(linkedList);
            }
            chunks = nextChunks;
        }
        return interleavedChunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ScanResult call() throws InterruptedException, ExecutionException {
        final LogNode classpathFinderLog = this.log == null ? null : this.log.log("Finding classpath entries");
        try {
            ScanResult scanResult;
            Throwable throwable;
            NestedJarHandler nestedJarHandler;
            block76: {
                block77: {
                    ScanResult scanResult2;
                    String rtJarPath;
                    Object classpathElt;
                    String currentDirPath;
                    nestedJarHandler = new NestedJarHandler(this.removeTemporaryFilesAfterScan, this.interruptionChecker, classpathFinderLog);
                    throwable = null;
                    long scanStart = System.nanoTime();
                    try {
                        currentDirPath = FastPathResolver.resolve(Paths.get("", new String[0]).toAbsolutePath().normalize().toRealPath(LinkOption.NOFOLLOW_LINKS).toString());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    List<String> rawClasspathElementPathStrs = new ClasspathFinder(this.scanSpec, classpathFinderLog).getRawClasspathElements();
                    ArrayList<ClasspathRelativePath> rawClasspathElements = new ArrayList<ClasspathRelativePath>();
                    for (String rawClasspathElementPathStr : rawClasspathElementPathStrs) {
                        classpathElt = new ClasspathRelativePath(currentDirPath, rawClasspathElementPathStr, nestedJarHandler);
                        rawClasspathElements.add((ClasspathRelativePath)classpathElt);
                    }
                    final ClasspathRelativePathToElementMap classpathElementMap = new ClasspathRelativePathToElementMap(this.enableRecursiveScanning, this.scanSpec, nestedJarHandler, this.interruptionChecker, classpathFinderLog);
                    WorkQueue<ClasspathRelativePath> workQueue = new WorkQueue<ClasspathRelativePath>(rawClasspathElements, new WorkQueue.WorkUnitProcessor<ClasspathRelativePath>(){

                        @Override
                        public void processWorkUnit(ClasspathRelativePath rawClasspathElt) throws Exception {
                            if (classpathElementMap.get(rawClasspathElt) != null) {
                                if (classpathFinderLog != null) {
                                    classpathFinderLog.log("Ignoring duplicate classpath element: " + rawClasspathElt.getResolvedPath());
                                }
                            } else if (rawClasspathElt.isValidClasspathElement(Scanner.this.scanSpec, classpathFinderLog)) {
                                try {
                                    classpathElementMap.createSingleton(rawClasspathElt);
                                }
                                catch (Exception e) {
                                    classpathFinderLog.log("Classpath element " + rawClasspathElt + " is not valid (" + e + ") -- skipping");
                                }
                            }
                        }
                    }, this.interruptionChecker, classpathFinderLog);
                    classpathElt = null;
                    try {
                        classpathElementMap.setWorkQueue(workQueue);
                        workQueue.startWorkers(this.executorService, this.numParallelTasks - 1, classpathFinderLog);
                        workQueue.runWorkLoop();
                    }
                    catch (Throwable throwable2) {
                        classpathElt = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (workQueue != null) {
                            if (classpathElt != null) {
                                try {
                                    workQueue.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)classpathElt).addSuppressed(throwable3);
                                }
                            } else {
                                workQueue.close();
                            }
                        }
                    }
                    List<ClasspathElement> classpathOrder = Scanner.findClasspathOrder(rawClasspathElements, classpathElementMap);
                    if (!this.scanSpec.blacklistSystemJars() && (rtJarPath = JarUtils.getRtJarPath()) != null) {
                        classpathOrder.add(0, ClasspathElement.newInstance(new ClasspathRelativePath(currentDirPath, rtJarPath, nestedJarHandler), this.enableRecursiveScanning, this.scanSpec, nestedJarHandler, null, this.interruptionChecker, classpathFinderLog));
                    }
                    if (this.enableRecursiveScanning) {
                        HashSet<String> classpathRelativePathsFound = new HashSet<String>();
                        ArrayList<ClasspathElement> classpathOrderFiltered = new ArrayList<ClasspathElement>();
                        ArrayList<URL> classpathOrderURLsFiltered = new ArrayList<URL>();
                        for (int classpathIdx = 0; classpathIdx < classpathOrder.size(); ++classpathIdx) {
                            ClasspathElement classpathElement = classpathOrder.get(classpathIdx);
                            classpathElement.maskFiles(classpathIdx, classpathRelativePathsFound, this.log);
                            if (classpathElement.classpathElementFile.isFile() && !this.scanSpec.scanJars) {
                                if (this.log == null) continue;
                                this.log.log(String.format("%06d-2", classpathIdx), "Ignoring jarfile, because jar scanning has been disabled: " + classpathElement.classpathElementFile);
                                continue;
                            }
                            if (classpathElement.classpathElementFile.isFile() && !this.scanSpec.jarIsWhitelisted(classpathElement.classpathElementFile.getName())) {
                                if (this.log == null) continue;
                                this.log.log(String.format("%06d-2", classpathIdx), "Ignoring jarfile, because it is not whitelisted: " + classpathElement.classpathElementFile);
                                continue;
                            }
                            if (classpathElement.classpathElementFile.isDirectory() && !this.scanSpec.scanDirs) {
                                if (this.log == null) continue;
                                this.log.log(String.format("%06d-2", classpathIdx), "Ignoring directory, because directory scanning has been disabled: " + classpathElement.classpathElementFile);
                                continue;
                            }
                            classpathOrderFiltered.add(classpathElement);
                            classpathOrderURLsFiltered.add(classpathElement.classpathElementURL);
                        }
                        classpathOrder = classpathOrderFiltered;
                        this.scanSpec.orderedClassLoader = new URLClassLoader(classpathOrderURLsFiltered.toArray(new URL[classpathOrderFiltered.size()]));
                    }
                    if (this.log != null) {
                        LogNode logNode = this.log.log("Classpath element order:");
                        for (int i = 0; i < classpathOrder.size(); ++i) {
                            ClasspathElement classpathElt2 = classpathOrder.get(i);
                            logNode.log(i + ": " + classpathElt2);
                        }
                    }
                    if (this.enableRecursiveScanning) {
                        HashMap<File, Long> fileToLastModified = new HashMap<File, Long>();
                        for (ClasspathElement classpathElement : classpathOrder) {
                            fileToLastModified.putAll(classpathElement.fileToLastModified);
                        }
                        final ConcurrentLinkedQueue classInfoUnlinked = new ConcurrentLinkedQueue();
                        final ConcurrentHashMap stringInternMap = new ConcurrentHashMap();
                        try (final Recycler<ClassfileBinaryParser, RuntimeException> classfileBinaryParserRecycler = new Recycler<ClassfileBinaryParser, RuntimeException>(){

                            @Override
                            public ClassfileBinaryParser newInstance() {
                                return new ClassfileBinaryParser();
                            }
                        };
                             WorkQueue<ClassfileParserChunk> workQueue2 = new WorkQueue<ClassfileParserChunk>(Scanner.getClassfileParserChunks(classpathOrder), new WorkQueue.WorkUnitProcessor<ClassfileParserChunk>(){

                            @Override
                            public void processWorkUnit(ClassfileParserChunk chunk) throws InterruptedException, ExecutionException {
                                ClassfileBinaryParser classfileBinaryParser = null;
                                try {
                                    classfileBinaryParser = (ClassfileBinaryParser)classfileBinaryParserRecycler.acquire();
                                    chunk.classpathElement.parseClassfiles(classfileBinaryParser, chunk.classfileStartIdx, chunk.classfileEndIdx, stringInternMap, classInfoUnlinked, Scanner.this.log);
                                }
                                finally {
                                    classfileBinaryParserRecycler.release(classfileBinaryParser);
                                    classfileBinaryParser = null;
                                }
                            }
                        }, this.interruptionChecker, this.log);){
                            workQueue2.startWorkers(this.executorService, this.numParallelTasks - 1, this.log);
                            workQueue2.runWorkLoop();
                        }
                        LogNode classGraphLog = this.log == null ? null : this.log.log("Building class graph");
                        HashMap<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
                        for (ClassInfoUnlinked c : classInfoUnlinked) {
                            c.link(this.scanSpec, classNameToClassInfo, classGraphLog);
                        }
                        ClassGraphBuilder classGraphBuilder = new ClassGraphBuilder(this.scanSpec, classNameToClassInfo);
                        if (classGraphLog != null) {
                            classGraphLog.addElapsedTime();
                        }
                        scanResult2 = new ScanResult(this.scanSpec, classpathOrder, classGraphBuilder, fileToLastModified, this.interruptionChecker, this.log);
                        if (this.scanResultProcessor != null) {
                            this.scanResultProcessor.processScanResult(scanResult2);
                        }
                    } else {
                        scanResult2 = new ScanResult(this.scanSpec, classpathOrder, null, null, this.interruptionChecker, this.log);
                    }
                    if (this.log != null) {
                        this.log.log("Completed scan", System.nanoTime() - scanStart);
                    }
                    scanResult = scanResult2;
                    if (nestedJarHandler == null) break block76;
                    if (throwable == null) break block77;
                    try {
                        nestedJarHandler.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    break block76;
                }
                nestedJarHandler.close();
            }
            return scanResult;
            catch (Throwable throwable5) {
                try {
                    try {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        if (nestedJarHandler != null) {
                            if (throwable != null) {
                                try {
                                    nestedJarHandler.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                nestedJarHandler.close();
                            }
                        }
                        throw throwable6;
                    }
                }
                catch (Throwable e) {
                    if (this.log != null) {
                        this.log.log(e);
                    }
                    if (this.failureHandler == null) {
                        throw e;
                    }
                    this.failureHandler.onFailure(e);
                    throwable = null;
                    return throwable;
                }
            }
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    private static class ClassfileParserChunk {
        private final ClasspathElement classpathElement;
        private final int classfileStartIdx;
        private final int classfileEndIdx;

        public ClassfileParserChunk(ClasspathElement classpathElementSingleton, int classfileStartIdx, int classfileEndIdx) {
            this.classpathElement = classpathElementSingleton;
            this.classfileStartIdx = classfileStartIdx;
            this.classfileEndIdx = classfileEndIdx;
        }
    }
}

