/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.filter.commit.CommitDiffFilter;
import org.gitective.core.filter.commit.CommitFilter;
import org.gitective.core.filter.commit.CommitImpact;

public class CommitFileImpactFilter
extends CommitDiffFilter
implements Iterable<CommitImpact> {
    private final int limit;
    private final SortedSet<CommitImpact> commits = new TreeSet<CommitImpact>(new CommitImpact.DescendingImpactComparator());

    public CommitFileImpactFilter(boolean detectRenames, int limit) {
        super(detectRenames);
        this.limit = limit;
    }

    public CommitFileImpactFilter(boolean detectRenames) {
        this(detectRenames, 10);
    }

    public CommitFileImpactFilter() {
        this(false);
    }

    public CommitFileImpactFilter(int limit) {
        this(false, limit);
    }

    public int getLimit() {
        return this.limit;
    }

    public SortedSet<CommitImpact> getCommits() {
        return this.commits;
    }

    @Override
    public boolean include(RevCommit commit, Collection<DiffEntry> diffs) {
        int add = 0;
        int edit = 0;
        int delete = 0;
        for (DiffEntry diff : diffs) {
            switch (diff.getChangeType()) {
                case ADD: {
                    ++add;
                    break;
                }
                case MODIFY: {
                    ++edit;
                    break;
                }
                case DELETE: {
                    ++delete;
                }
            }
        }
        CommitImpact impact = new CommitImpact((AnyObjectId)commit, add, edit, delete);
        this.commits.add(impact);
        if (this.commits.size() > this.limit) {
            this.commits.remove(this.commits.last());
        }
        return true;
    }

    @Override
    public RevFilter clone() {
        return new CommitFileImpactFilter(this.detectRenames, this.limit);
    }

    @Override
    public CommitFilter reset() {
        this.commits.clear();
        return super.reset();
    }

    @Override
    public Iterator<CommitImpact> iterator() {
        return this.commits.iterator();
    }
}

