/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.gitective.core.Assert;
import org.gitective.core.CommitUtils;
import org.gitective.core.RepositoryService;
import org.gitective.core.filter.commit.CommitFilter;
import org.gitective.core.filter.tree.BaseTreeFilter;

public class CommitFinder
extends RepositoryService {
    protected RevFilter commitFilter;
    protected TreeFilter treeFilter;
    protected RevSort sort;

    public CommitFinder(File ... gitDirs) {
        super(gitDirs);
    }

    public CommitFinder(Repository ... repositories) {
        super(repositories);
    }

    public CommitFinder(String ... gitDirs) {
        super(gitDirs);
    }

    public CommitFinder(Collection<?> repositories) {
        super(repositories);
    }

    public CommitFinder setFilter(RevFilter filter) {
        this.commitFilter = filter;
        return this;
    }

    public CommitFinder setFilter(TreeFilter filter) {
        this.treeFilter = filter;
        return this;
    }

    protected RevWalk createWalk(Repository repository) {
        RevWalk walk = new RevWalk(repository);
        walk.setRetainBody(true);
        walk.setRevFilter(this.commitFilter);
        walk.setTreeFilter(this.treeFilter);
        if (this.commitFilter instanceof CommitFilter) {
            ((CommitFilter)this.commitFilter).setRepository(repository);
        }
        if (this.treeFilter instanceof BaseTreeFilter) {
            ((BaseTreeFilter)this.treeFilter).setRepository(repository);
        }
        if (this.sort != null) {
            walk.sort(this.sort);
        }
        return walk;
    }

    protected CommitFinder walk(RevWalk walk) throws IOException {
        try {
            while (walk.next() != null) {
            }
        }
        catch (StopWalkException stopWalkException) {
            // empty catch block
        }
        return this;
    }

    protected CommitFinder walk(Repository repository, ObjectId start, ObjectId end) {
        if (start == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Starting commit id"));
        }
        try (RevWalk walk = this.createWalk(repository);){
            walk.markStart(walk.parseCommit((AnyObjectId)start));
            if (end != null) {
                walk.markUninteresting(walk.parseCommit((AnyObjectId)end));
            }
            this.walk(walk);
        }
        return this;
    }

    public CommitFinder findFrom(ObjectId start) {
        return this.findBetween(start, (ObjectId)null);
    }

    public CommitFinder findFrom(String start) {
        return this.findBetween(start, (ObjectId)null);
    }

    public CommitFinder find() {
        return this.findFrom("HEAD");
    }

    public CommitFinder findInTags() {
        Repository[] repos = this.repositories;
        int repoCount = this.repositories.length;
        for (int i = 0; i < repoCount; ++i) {
            Repository repo = repos[i];
            Collection<RevCommit> commits = CommitUtils.getTags(repo);
            if (commits.isEmpty()) continue;
            try (RevWalk walk = this.createWalk(repo);){
                walk.markStart(commits);
                this.walk(walk);
                continue;
            }
        }
        return this;
    }

    public CommitFinder findInBranches() {
        Repository[] repos = this.repositories;
        int repoCount = this.repositories.length;
        for (int i = 0; i < repoCount; ++i) {
            Repository repo = repos[i];
            Collection<RevCommit> commits = CommitUtils.getBranches(repo);
            if (commits.isEmpty()) continue;
            try (RevWalk walk = this.createWalk(repo);){
                walk.markStart(commits);
                this.walk(walk);
                continue;
            }
        }
        return this;
    }

    public CommitFinder findBetween(ObjectId start, ObjectId end) {
        Repository[] repos = this.repositories;
        int repoCount = this.repositories.length;
        for (int i = 0; i < repoCount; ++i) {
            this.walk(repos[i], start, end);
        }
        return this;
    }

    public CommitFinder findBetween(String start, ObjectId end) {
        Repository[] repos = this.repositories;
        int repoCount = this.repositories.length;
        for (int i = 0; i < repoCount; ++i) {
            Repository repo = repos[i];
            this.walk(repo, (ObjectId)CommitUtils.getCommit(repo, start), end);
        }
        return this;
    }

    public CommitFinder findBetween(ObjectId start, String end) {
        Repository[] repos = this.repositories;
        int repoCount = this.repositories.length;
        for (int i = 0; i < repoCount; ++i) {
            Repository repo = repos[i];
            this.walk(repo, start, (ObjectId)CommitUtils.getCommit(repo, end));
        }
        return this;
    }

    public CommitFinder findBetween(String start, String end) {
        Repository[] repos = this.repositories;
        int repoCount = this.repositories.length;
        for (int i = 0; i < repoCount; ++i) {
            Repository repo = repos[i];
            this.walk(repo, (ObjectId)CommitUtils.getCommit(repo, start), (ObjectId)CommitUtils.getCommit(repo, end));
        }
        return this;
    }

    public CommitFinder findUntil(String end) {
        return this.findBetween("HEAD", end);
    }

    public CommitFinder findUntil(ObjectId end) {
        return this.findBetween("HEAD", end);
    }
}

