/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.converter;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.plugin.converter.KubernetesToOpenShiftConverter;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentStrategyFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeploymentOpenShiftConverter
implements KubernetesToOpenShiftConverter {
    private final PlatformMode mode;
    private final Long openshiftDeployTimeoutSeconds;

    public DeploymentOpenShiftConverter(PlatformMode mode, Long openshiftDeployTimeoutSeconds) {
        this.mode = mode;
        this.openshiftDeployTimeoutSeconds = openshiftDeployTimeoutSeconds;
    }

    @Override
    public HasMetadata convert(HasMetadata item) {
        Deployment resource = (Deployment)item;
        DeploymentConfigBuilder builder = new DeploymentConfigBuilder();
        builder.withMetadata(resource.getMetadata());
        DeploymentSpec spec = resource.getSpec();
        if (spec != null) {
            Map matchLabels;
            LabelSelector selector;
            Integer revisionHistoryLimit;
            DeploymentConfigFluent.SpecNested specBuilder = builder.withNewSpec();
            Integer replicas = spec.getReplicas();
            if (replicas != null) {
                specBuilder.withReplicas(replicas);
            }
            if ((revisionHistoryLimit = spec.getRevisionHistoryLimit()) != null) {
                specBuilder.withRevisionHistoryLimit(revisionHistoryLimit);
            }
            if ((selector = spec.getSelector()) != null && (matchLabels = selector.getMatchLabels()) != null && !matchLabels.isEmpty()) {
                specBuilder.withSelector(matchLabels);
            }
            HashMap<String, String> containerToImageMap = new HashMap<String, String>();
            PodTemplateSpec template = spec.getTemplate();
            if (template != null) {
                specBuilder.withTemplate(template);
                PodSpec podSpec = template.getSpec();
                Objects.notNull((Object)podSpec, (String)("No PodSpec for PodTemplate:" + template));
                List containers = podSpec.getContainers();
                Objects.notNull((Object)podSpec, (String)("No containers for PodTemplate.spec: " + template));
                for (Container container : containers) {
                    this.validateContainer(container);
                    containerToImageMap.put(container.getName(), container.getImage());
                }
            }
            DeploymentStrategy strategy = spec.getStrategy();
            String strategyType = null;
            if (strategy != null) {
                strategyType = strategy.getType();
            }
            if (this.openshiftDeployTimeoutSeconds != null && this.openshiftDeployTimeoutSeconds > 0L) {
                if (Strings.isNullOrBlank((String)strategyType) || "Rolling".equals(strategyType)) {
                    ((DeploymentConfigSpecFluent.StrategyNested)((DeploymentStrategyFluent.RollingParamsNested)((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType("Rolling")).withNewRollingParams().withTimeoutSeconds(this.openshiftDeployTimeoutSeconds)).endRollingParams()).endStrategy();
                } else if ("Recreate".equals(strategyType)) {
                    ((DeploymentConfigSpecFluent.StrategyNested)((DeploymentStrategyFluent.RecreateParamsNested)((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType("Recreate")).withNewRecreateParams().withTimeoutSeconds(this.openshiftDeployTimeoutSeconds)).endRecreateParams()).endStrategy();
                } else {
                    ((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType(strategyType)).endStrategy();
                }
            } else if (Strings.isNotBlank((String)strategyType)) {
                ((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType(strategyType)).endStrategy();
            }
            ((DeploymentConfigSpecFluent.TriggersNested)specBuilder.addNewTrigger().withType("ConfigChange")).endTrigger();
            if (containerToImageMap.size() != 0 && this.mode.equals((Object)PlatformMode.openshift)) {
                for (Map.Entry entry : containerToImageMap.entrySet()) {
                    String containerName = (String)entry.getKey();
                    ImageName image = new ImageName((String)entry.getValue());
                    String tag = image.getTag() != null ? image.getTag() : "latest";
                    ((DeploymentConfigSpecFluent.TriggersNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentConfigSpecFluent.TriggersNested)specBuilder.addNewTrigger().withType("ImageChange")).withNewImageChangeParams().withAutomatic(Boolean.valueOf(true))).withNewFrom().withKind("ImageStreamTag")).withName(image.getSimpleName() + ":" + tag)).endFrom()).withContainerNames(new String[]{containerName})).endImageChangeParams()).endTrigger();
                }
            }
            specBuilder.endSpec();
        }
        return builder.build();
    }

    private void validateContainer(Container container) {
        if (container.getImage() == null) {
            throw new IllegalArgumentException("Container " + container.getName() + " has no Docker image configured. " + "Please check your Docker image configuration (including the generators which are supposed to run)");
        }
    }
}

