/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import com.google.common.base.Strings;
import io.fabric8.maven.docker.config.ConfigHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.project.MavenProject;

public class ImageNameFormatter
implements ConfigHelper.NameFormatter {
    private final Map<String, Lookup> lookups;
    private final Date now;
    private Pattern FORMAT_IDENTIFIER_PATTERN = Pattern.compile("^(.*?)%([^a-zA-Z]*)([a-zA-Z])(.*)$");

    public ImageNameFormatter(MavenProject project, Date now) {
        this.lookups = new HashMap<String, Lookup>();
        this.now = now;
        this.initLookups(project);
    }

    @Override
    public String format(String name) {
        if (name == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        String rest = name;
        while (true) {
            Matcher matcher;
            if (!(matcher = this.FORMAT_IDENTIFIER_PATTERN.matcher(rest)).matches()) {
                ret.append(rest);
                return ret.toString();
            }
            ret.append(matcher.group(1));
            ret.append(this.formatElement(matcher.group(2), matcher.group(3)));
            rest = matcher.group(4);
        }
    }

    private String formatElement(String options, String what) {
        Lookup lookup = this.lookups.get(what);
        if (lookup == null) {
            throw new IllegalArgumentException(String.format("No image name format element '%%%s' known", what));
        }
        String val = lookup.lookup();
        return String.format("%" + (options != null ? options : "") + "s", val);
    }

    private void initLookups(MavenProject project) {
        this.lookups.put("g", new DefaultUserLookup(project));
        this.lookups.put("a", new DefaultNameLookup(project));
        this.lookups.put("v", new DefaultTagLookup(project, DefaultTagLookup.Mode.PLAIN, this.now));
        this.lookups.put("t", new DefaultTagLookup(project, DefaultTagLookup.Mode.SNAPSHOT_WITH_TIMESTAMP, this.now));
        this.lookups.put("l", new DefaultTagLookup(project, DefaultTagLookup.Mode.SNAPSHOT_LATEST, this.now));
    }

    private static String sanitizeName(String name) {
        StringBuilder ret = new StringBuilder();
        int underscores = 0;
        boolean lastWasADot = false;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                if (++underscores > 2) continue;
                ret.append(c);
                continue;
            }
            if (c == '.') {
                if (!lastWasADot) {
                    ret.append(c);
                }
                lastWasADot = true;
                continue;
            }
            underscores = 0;
            lastWasADot = false;
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '-') continue;
            ret.append(c);
        }
        return ret.toString().toLowerCase();
    }

    private static class DefaultTagLookup
    extends AbstractLookup {
        private static final String DOCKER_IMAGE_TAG = "docker.image.tag";
        private final Mode mode;
        private final Date now;

        private DefaultTagLookup(MavenProject project, Mode mode, Date now) {
            super(project);
            this.mode = mode;
            this.now = now;
        }

        @Override
        public String lookup() {
            String tag = this.getProperty(DOCKER_IMAGE_TAG);
            if (!Strings.isNullOrEmpty((String)tag)) {
                return tag;
            }
            tag = this.project.getVersion();
            if (this.mode != Mode.PLAIN && tag.endsWith("-SNAPSHOT")) {
                if (this.mode == Mode.SNAPSHOT_WITH_TIMESTAMP) {
                    tag = "snapshot-" + new SimpleDateFormat("yyMMdd-HHmmss-SSSS").format(this.now);
                } else if (this.mode == Mode.SNAPSHOT_LATEST) {
                    tag = "latest";
                }
            }
            return tag;
        }

        private static enum Mode {
            PLAIN,
            SNAPSHOT_WITH_TIMESTAMP,
            SNAPSHOT_LATEST;

        }
    }

    private static class DefaultNameLookup
    extends AbstractLookup {
        private DefaultNameLookup(MavenProject project) {
            super(project);
        }

        @Override
        public String lookup() {
            return ImageNameFormatter.sanitizeName(this.project.getArtifactId());
        }
    }

    private static class DefaultUserLookup
    extends AbstractLookup {
        private static final String DOCKER_IMAGE_USER = "docker.image.user";

        private DefaultUserLookup(MavenProject project) {
            super(project);
        }

        @Override
        public String lookup() {
            String user = this.getProperty(DOCKER_IMAGE_USER);
            if (user != null) {
                return user;
            }
            String groupId = this.project.getGroupId();
            while (groupId.endsWith(".")) {
                groupId = groupId.substring(0, groupId.length() - 1);
            }
            int idx = groupId.lastIndexOf(".");
            return ImageNameFormatter.sanitizeName(groupId.substring(idx != -1 ? idx + 1 : 0));
        }
    }

    private static abstract class AbstractLookup
    implements Lookup {
        protected final MavenProject project;

        private AbstractLookup(MavenProject project) {
            this.project = project;
        }

        protected String getProperty(String key) {
            return this.project.getProperties().getProperty(key);
        }
    }

    private static interface Lookup {
        public String lookup();
    }
}

