/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.model;

import io.fabric8.maven.docker.model.Container;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class ContainersListElement
implements Container {
    static final String CREATED = "Created";
    static final String ID = "Id";
    static final String IMAGE = "Image";
    static final String IP = "IP";
    static final String LABELS = "Labels";
    static final String PORTS = "Ports";
    static final String PUBLIC_PORT = "PublicPort";
    static final String STATUS = "Status";
    static final String TYPE = "Type";
    private static final String NAMES = "Names";
    private static final String PRIVATE_PORT = "PrivatePort";
    private static final String SLASH = "/";
    private static final String UP = "up";
    private final JSONObject json;

    public ContainersListElement(JSONObject json) {
        this.json = json;
    }

    @Override
    public long getCreated() {
        return this.json.getLong(CREATED);
    }

    @Override
    public String getId() {
        return this.json.getString(ID).substring(0, 12);
    }

    @Override
    public String getImage() {
        return this.json.getString(IMAGE);
    }

    @Override
    public Map<String, String> getLabels() {
        if (this.json.isNull(LABELS)) {
            return Collections.emptyMap();
        }
        return this.mapLabels(this.json.getJSONObject(LABELS));
    }

    @Override
    public String getName() {
        if (this.json.has(NAMES)) {
            JSONArray names = this.json.getJSONArray(NAMES);
            for (int i = 0; i < names.length(); ++i) {
                String name = names.getString(i);
                if (name.startsWith(SLASH)) {
                    name = name.substring(1);
                }
                if (name.contains(SLASH)) continue;
                return name;
            }
            throw new IllegalStateException("Unable to determine container name from 'Names' " + names);
        }
        throw new UnsupportedOperationException("Missing 'Names' attribute from a container list element " + this.json);
    }

    @Override
    public Map<String, Container.PortBinding> getPortBindings() {
        if (this.json.isNull(PORTS)) {
            return Collections.emptyMap();
        }
        return this.mapPortBindings(this.json.getJSONArray(PORTS));
    }

    @Override
    public String getIPAddress() {
        return null;
    }

    @Override
    public Map<String, String> getCustomNetworkIpAddresses() {
        return null;
    }

    @Override
    public boolean isRunning() {
        String status = this.json.getString(STATUS);
        return status.toLowerCase().contains(UP);
    }

    private Container.PortBinding createPortBinding(JSONObject object) {
        Container.PortBinding binding = null;
        if (object.has(PUBLIC_PORT) && object.has(IP)) {
            binding = new Container.PortBinding(object.getInt(PUBLIC_PORT), object.getString(IP));
        }
        return binding;
    }

    private String createPortKey(JSONObject object) {
        return String.format("%s/%s", object.getInt(PRIVATE_PORT), object.getString(TYPE));
    }

    private Map<String, String> mapLabels(JSONObject labels) {
        int length = labels.length();
        HashMap<String, String> mapped = new HashMap<String, String>(length);
        Iterator iterator = labels.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            mapped.put(key, labels.get(key).toString());
        }
        return mapped;
    }

    private Map<String, Container.PortBinding> mapPortBindings(JSONArray ports) {
        int length = ports.length();
        HashMap<String, Container.PortBinding> portBindings = new HashMap<String, Container.PortBinding>(length);
        for (int i = 0; i < length; ++i) {
            JSONObject object = ports.getJSONObject(i);
            portBindings.put(this.createPortKey(object), this.createPortBinding(object));
        }
        return portBindings;
    }
}

