/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import io.druid.java.util.common.Pair;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.parsers.FlattenExpr;
import io.druid.java.util.common.parsers.ParseException;
import io.druid.java.util.common.parsers.Parser;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.exception.JsonQueryException;

public class JSONPathParser
implements Parser<String, Object> {
    private final Map<String, Pair<FieldType, FlattenExpr>> fieldPathMap;
    private final boolean useFieldDiscovery;
    private final ObjectMapper mapper;
    private final CharsetEncoder enc = Charsets.UTF_8.newEncoder();
    private final Configuration jsonPathConfig;

    public JSONPathParser(List<FieldSpec> fieldSpecs, boolean useFieldDiscovery, ObjectMapper mapper) {
        this.fieldPathMap = this.generateFieldPaths(fieldSpecs);
        this.useFieldDiscovery = useFieldDiscovery;
        this.mapper = mapper == null ? new ObjectMapper() : mapper;
        this.jsonPathConfig = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(EnumSet.of(Option.SUPPRESS_EXCEPTIONS)).build();
    }

    @Override
    public List<String> getFieldNames() {
        return null;
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
    }

    @Override
    public Map<String, Object> parse(String input) {
        try {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            JsonNode document = (JsonNode)this.mapper.readValue(input, JsonNode.class);
            for (Map.Entry<String, Pair<FieldType, FlattenExpr>> entry : this.fieldPathMap.entrySet()) {
                JsonNode parsedVal;
                String fieldName = entry.getKey();
                Pair<FieldType, FlattenExpr> pair = entry.getValue();
                FlattenExpr path = (FlattenExpr)pair.rhs;
                if (pair.lhs == FieldType.ROOT) {
                    parsedVal = document.get(fieldName);
                } else if (pair.lhs == FieldType.PATH) {
                    parsedVal = path.readPath(document, this.jsonPathConfig);
                } else if (pair.lhs == FieldType.JQ) {
                    parsedVal = path.readJq(document);
                } else {
                    throw new ParseException("Unknown FieldType", pair.lhs);
                }
                if (parsedVal == null) continue;
                map.put(fieldName, this.valueConversionFunction(parsedVal));
            }
            if (this.useFieldDiscovery) {
                this.discoverFields(map, document);
            }
            return map;
        }
        catch (Exception e) {
            throw new ParseException(e, "Unable to parse row [%s]", input);
        }
    }

    private Map<String, Pair<FieldType, FlattenExpr>> generateFieldPaths(List<FieldSpec> fieldSpecs) {
        LinkedHashMap<String, Pair<FieldType, FlattenExpr>> map = new LinkedHashMap<String, Pair<FieldType, FlattenExpr>>();
        for (FieldSpec fieldSpec : fieldSpecs) {
            String fieldName = fieldSpec.getName();
            if (map.get(fieldName) != null) {
                throw new IllegalArgumentException("Cannot have duplicate field definition: " + fieldName);
            }
            FlattenExpr path = null;
            if (fieldSpec.getType() == FieldType.PATH) {
                path = new FlattenExpr(JsonPath.compile((String)fieldSpec.getExpr(), (Predicate[])new Predicate[0]));
            } else if (fieldSpec.getType() == FieldType.JQ) {
                try {
                    path = new FlattenExpr(JsonQuery.compile((String)fieldSpec.getExpr()));
                }
                catch (JsonQueryException e) {
                    throw new IllegalArgumentException("Unable to compile JQ expression: " + fieldSpec.getExpr());
                }
            }
            Pair<FieldType, FlattenExpr> pair = new Pair<FieldType, FlattenExpr>(fieldSpec.getType(), path);
            map.put(fieldName, pair);
        }
        return map;
    }

    private void discoverFields(Map<String, Object> map, JsonNode document) {
        Iterator it = document.fields();
        while (it.hasNext()) {
            JsonNode val;
            Map.Entry e = (Map.Entry)it.next();
            String field = (String)e.getKey();
            if (map.containsKey(field) || (val = (JsonNode)e.getValue()).isNull() || val.isObject() || val.isArray() && !this.isFlatList(val)) continue;
            map.put(field, this.valueConversionFunction(val));
        }
    }

    private Object valueConversionFunction(JsonNode val) {
        if (val == null) {
            return null;
        }
        if (val.isInt() || val.isLong()) {
            return val.asLong();
        }
        if (val.isNumber()) {
            return val.asDouble();
        }
        if (val.isTextual()) {
            return this.charsetFix(val.asText());
        }
        if (val.isArray()) {
            ArrayList<Object> newList = new ArrayList<Object>();
            for (JsonNode entry : val) {
                newList.add(this.valueConversionFunction(entry));
            }
            return newList;
        }
        if (val.isObject()) {
            LinkedHashMap newMap = new LinkedHashMap();
            Iterator it = val.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                newMap.put(entry.getKey(), this.valueConversionFunction((JsonNode)entry.getValue()));
            }
            return newMap;
        }
        return val;
    }

    private String charsetFix(String s) {
        if (s != null && !this.enc.canEncode(s)) {
            return StringUtils.fromUtf8(StringUtils.toUtf8(s));
        }
        return s;
    }

    private boolean isFlatList(JsonNode list) {
        for (JsonNode obj : list) {
            if (!obj.isObject() && !obj.isArray()) continue;
            return false;
        }
        return true;
    }

    public static class FieldSpec {
        private final FieldType type;
        private final String name;
        private final String expr;

        public FieldSpec(FieldType type, String name, String expr) {
            this.type = type;
            this.name = name;
            this.expr = expr;
        }

        public FieldType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getExpr() {
            return this.expr;
        }
    }

    public static enum FieldType {
        ROOT,
        PATH,
        JQ;

    }
}

