/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.hdfs;

import com.google.inject.Inject;
import com.metamx.emitter.EmittingLogger;
import io.druid.segment.loading.DataSegmentKiller;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsDataSegmentKiller
implements DataSegmentKiller {
    private static final EmittingLogger log = new EmittingLogger(HdfsDataSegmentKiller.class);
    private static final String PATH_KEY = "path";
    private final Configuration config;
    private final Path storageDirectory;

    @Inject
    public HdfsDataSegmentKiller(Configuration config, HdfsDataSegmentPusherConfig pusherConfig) {
        this.config = config;
        this.storageDirectory = new Path(pusherConfig.getStorageDirectory());
    }

    private static Path getPath(DataSegment segment) {
        return new Path(String.valueOf(segment.getLoadSpec().get(PATH_KEY)));
    }

    public void kill(DataSegment segment) throws SegmentLoadingException {
        Path segmentPath = HdfsDataSegmentKiller.getPath(segment);
        log.info("killing segment[%s] mapped to path[%s]", new Object[]{segment.getIdentifier(), segmentPath});
        try {
            String segmentLocation = segmentPath.getName();
            FileSystem fs = segmentPath.getFileSystem(this.config);
            if (!segmentLocation.endsWith(".zip")) {
                throw new SegmentLoadingException("Unknown file type[%s]", new Object[]{segmentPath});
            }
            if (!fs.exists(segmentPath)) {
                log.warn("Segment Path [%s] does not exist. It appears to have been deleted already.", new Object[]{segmentPath});
                return;
            }
            String[] zipParts = segmentLocation.split("_");
            if (zipParts.length == 2 && zipParts[1].equals("index.zip") && StringUtils.isNumeric((String)zipParts[0])) {
                if (!fs.delete(segmentPath, false)) {
                    throw new SegmentLoadingException("Unable to kill segment, failed to delete [%s]", new Object[]{segmentPath.toString()});
                }
                Path descriptorPath = new Path(segmentPath.getParent(), io.druid.java.util.common.StringUtils.format((String)"%s_descriptor.json", (Object[])new Object[]{zipParts[0]}));
                if (!fs.delete(descriptorPath, false)) {
                    throw new SegmentLoadingException("Unable to kill segment, failed to delete [%s]", new Object[]{descriptorPath.toString()});
                }
                this.mayBeDeleteParentsUpto(fs, segmentPath, 2);
            } else {
                if (!fs.delete(segmentPath, false)) {
                    throw new SegmentLoadingException("Unable to kill segment, failed to delete [%s]", new Object[]{segmentPath.toString()});
                }
                Path descriptorPath = new Path(segmentPath.getParent(), "descriptor.json");
                if (!fs.delete(descriptorPath, false)) {
                    throw new SegmentLoadingException("Unable to kill segment, failed to delete [%s]", new Object[]{descriptorPath.toString()});
                }
                this.mayBeDeleteParentsUpto(fs, segmentPath, 3);
            }
        }
        catch (IOException e) {
            throw new SegmentLoadingException((Throwable)e, "Unable to kill segment", new Object[0]);
        }
    }

    public void killAll() throws IOException {
        log.info("Deleting all segment files from hdfs dir [%s].", new Object[]{this.storageDirectory.toUri().toString()});
        FileSystem fs = this.storageDirectory.getFileSystem(this.config);
        fs.delete(this.storageDirectory, true);
    }

    private void mayBeDeleteParentsUpto(FileSystem fs, Path segmentPath, int maxDepthTobeDeleted) {
        Path path = segmentPath;
        try {
            for (int i = 1; i <= maxDepthTobeDeleted && fs.listStatus(path = path.getParent()).length == 0 && fs.delete(path, false); ++i) {
            }
        }
        catch (Exception e) {
            log.makeAlert((Throwable)e, "uncaught exception during segment killer", new Object[0]).emit();
        }
    }
}

