/*
 * Decompiled with CFR 0.152.
 */
package io.druid.common.utils;

import com.google.common.io.ByteStreams;
import com.google.common.io.OutputSupplier;
import com.metamx.common.StringUtils;
import io.druid.collections.IntList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

public class SerializerUtils {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public <T extends OutputStream> void writeString(T out, String name) throws IOException {
        byte[] nameBytes = name.getBytes(UTF8);
        this.writeInt(out, nameBytes.length);
        out.write(nameBytes);
    }

    public void writeString(OutputSupplier<? extends OutputStream> supplier, String name) throws IOException {
        try (OutputStream out = (OutputStream)supplier.getOutput();){
            this.writeString(out, name);
        }
    }

    public void writeString(WritableByteChannel out, String name) throws IOException {
        byte[] nameBytes = name.getBytes(UTF8);
        this.writeInt(out, nameBytes.length);
        out.write(ByteBuffer.wrap(nameBytes));
    }

    public String readString(InputStream in) throws IOException {
        int length = this.readInt(in);
        byte[] stringBytes = new byte[length];
        ByteStreams.readFully((InputStream)in, (byte[])stringBytes);
        return StringUtils.fromUtf8((byte[])stringBytes);
    }

    public String readString(ByteBuffer in) throws IOException {
        int length = in.getInt();
        return StringUtils.fromUtf8((byte[])this.readBytes(in, length));
    }

    public byte[] readBytes(ByteBuffer in, int length) throws IOException {
        byte[] bytes = new byte[length];
        in.get(bytes);
        return bytes;
    }

    public void writeStrings(OutputStream out, String[] names) throws IOException {
        this.writeStrings(out, Arrays.asList(names));
    }

    public void writeStrings(OutputStream out, List<String> names) throws IOException {
        this.writeInt(out, names.size());
        for (String name : names) {
            this.writeString(out, name);
        }
    }

    public String[] readStrings(InputStream in) throws IOException {
        int length = this.readInt(in);
        String[] retVal = new String[length];
        for (int i = 0; i < length; ++i) {
            retVal[i] = this.readString(in);
        }
        return retVal;
    }

    public String[] readStrings(ByteBuffer in) throws IOException {
        int length = in.getInt();
        String[] retVal = new String[length];
        for (int i = 0; i < length; ++i) {
            retVal[i] = this.readString(in);
        }
        return retVal;
    }

    public void writeInt(OutputStream out, int intValue) throws IOException {
        byte[] outBytes = new byte[4];
        ByteBuffer.wrap(outBytes).putInt(intValue);
        out.write(outBytes);
    }

    public void writeInt(WritableByteChannel out, int intValue) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(intValue);
        buffer.flip();
        out.write(buffer);
    }

    public int readInt(InputStream in) throws IOException {
        byte[] intBytes = new byte[4];
        ByteStreams.readFully((InputStream)in, (byte[])intBytes);
        return ByteBuffer.wrap(intBytes).getInt();
    }

    public void writeInts(OutputStream out, int[] ints) throws IOException {
        this.writeInt(out, ints.length);
        for (int i = 0; i < ints.length; ++i) {
            this.writeInt(out, ints[i]);
        }
    }

    public void writeInts(OutputStream out, IntList ints) throws IOException {
        this.writeInt(out, ints.length());
        for (int i = 0; i < ints.length(); ++i) {
            this.writeInt(out, ints.get(i));
        }
    }

    public int[] readInts(InputStream in) throws IOException {
        int size = this.readInt(in);
        int[] retVal = new int[size];
        for (int i = 0; i < size; ++i) {
            retVal[i] = this.readInt(in);
        }
        return retVal;
    }

    public void writeLong(OutputStream out, long longValue) throws IOException {
        byte[] outBytes = new byte[8];
        ByteBuffer.wrap(outBytes).putLong(longValue);
        out.write(outBytes);
    }

    public void writeLong(WritableByteChannel out, long longValue) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(longValue);
        buffer.flip();
        out.write(buffer);
    }

    public long readLong(InputStream in) throws IOException {
        byte[] longBytes = new byte[8];
        ByteStreams.readFully((InputStream)in, (byte[])longBytes);
        return ByteBuffer.wrap(longBytes).getLong();
    }

    public void writeLongs(OutputStream out, long[] longs) throws IOException {
        this.writeInt(out, longs.length);
        for (int i = 0; i < longs.length; ++i) {
            this.writeLong(out, longs[i]);
        }
    }

    public long[] readLongs(InputStream in) throws IOException {
        int size = this.readInt(in);
        long[] retVal = new long[size];
        for (int i = 0; i < size; ++i) {
            retVal[i] = this.readLong(in);
        }
        return retVal;
    }

    public void writeFloat(OutputStream out, float intValue) throws IOException {
        byte[] outBytes = new byte[4];
        ByteBuffer.wrap(outBytes).putFloat(intValue);
        out.write(outBytes);
    }

    public void writeFloat(WritableByteChannel out, float floatValue) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putFloat(floatValue);
        buffer.flip();
        out.write(buffer);
    }

    public float readFloat(InputStream in) throws IOException {
        byte[] floatBytes = new byte[4];
        ByteStreams.readFully((InputStream)in, (byte[])floatBytes);
        return ByteBuffer.wrap(floatBytes).getFloat();
    }

    public void writeFloats(OutputStream out, float[] floats) throws IOException {
        this.writeInt(out, floats.length);
        for (int i = 0; i < floats.length; ++i) {
            this.writeFloat(out, floats[i]);
        }
    }

    public float[] readFloats(InputStream in) throws IOException {
        int size = this.readInt(in);
        float[] retVal = new float[size];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = this.readFloat(in);
        }
        return retVal;
    }

    public int getSerializedStringByteSize(String str) {
        return 4 + str.getBytes(UTF8).length;
    }
}

