/*
 * Decompiled with CFR 0.152.
 */
package io.druid.math.expr;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import io.druid.common.guava.GuavaUtils;
import io.druid.java.util.common.IAE;
import io.druid.math.expr.DoubleExpr;
import io.druid.math.expr.Evals;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprType;
import io.druid.math.expr.LongExpr;
import io.druid.math.expr.StringExpr;

public abstract class ExprEval<T> {
    final T value;

    public static ExprEval ofLong(Number longValue) {
        return new LongExprEval(longValue);
    }

    public static ExprEval of(long longValue) {
        return new LongExprEval(longValue);
    }

    public static ExprEval ofDouble(Number doubleValue) {
        return new DoubleExprEval(doubleValue);
    }

    public static ExprEval of(double doubleValue) {
        return new DoubleExprEval(doubleValue);
    }

    public static ExprEval of(String stringValue) {
        return new StringExprEval(stringValue);
    }

    public static ExprEval of(boolean value, ExprType type) {
        switch (type) {
            case DOUBLE: {
                return ExprEval.of(Evals.asDouble(value));
            }
            case LONG: {
                return ExprEval.of(Evals.asLong(value));
            }
            case STRING: {
                return ExprEval.of(String.valueOf(value));
            }
        }
        throw new IllegalArgumentException("invalid type " + (Object)((Object)type));
    }

    public static ExprEval bestEffortOf(Object val) {
        if (val instanceof ExprEval) {
            return (ExprEval)val;
        }
        if (val instanceof Number) {
            if (val instanceof Float || val instanceof Double) {
                return new DoubleExprEval((Number)val);
            }
            return new LongExprEval((Number)val);
        }
        return new StringExprEval(val == null ? null : String.valueOf(val));
    }

    private ExprEval(T value) {
        this.value = value;
    }

    public abstract ExprType type();

    public Object value() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public abstract int asInt();

    public abstract long asLong();

    public abstract double asDouble();

    public String asString() {
        return this.value == null ? null : String.valueOf(this.value);
    }

    public abstract boolean asBoolean();

    public abstract ExprEval castTo(ExprType var1);

    public abstract Expr toExpr();

    private static class StringExprEval
    extends ExprEval<String> {
        private StringExprEval(String value) {
            super(Strings.emptyToNull((String)value));
        }

        @Override
        public final ExprType type() {
            return ExprType.STRING;
        }

        @Override
        public final int asInt() {
            if (this.value == null) {
                return 0;
            }
            Integer theInt = Ints.tryParse((String)((String)this.value));
            return theInt == null ? 0 : theInt;
        }

        @Override
        public final long asLong() {
            Long theLong = GuavaUtils.tryParseLong((String)this.value);
            return theLong == null ? 0L : theLong;
        }

        @Override
        public final double asDouble() {
            if (this.value == null) {
                return 0.0;
            }
            Double theDouble = Doubles.tryParse((String)((String)this.value));
            return theDouble == null ? 0.0 : theDouble;
        }

        @Override
        public final boolean asBoolean() {
            return Evals.asBoolean((String)this.value);
        }

        @Override
        public final ExprEval castTo(ExprType castTo) {
            switch (castTo) {
                case DOUBLE: {
                    return ExprEval.of(this.asDouble());
                }
                case LONG: {
                    return ExprEval.of(this.asLong());
                }
                case STRING: {
                    return this;
                }
            }
            throw new IAE("invalid type " + (Object)((Object)castTo), new Object[0]);
        }

        @Override
        public Expr toExpr() {
            return new StringExpr((String)this.value);
        }
    }

    private static class LongExprEval
    extends NumericExprEval {
        private LongExprEval(Number value) {
            super((Number)Preconditions.checkNotNull((Object)value, (Object)"value"));
        }

        @Override
        public final ExprType type() {
            return ExprType.LONG;
        }

        @Override
        public final boolean asBoolean() {
            return Evals.asBoolean(this.asLong());
        }

        @Override
        public final ExprEval castTo(ExprType castTo) {
            switch (castTo) {
                case DOUBLE: {
                    return ExprEval.of(this.asDouble());
                }
                case LONG: {
                    return this;
                }
                case STRING: {
                    return ExprEval.of(this.asString());
                }
            }
            throw new IAE("invalid type " + (Object)((Object)castTo), new Object[0]);
        }

        @Override
        public Expr toExpr() {
            return new LongExpr(((Number)this.value).longValue());
        }
    }

    private static class DoubleExprEval
    extends NumericExprEval {
        private DoubleExprEval(Number value) {
            super((Number)Preconditions.checkNotNull((Object)value, (Object)"value"));
        }

        @Override
        public final ExprType type() {
            return ExprType.DOUBLE;
        }

        @Override
        public final boolean asBoolean() {
            return Evals.asBoolean(this.asDouble());
        }

        @Override
        public final ExprEval castTo(ExprType castTo) {
            switch (castTo) {
                case DOUBLE: {
                    return this;
                }
                case LONG: {
                    return ExprEval.of(this.asLong());
                }
                case STRING: {
                    return ExprEval.of(this.asString());
                }
            }
            throw new IAE("invalid type " + (Object)((Object)castTo), new Object[0]);
        }

        @Override
        public Expr toExpr() {
            return new DoubleExpr(((Number)this.value).doubleValue());
        }
    }

    private static abstract class NumericExprEval
    extends ExprEval<Number> {
        private NumericExprEval(Number value) {
            super(value);
        }

        @Override
        public final int asInt() {
            return ((Number)this.value).intValue();
        }

        @Override
        public final long asLong() {
            return ((Number)this.value).longValue();
        }

        @Override
        public final double asDouble() {
            return ((Number)this.value).doubleValue();
        }
    }
}

