/*
 * Decompiled with CFR 0.152.
 */
package io.druid.math.expr;

import io.druid.java.util.common.guava.Comparators;
import io.druid.math.expr.BinaryEvalOpExprBase;
import io.druid.math.expr.Evals;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprEval;
import io.druid.math.expr.ExprType;
import javax.annotation.Nullable;

class BinGeqExpr
extends BinaryEvalOpExprBase {
    BinGeqExpr(String op, Expr left, Expr right) {
        super(op, left, right);
    }

    @Override
    protected ExprEval evalString(@Nullable String left, @Nullable String right) {
        return ExprEval.of(Comparators.naturalNullsFirst().compare((Object)left, (Object)right) >= 0, ExprType.LONG);
    }

    @Override
    protected final long evalLong(long left, long right) {
        return Evals.asLong(left >= right);
    }

    @Override
    protected final double evalDouble(double left, double right) {
        return Evals.asDouble(Double.compare(left, right) >= 0);
    }
}

