/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.extended.painter.Painter;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.GlobalFocusListener;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.WindowUtils;
import com.alee.utils.swing.PopupListener;
import com.alee.utils.swing.WindowFollowAdapter;
import com.alee.utils.swing.WindowMethods;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JWindow;
import javax.swing.Popup;

public class WebHeavyWeightPopup
extends WebPanel
implements WindowMethods<JWindow> {
    protected List<PopupListener> listeners = new ArrayList<PopupListener>(2);
    protected boolean closeOnOuterAction = true;
    protected Popup popup;
    protected JWindow window;
    protected Component invoker;
    protected Window invokerWindow;
    protected AWTEventListener mouseListener;
    protected GlobalFocusListener focusListener;
    protected boolean opaque;
    protected boolean followInvoker;
    protected float opacity;
    protected WindowFollowAdapter followAdapter;

    public WebHeavyWeightPopup() {
    }

    public WebHeavyWeightPopup(Component component) {
        super(component);
    }

    public WebHeavyWeightPopup(Painter painter) {
        super(painter);
    }

    public WebHeavyWeightPopup(LayoutManager layout, Painter painter) {
        super(layout, painter);
    }

    public WebHeavyWeightPopup(Painter painter, Component component) {
        super(painter, component);
    }

    public WebHeavyWeightPopup(LayoutManager layout, Painter painter, Component ... components) {
        super(layout, painter, components);
    }

    public WebHeavyWeightPopup(LayoutManager layout) {
        super(layout);
    }

    public WebHeavyWeightPopup(LayoutManager layout, Component ... components) {
        super(layout, components);
    }

    public WebHeavyWeightPopup(String styleId) {
        super(styleId);
    }

    public WebHeavyWeightPopup(String styleId, LayoutManager layout) {
        super(styleId, layout);
    }

    public WebHeavyWeightPopup(String styleId, Component component) {
        super(styleId, component);
    }

    public boolean isCloseOnOuterAction() {
        return this.closeOnOuterAction;
    }

    public void setCloseOnOuterAction(boolean closeOnOuterAction) {
        this.closeOnOuterAction = closeOnOuterAction;
    }

    public Popup getPopup() {
        return this.popup;
    }

    public JWindow getWindow() {
        return this.window;
    }

    public Component getInvoker() {
        return this.invoker;
    }

    public Window getInvokerWindow() {
        return this.invokerWindow;
    }

    public WebHeavyWeightPopup showPopup(Component invoker, Point location) {
        return this.showPopup(invoker, location.x, location.y);
    }

    public WebHeavyWeightPopup showPopup(Component invoker, int x, int y) {
        this.invoker = invoker;
        this.invokerWindow = SwingUtils.getWindowAncestor(invoker);
        Rectangle bos = SwingUtils.getBoundsOnScreen(invoker);
        this.popup = ProprietaryUtils.createHeavyweightPopup(invoker, this, bos.x + x, bos.y + y);
        this.window = (JWindow)SwingUtils.getWindowAncestor(this);
        this.updateOpaque();
        this.updateOpacity();
        this.firePopupWillBeOpened();
        this.popup.show();
        this.mouseListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                Component component;
                MouseEvent e;
                if (WebHeavyWeightPopup.this.closeOnOuterAction && (e = (MouseEvent)event).getID() == 501 && !WebHeavyWeightPopup.this.isAncestorOf(component = e.getComponent())) {
                    WebHeavyWeightPopup.this.hidePopup();
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.mouseListener, 16L);
        this.focusListener = new GlobalFocusListener(){

            @Override
            public void focusChanged(Component oldFocus, Component newFocus) {
                if (WebHeavyWeightPopup.this.closeOnOuterAction && newFocus == null) {
                    WebHeavyWeightPopup.this.hidePopup();
                }
            }
        };
        FocusManager.registerGlobalFocusListener(this.focusListener);
        if (this.followInvoker) {
            this.installFollowAdapter();
        }
        this.firePopupOpened();
        return this;
    }

    public WebHeavyWeightPopup hidePopup() {
        this.firePopupWillBeClosed();
        this.uninstallFollowAdapter();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.mouseListener);
        this.mouseListener = null;
        FocusManager.unregisterGlobalFocusListener(this.focusListener);
        this.focusListener = null;
        this.invokerWindow = null;
        this.invoker = null;
        this.popup.hide();
        this.popup = null;
        this.window = null;
        this.firePopupClosed();
        return this;
    }

    public void addPopupListener(PopupListener listener) {
        this.listeners.add(listener);
    }

    public void removePopupListener(PopupListener listener) {
        this.listeners.remove(listener);
    }

    public void firePopupWillBeOpened() {
        for (PopupListener listener : CollectionUtils.copy(this.listeners)) {
            listener.popupWillBeOpened();
        }
    }

    public void firePopupOpened() {
        for (PopupListener listener : CollectionUtils.copy(this.listeners)) {
            listener.popupOpened();
        }
    }

    public void firePopupWillBeClosed() {
        for (PopupListener listener : CollectionUtils.copy(this.listeners)) {
            listener.popupWillBeClosed();
        }
    }

    public void firePopupClosed() {
        for (PopupListener listener : CollectionUtils.copy(this.listeners)) {
            listener.popupClosed();
        }
    }

    @Override
    public JWindow setWindowOpaque(boolean opaque) {
        this.opaque = opaque;
        return this.updateOpaque();
    }

    protected JWindow updateOpaque() {
        if (this.window != null) {
            WindowUtils.setWindowOpaque(this.window, this.opaque);
        }
        return this.window;
    }

    @Override
    public boolean isWindowOpaque() {
        return this.opaque;
    }

    @Override
    public JWindow setWindowOpacity(float opacity) {
        this.opacity = opacity;
        return this.updateOpacity();
    }

    protected JWindow updateOpacity() {
        if (this.window != null) {
            WindowUtils.setWindowOpacity(this.window, this.opacity);
        }
        return this.window;
    }

    @Override
    public float getWindowOpacity() {
        return this.opacity;
    }

    public boolean isFollowInvoker() {
        return this.followInvoker;
    }

    public void setFollowInvoker(boolean followInvoker) {
        this.followInvoker = followInvoker;
        if (followInvoker) {
            if (this.window != null && this.followAdapter == null) {
                this.installFollowAdapter();
            }
        } else if (this.window != null && this.followAdapter != null) {
            this.uninstallFollowAdapter();
        }
    }

    protected void installFollowAdapter() {
        this.followAdapter = WindowFollowAdapter.install(this.window, this.invokerWindow);
    }

    protected void uninstallFollowAdapter() {
        WindowFollowAdapter.uninstall(this.invokerWindow, this.followAdapter);
        this.followAdapter = null;
    }

    @Override
    public JWindow center() {
        return WindowUtils.center(this.window);
    }

    @Override
    public JWindow center(Component relativeTo) {
        return WindowUtils.center(this.window, relativeTo);
    }

    @Override
    public JWindow center(int width, int height) {
        return WindowUtils.center(this.window, width, height);
    }

    @Override
    public JWindow center(Component relativeTo, int width, int height) {
        return WindowUtils.center(this.window, relativeTo, width, height);
    }

    @Override
    public JWindow packToWidth(int width) {
        return WindowUtils.packToWidth(this.window, width);
    }

    @Override
    public JWindow packToHeight(int height) {
        return WindowUtils.packToHeight(this.window, height);
    }

    @Override
    public JWindow packAndCenter() {
        return WindowUtils.packAndCenter(this.window);
    }

    @Override
    public JWindow packAndCenter(boolean animate) {
        return WindowUtils.packAndCenter(this.window, animate);
    }
}

