/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.ninepatch;

import com.alee.log.Log;
import com.alee.utils.ReflectUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;

public class NinePatchIconConverter
extends ReflectionConverter {
    public static final String NEAR_CLASS_ATTRIBUTE = "nearClass";

    public NinePatchIconConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public boolean canConvert(Class type) {
        return type.equals(NinePatchIcon.class);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String nearClass = reader.getAttribute(NEAR_CLASS_ATTRIBUTE);
        if (nearClass == null) {
            nearClass = (String)context.get((Object)"class");
        }
        if (nearClass == null) {
            return null;
        }
        Class nearRealClass = ReflectUtils.getClassSafely((String)nearClass);
        if (nearRealClass == null) {
            return null;
        }
        String iconPath = reader.getValue();
        try {
            return new NinePatchIcon(nearRealClass.getResource(iconPath));
        }
        catch (Throwable e) {
            Log.error((Object)((Object)this), (String)("Unable to read 9-patch icon near class \"" + nearClass + "\": " + iconPath), (Throwable)e);
            return null;
        }
    }
}

