/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.global.StyleConstants;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIDefaults;

public final class ProprietaryUtils {
    public static final int LIGHT_WEIGHT_POPUP = 0;
    public static final int MEDIUM_WEIGHT_POPUP = 1;
    public static final int HEAVY_WEIGHT_POPUP = 2;
    private static boolean allowLinuxTransparency = false;

    public static boolean isAllowLinuxTransparency() {
        return allowLinuxTransparency;
    }

    public static void setAllowLinuxTransparency(boolean allow) {
        allowLinuxTransparency = allow;
    }

    public static void setupUIDefaults(UIDefaults table) {
        try {
            Class su2 = ReflectUtils.getClass((String)"sun.swing.SwingUtilities2");
            Object aaProperty = ReflectUtils.getStaticFieldValue((Class)su2, (String)"AA_TEXT_PROPERTY_KEY");
            Class aaTextInfo = ReflectUtils.getInnerClass((Class)su2, (String)"AATextInfo");
            Object aaValue = ReflectUtils.callStaticMethod((Class)aaTextInfo, (String)"getAATextInfo", (Object[])new Object[]{true});
            table.put(aaProperty, aaValue);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static boolean isWindowTransparencyAllowed() {
        try {
            return SystemUtils.isWindows() || SystemUtils.isMac() || SystemUtils.isSolaris() || SystemUtils.isUnix() && allowLinuxTransparency;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void setWindowOpaque(Window window, boolean opaque) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                if (SystemUtils.isJava7orAbove()) {
                    ProprietaryUtils.setupOpacityBackgroundColor(opaque, window);
                } else {
                    ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"setWindowOpaque", (Object[])new Object[]{window, opaque});
                }
                JRootPane rootPane = SwingUtils.getRootPane(window);
                if (rootPane != null) {
                    ProprietaryUtils.setupOpacityBackgroundColor(opaque, rootPane);
                    rootPane.setOpaque(opaque);
                    Container container = rootPane.getContentPane();
                    if (container != null) {
                        ProprietaryUtils.setupOpacityBackgroundColor(opaque, container);
                        if (container instanceof JComponent) {
                            ((JComponent)container).setOpaque(opaque);
                        }
                    }
                    rootPane.repaint();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected static void setupOpacityBackgroundColor(boolean opaque, Component component) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Color bg = opaque ? StyleConstants.backgroundColor : StyleConstants.transparent;
        ReflectUtils.callMethod((Object)component, (String)"setBackground", (Object[])new Object[]{bg});
    }

    public static boolean isWindowOpaque(Window window) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                Color bg;
                Boolean isOpaque = SystemUtils.isJava7orAbove() ? Boolean.valueOf((bg = (Color)ReflectUtils.callMethod((Object)window, (String)"getBackground", (Object[])new Object[0])).getAlpha() == 255) : (Boolean)ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"isWindowOpaque", (Object[])new Object[]{window});
                return isOpaque != null ? isOpaque : true;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void setWindowOpacity(Window window, float opacity) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                if (SystemUtils.isJava7orAbove()) {
                    ReflectUtils.callMethod((Object)window, (String)"setOpacity", (Object[])new Object[]{Float.valueOf(opacity)});
                } else {
                    ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"setWindowOpacity", (Object[])new Object[]{window, Float.valueOf(opacity)});
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static float getWindowOpacity(Window window) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                Float opacity = SystemUtils.isJava7orAbove() ? (Float)ReflectUtils.callMethod((Object)window, (String)"getOpacity", (Object[])new Object[0]) : (Float)ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"getWindowOpacity", (Object[])new Object[]{window});
                return opacity != null ? opacity.floatValue() : 1.0f;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return 1.0f;
    }

    public static Popup createHeavyweightPopup(Component invoker, Component content, int x, int y) {
        return (Popup)ReflectUtils.callMethodSafely((Object)PopupFactory.getSharedInstance(), (String)"getPopup", (Object[])new Object[]{invoker, content, x, y, 2});
    }
}

