/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.extended.painter.AdaptivePainter;
import com.alee.extended.painter.Painter;
import com.alee.extended.painter.TexturePainter;
import com.alee.global.StyleConstants;
import com.alee.laf.label.WebLabel;
import com.alee.laf.scroll.WebScrollBarUI;
import com.alee.laf.text.WebTextField;
import com.alee.utils.ColorUtils;
import com.alee.utils.GeometryUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.laf.FocusType;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.laf.Styleable;
import com.alee.utils.laf.WeblafBorder;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.alee.utils.swing.BorderMethods;
import com.alee.utils.xml.ResourceFile;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.BasicButtonUI;

public final class LafUtils {
    public static final AffineTransform moveLeft = new AffineTransform(){
        {
            this.translate(-1.0, 0.0);
        }
    };
    public static final AffineTransform moveRight = new AffineTransform(){
        {
            this.translate(1.0, 0.0);
        }
    };
    public static final AffineTransform moveUp = new AffineTransform(){
        {
            this.translate(0.0, -1.0);
        }
    };
    public static final AffineTransform moveDown = new AffineTransform(){
        {
            this.translate(0.0, 1.0);
        }
    };
    private static final Map<String, GradientPaint> gradientCache = new HashMap<String, GradientPaint>();
    public static int halfButton = 4;
    public static int halfSelector = 2;
    public static int halfLine = 1;
    public static int shadeWidth = 2;
    private static final NinePatchIcon conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/conn.9.png"));
    private static final NinePatchIcon lr_conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/lr_conn.9.png"));
    private static final NinePatchIcon ud_conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/ud_conn.9.png"));
    private static final NinePatchIcon corners_conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/corners_conn.9.png"));
    private static final NinePatchIcon full_conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/full_conn.9.png"));
    private static final NinePatchIcon lr = new NinePatchIcon(LafUtils.class.getResource("icons/selection/lr.9.png"));
    private static final NinePatchIcon ud = new NinePatchIcon(LafUtils.class.getResource("icons/selection/ud.9.png"));
    private static final NinePatchIcon corners = new NinePatchIcon(LafUtils.class.getResource("icons/selection/corners.9.png"));
    private static final NinePatchIcon full = new NinePatchIcon(LafUtils.class.getResource("icons/selection/full.9.png"));
    private static final ImageIcon gripper = new ImageIcon(LafUtils.class.getResource("icons/selection/gripper.png"));
    private static final Map<Integer, NinePatchIcon> selectorCache = new HashMap<Integer, NinePatchIcon>();
    private static final int TEXT_SHADOW_SIZE = 2;

    public static Border createWebBorder(Insets insets) {
        return new WeblafBorder(insets.top, insets.left, insets.bottom, insets.right);
    }

    public static Border createWebBorder(int top, int left, int bottom, int right) {
        return new WeblafBorder(top, left, bottom, right);
    }

    public static Border createWebBorder(int margin) {
        return new WeblafBorder(margin, margin, margin, margin);
    }

    public static <T extends Painter> T getProperPainter(Painter painter, Class properClass, Class adapterClass) {
        return (T)(painter == null ? null : (ReflectUtils.isAssignable((Class)properClass, painter.getClass()) ? painter : (Painter)ReflectUtils.createInstanceSafely((Class)adapterClass, (Object[])new Object[]{painter})));
    }

    public static <T extends Painter> T getAdaptedPainter(Painter painter) {
        return (T)(painter != null && painter instanceof AdaptivePainter ? ((AdaptivePainter)painter).getPainter() : painter);
    }

    public static void firePainterChanged(JComponent component, Painter oldPainter, Painter newPainter) {
        try {
            ReflectUtils.callMethod((Object)component, (String)"firePropertyChange", (Object[])new Object[]{"painter", oldPainter, newPainter});
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void setScrollBarStyleId(JScrollPane scrollPane, String styleId) {
        ScrollBarUI hui;
        JScrollBar hsb;
        ScrollBarUI vui;
        JScrollBar vsb = scrollPane.getVerticalScrollBar();
        if (vsb != null && (vui = vsb.getUI()) instanceof WebScrollBarUI) {
            WebScrollBarUI ui = (WebScrollBarUI)vui;
            ui.setStyleId(styleId);
        }
        if ((hsb = scrollPane.getHorizontalScrollBar()) != null && (hui = hsb.getUI()) instanceof WebScrollBarUI) {
            WebScrollBarUI ui = (WebScrollBarUI)hui;
            ui.setStyleId(styleId);
        }
    }

    public static <T extends ComponentUI> T getUI(Component component) {
        return (T)((ComponentUI)ReflectUtils.callMethodSafely((Object)component, (String)"getUI", (Object[])new Object[0]));
    }

    public static void updateBorder(JComponent component, Insets margin, Painter painter) {
        if (component != null) {
            Insets pi;
            if (SwingUtils.isPreserveBorders(component)) {
                return;
            }
            boolean ltr = component.getComponentOrientation().isLeftToRight();
            Insets m = new Insets(0, 0, 0, 0);
            if (margin != null) {
                m.top += margin.top;
                m.left = m.left + (ltr ? margin.left : margin.right);
                m.bottom += margin.bottom;
                m.right = m.right + (ltr ? margin.right : margin.left);
            }
            if (painter != null && (pi = painter.getMargin(component)) != null) {
                m.top += pi.top;
                m.left = m.left + (ltr ? pi.left : pi.right);
                m.bottom += pi.bottom;
                m.right = m.right + (ltr ? pi.right : pi.left);
            }
            component.setBorder(LafUtils.createWebBorder(m));
        }
    }

    public static void fillVisibleBackground(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            LafUtils.fillVisible(g, c);
        }
    }

    public static void fillVisible(Graphics g, JComponent c) {
        Shape clip = g.getClip();
        Rectangle rect = clip != null ? clip.getBounds() : c.getVisibleRect();
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    public static void nullifyButtonUI(JButton button) {
        button.setUI(new BasicButtonUI());
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorder(null);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusable(false);
        button.setOpaque(false);
    }

    public static Shape createRoundedShape(int round, int ... points) {
        if (points == null || points.length % 2 != 0) {
            throw new RuntimeException("Incorrect x,y combinations amount");
        }
        Point[] fp = new Point[points.length / 2];
        for (int i = 0; i < points.length; i += 2) {
            fp[i / 2] = new Point(points[i], points[i + 1]);
        }
        return LafUtils.createRoundedShape(round, fp);
    }

    public static Shape createRoundedShape(int round, Point ... points) {
        return LafUtils.createRoundedShape(round, points, null);
    }

    public static Shape createRoundedShape(int round, Point[] points, boolean[] rounded) {
        if (points == null || points.length < 3) {
            throw new RuntimeException("There should be atleast three points presented");
        }
        if (rounded != null && rounded.length != points.length) {
            throw new RuntimeException("Rouned marks array size should fit points array size");
        }
        GeneralPath gp = new GeneralPath(0);
        for (int i = 0; i < points.length; ++i) {
            Point p = points[i];
            if (i == 0) {
                Point beforePoint = points[points.length - 1];
                if (round == 0 || rounded != null && !rounded[points.length - 1]) {
                    gp.moveTo(beforePoint.x, beforePoint.y);
                } else {
                    Point actualBeforePoint = LafUtils.getRoundSidePoint(round, beforePoint, p);
                    gp.moveTo(actualBeforePoint.x, actualBeforePoint.y);
                }
                if (round == 0 || rounded != null && !rounded[i]) {
                    gp.lineTo(p.x, p.y);
                    continue;
                }
                Point before = LafUtils.getRoundSidePoint(round, p, beforePoint);
                Point after = LafUtils.getRoundSidePoint(round, p, points[i + 1]);
                gp.lineTo(before.x, before.y);
                gp.quadTo(p.x, p.y, after.x, after.y);
                continue;
            }
            if (round == 0 || rounded != null && !rounded[i]) {
                gp.lineTo(p.x, p.y);
                continue;
            }
            Point before = LafUtils.getRoundSidePoint(round, p, points[i - 1]);
            Point after = LafUtils.getRoundSidePoint(round, p, points[i < points.length - 1 ? i + 1 : 0]);
            gp.lineTo(before.x, before.y);
            gp.quadTo(p.x, p.y, after.x, after.y);
        }
        return gp;
    }

    private static Point getRoundSidePoint(int round, Point from, Point to) {
        if (from.y == to.y) {
            if (from.x < to.x) {
                return new Point(from.x + Math.min(round, (to.x - from.x) / 2), from.y);
            }
            return new Point(from.x - Math.min(round, (from.x - to.x) / 2), from.y);
        }
        if (from.x == to.x) {
            if (from.y < to.y) {
                return new Point(from.x, from.y + Math.min(round, (to.y - from.y) / 2));
            }
            return new Point(from.x, from.y - Math.min(round, (from.y - to.y) / 2));
        }
        return null;
    }

    public static void drawAlphaLayer(Graphics2D g2d, Rectangle rectangle) {
        LafUtils.drawAlphaLayer(g2d, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void drawAlphaLayer(Graphics2D g2d, int x, int y, int width, int height) {
        LafUtils.drawAlphaLayer(g2d, x, y, width, height, StyleConstants.ALPHA_RECT_SIZE);
    }

    public static void drawAlphaLayer(Graphics2D g2d, Rectangle rectangle, int size) {
        LafUtils.drawAlphaLayer(g2d, rectangle.x, rectangle.y, rectangle.width, rectangle.height, size);
    }

    public static void drawAlphaLayer(Graphics2D g2d, int x, int y, int width, int height, int size) {
        LafUtils.drawAlphaLayer(g2d, x, y, width, height, size, StyleConstants.LIGHT_ALPHA, StyleConstants.DARK_ALPHA);
    }

    public static void drawAlphaLayer(Graphics2D g2d, Rectangle rectangle, int size, Color light, Color dark) {
        LafUtils.drawAlphaLayer(g2d, rectangle.x, rectangle.y, rectangle.width, rectangle.height, size, light, dark);
    }

    public static void drawAlphaLayer(Graphics2D g2d, int x, int y, int width, int height, int size, Color light, Color dark) {
        int xAmount = width / size + 1;
        int yAmount = height / size + 1;
        for (int i = 0; i < xAmount; ++i) {
            for (int j = 0; j < yAmount; ++j) {
                Color color;
                boolean lightColor = (i + j) % 2 == 0;
                Color color2 = color = lightColor ? light : dark;
                if (color == null) continue;
                g2d.setPaint(color);
                int w = x + i * size + size > x + width ? width - i * size : size;
                int h = y + j * size + size > y + height ? height - j * size : size;
                g2d.fillRect(x + i * size, y + j * size, w, h);
            }
        }
    }

    public static Rectangle getTextBounds(String text, Graphics g, Font font) {
        return LafUtils.getTextBounds(text, (Graphics2D)g, font);
    }

    public static Rectangle getTextBounds(String text, Graphics2D g2d, Font font) {
        FontRenderContext renderContext = g2d.getFontRenderContext();
        GlyphVector glyphVector = font.createGlyphVector(renderContext, text);
        return glyphVector.getVisualBounds().getBounds();
    }

    public static Shape drawWebStyle(Graphics2D g2d, JComponent component) {
        return LafUtils.drawWebStyle(g2d, component, StyleConstants.shadeColor, StyleConstants.shadeWidth, StyleConstants.smallRound);
    }

    public static Shape drawWebStyle(Graphics2D g2d, JComponent component, Color shadeColor, int shadeWidth, int round) {
        return LafUtils.drawWebStyle(g2d, component, shadeColor, shadeWidth, round, true);
    }

    public static Shape drawWebStyle(Graphics2D g2d, JComponent component, Color shadeColor, int shadeWidth, int round, boolean fillBackground) {
        return LafUtils.drawWebStyle(g2d, component, shadeColor, shadeWidth, round, fillBackground, false);
    }

    public static Shape drawWebStyle(Graphics2D g2d, JComponent component, Color shadeColor, int shadeWidth, int round, boolean fillBackground, boolean webColored) {
        return LafUtils.drawWebStyle(g2d, component, shadeColor, shadeWidth, round, fillBackground, webColored, StyleConstants.darkBorderColor, StyleConstants.disabledBorderColor);
    }

    public static Shape drawWebStyle(Graphics2D g2d, JComponent component, Color shadeColor, int shadeWidth, int round, boolean fillBackground, boolean webColored, float opacity) {
        return LafUtils.drawWebStyle(g2d, component, shadeColor, shadeWidth, round, fillBackground, webColored, StyleConstants.darkBorderColor, StyleConstants.disabledBorderColor, opacity);
    }

    public static Shape drawWebStyle(Graphics2D g2d, JComponent component, Color shadeColor, int shadeWidth, int round, boolean fillBackground, boolean webColored, Color border) {
        return LafUtils.drawWebStyle(g2d, component, shadeColor, shadeWidth, round, fillBackground, webColored, border, border);
    }

    public static Shape drawWebStyle(Graphics2D g2d, JComponent component, Color shadeColor, int shadeWidth, int round, boolean fillBackground, boolean webColored, Color border, Color disabledBorder) {
        return LafUtils.drawWebStyle(g2d, component, shadeColor, shadeWidth, round, fillBackground, webColored, border, disabledBorder, 1.0f);
    }

    public static Shape drawWebStyle(Graphics2D g2d, JComponent component, Color shadeColor, int shadeWidth, int round, boolean fillBackground, boolean webColored, Color border, Color disabledBorder, float opacity) {
        if (opacity <= 0.0f || opacity > 1.0f) {
            return null;
        }
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(opacity), (opacity < 1.0f ? 1 : 0) != 0);
        Shape borderShape = LafUtils.getWebBorderShape(component, shadeWidth, round);
        if (component.isEnabled() && shadeColor != null) {
            GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)borderShape, (Color)shadeColor, (int)shadeWidth);
        }
        if (fillBackground) {
            g2d.setPaint(webColored ? LafUtils.getWebGradientPaint(0, shadeWidth, 0, component.getHeight() - shadeWidth) : component.getBackground());
            if (round > 0) {
                g2d.fillRoundRect(shadeWidth, shadeWidth, component.getWidth() - shadeWidth * 2, component.getHeight() - shadeWidth * 2, round * 2 + 2, round * 2 + 2);
            } else {
                g2d.fillRect(shadeWidth, shadeWidth, component.getWidth() - shadeWidth * 2, component.getHeight() - shadeWidth * 2);
            }
        }
        if (border != null) {
            g2d.setPaint(component.isEnabled() ? border : disabledBorder);
            g2d.draw(borderShape);
        }
        GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (opacity < 1.0f ? 1 : 0) != 0);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        return borderShape;
    }

    public static GradientPaint getWebGradientPaint(Rectangle bounds) {
        return LafUtils.getWebGradientPaint(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
    }

    public static GradientPaint getWebGradientPaint(int x1, int y1, int x2, int y2) {
        String key = x1 + ";" + y1 + ";" + x2 + ";" + y2;
        if (gradientCache.containsKey(key)) {
            return gradientCache.get(key);
        }
        GradientPaint gp = new GradientPaint(x1, y1, StyleConstants.topBgColor, x2, y2, StyleConstants.bottomBgColor);
        gradientCache.put(key, gp);
        return gp;
    }

    public static Shape getWebBorderShape(JComponent component, int shadeWidth, int round) {
        if (round > 0) {
            return new RoundRectangle2D.Double(shadeWidth, shadeWidth, component.getWidth() - shadeWidth * 2 - 1, component.getHeight() - shadeWidth * 2 - 1, round * 2, round * 2);
        }
        return new Rectangle2D.Double(shadeWidth, shadeWidth, component.getWidth() - shadeWidth * 2 - 1, component.getHeight() - shadeWidth * 2 - 1);
    }

    public static void drawCustomWebBorder(Graphics2D g2d, JComponent component, Shape borderShape, Color shadeColor, int shadeWidth, boolean fillBackground, boolean webColored) {
        LafUtils.drawCustomWebBorder(g2d, component, borderShape, shadeColor, shadeWidth, fillBackground, webColored, Color.GRAY, Color.LIGHT_GRAY);
    }

    public static void drawCustomWebBorder(Graphics2D g2d, JComponent component, Shape borderShape, Color shadeColor, int shadeWidth, boolean fillBackground, boolean webColored, Color border, Color disabledBorder) {
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        if (component.isEnabled()) {
            GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)borderShape, (Color)shadeColor, (int)shadeWidth);
        }
        if (fillBackground) {
            if (webColored) {
                Rectangle shapeBounds = borderShape.getBounds();
                g2d.setPaint(new GradientPaint(0.0f, shapeBounds.y, StyleConstants.topBgColor, 0.0f, shapeBounds.y + shapeBounds.height, StyleConstants.bottomBgColor));
                g2d.fill(borderShape);
            } else {
                g2d.setPaint(component.getBackground());
                g2d.fill(borderShape);
            }
        }
        if (border != null) {
            g2d.setPaint(component.isEnabled() ? border : disabledBorder);
            g2d.draw(borderShape);
        }
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    public static boolean drawWebFocus(Graphics2D g2d, JComponent component, FocusType focusType, int shadeWidth, int round) {
        return LafUtils.drawWebFocus(g2d, component, focusType, shadeWidth, round, null);
    }

    public static boolean drawWebFocus(Graphics2D g2d, JComponent component, FocusType focusType, int shadeWidth, int round, Boolean mouseover) {
        return LafUtils.drawWebFocus(g2d, component, focusType, shadeWidth, round, mouseover, null);
    }

    public static boolean drawWebFocus(Graphics2D g2d, JComponent component, FocusType focusType, int shadeWidth, int round, Boolean mouseover, Boolean hasFocus) {
        return LafUtils.drawWebFocus(g2d, component, focusType, shadeWidth, round, mouseover, hasFocus, focusType.equals((Object)FocusType.componentFocus) ? StyleConstants.focusColor : StyleConstants.fieldFocusColor);
    }

    public static boolean drawWebFocus(Graphics2D g2d, JComponent component, FocusType focusType, int shadeWidth, int round, Boolean mouseover, Boolean hasFocus, Color color) {
        return LafUtils.drawWebFocus(g2d, component, focusType, shadeWidth, round, mouseover, hasFocus, color, focusType.equals((Object)FocusType.componentFocus) ? StyleConstants.focusStroke : StyleConstants.fieldFocusStroke);
    }

    public static boolean drawWebFocus(Graphics2D g2d, JComponent component, FocusType focusType, int shadeWidth, int round, Boolean mouseover, Boolean hasFocus, Color color, Stroke stroke) {
        if ((hasFocus = Boolean.valueOf(hasFocus != null ? hasFocus : component.hasFocus() && component.isEnabled())).booleanValue() && focusType.equals((Object)FocusType.componentFocus)) {
            Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
            Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)stroke);
            g2d.setPaint(color);
            g2d.draw(LafUtils.getWebFocusShape(component, focusType, shadeWidth, round));
            GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os);
            GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
            return true;
        }
        if (focusType.equals((Object)FocusType.fieldFocus) && (hasFocus.booleanValue() || mouseover != null && mouseover.booleanValue())) {
            Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
            Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)stroke);
            g2d.setPaint(color);
            g2d.draw(LafUtils.getWebFocusShape(component, focusType, shadeWidth, round));
            GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os);
            GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
            return true;
        }
        return false;
    }

    public static Shape getWebFocusShape(JComponent component, FocusType focusType, int shadeWidth, int round) {
        int spacing = focusType.equals((Object)FocusType.componentFocus) ? 2 : 0;
        int n = round = focusType.equals((Object)FocusType.componentFocus) ? Math.max(0, round - 2) : round;
        if (round > 0) {
            return new RoundRectangle2D.Double(shadeWidth + spacing, shadeWidth + spacing, component.getWidth() - shadeWidth * 2 - spacing * 2 - 1, component.getHeight() - shadeWidth * 2 - spacing * 2 - 1, round * 2, round * 2);
        }
        return new Rectangle2D.Double(shadeWidth + spacing, shadeWidth + spacing, component.getWidth() - shadeWidth * 2 - spacing * 2 - 1, component.getHeight() - shadeWidth * 2 - spacing * 2 - 1);
    }

    public static void drawCustomWebFocus(Graphics2D g2d, JComponent component, FocusType focusType, Shape shape) {
        LafUtils.drawCustomWebFocus(g2d, component, focusType, shape, null);
    }

    public static void drawCustomWebFocus(Graphics2D g2d, JComponent component, FocusType focusType, Shape shape, Boolean mouseover) {
        LafUtils.drawCustomWebFocus(g2d, component, focusType, shape, mouseover, null);
    }

    public static void drawCustomWebFocus(Graphics2D g2d, JComponent component, FocusType focusType, Shape shape, Boolean mouseover, Boolean hasFocus) {
        if ((hasFocus = Boolean.valueOf(hasFocus != null ? hasFocus : component.hasFocus() && component.isEnabled())).booleanValue() && focusType.equals((Object)FocusType.componentFocus)) {
            Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
            Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)StyleConstants.focusStroke);
            g2d.setPaint(StyleConstants.focusColor);
            g2d.draw(shape);
            GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os);
            GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        } else if (focusType.equals((Object)FocusType.fieldFocus) && (hasFocus.booleanValue() || mouseover != null && mouseover.booleanValue())) {
            Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
            Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)StyleConstants.fieldFocusStroke);
            g2d.setPaint(hasFocus != false ? StyleConstants.fieldFocusColor : StyleConstants.transparentFieldFocusColor);
            g2d.draw(shape);
            GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os);
            GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        }
    }

    public static void drawWebSelection(Graphics2D g2d, Color color, int x, int y, int width, int height, boolean resizableLR, boolean resizableUD, boolean drawConnectors) {
        LafUtils.drawWebSelection(g2d, color, new Rectangle(x, y, width, height), resizableLR, resizableUD, drawConnectors);
    }

    public static void drawWebSelection(Graphics2D g2d, Color color, int x, int y, int width, int height, boolean resizableLR, boolean resizableUD, boolean drawConnectors, boolean drawSideControls) {
        LafUtils.drawWebSelection(g2d, color, new Rectangle(x, y, width, height), resizableLR, resizableUD, drawConnectors, drawSideControls);
    }

    public static void drawWebSelection(Graphics2D g2d, Color color, Rectangle selection, boolean resizableLR, boolean resizableUD, boolean drawConnectors) {
        LafUtils.drawWebSelection(g2d, color, selection, resizableLR, resizableUD, drawConnectors, true);
    }

    public static void drawWebSelection(Graphics2D g2d, Color color, Rectangle selection, boolean resizableLR, boolean resizableUD, boolean drawConnectors, boolean drawSideControls) {
        selection = GeometryUtils.validateRect((Rectangle)selection);
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Area buttonsShape = new Area();
        if (resizableUD) {
            if (resizableLR) {
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x - halfButton, selection.y - halfButton, halfButton * 2, halfButton * 2)));
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width - halfButton, selection.y - halfButton, halfButton * 2, halfButton * 2)));
            }
            if (drawSideControls) {
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width / 2 - halfButton, selection.y - halfButton, halfButton * 2, halfButton * 2)));
            }
        }
        if (resizableLR && drawSideControls) {
            buttonsShape.add(new Area(new Ellipse2D.Double(selection.x - halfButton, selection.y + selection.height / 2 - halfButton, halfButton * 2, halfButton * 2)));
            buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width - halfButton, selection.y + selection.height / 2 - halfButton, halfButton * 2, halfButton * 2)));
        }
        if (resizableUD) {
            if (resizableLR) {
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x - halfButton, selection.y + selection.height - halfButton, halfButton * 2, halfButton * 2)));
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width - halfButton, selection.y + selection.height - halfButton, halfButton * 2, halfButton * 2)));
            }
            if (drawSideControls) {
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width / 2 - halfButton, selection.y + selection.height - halfButton, halfButton * 2, halfButton * 2)));
            }
        }
        if (drawConnectors) {
            Area selectionShape = new Area(new RoundRectangle2D.Double(selection.x - halfLine, selection.y - halfLine, selection.width + halfLine * 2, selection.height + halfLine * 2, 5.0, 5.0));
            selectionShape.subtract(new Area(new RoundRectangle2D.Double(selection.x + halfLine, selection.y + halfLine, selection.width - halfLine * 2, selection.height - halfLine * 2, 3.0, 3.0)));
            buttonsShape.add(selectionShape);
        }
        GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)buttonsShape, (Color)Color.GRAY, (int)shadeWidth);
        g2d.setPaint(Color.GRAY);
        g2d.draw(buttonsShape);
        g2d.setPaint(color);
        g2d.fill(buttonsShape);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    public static void drawWebSelector(Graphics2D g2d, Color color, Rectangle selection, int selector) {
        selection = GeometryUtils.validateRect((Rectangle)selection);
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Ellipse2D.Double buttonsShape = selector == 8 ? new Ellipse2D.Double(selection.x - halfSelector, selection.y - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 1 ? new Ellipse2D.Double(selection.x + selection.width / 2 - halfSelector, selection.y - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 2 ? new Ellipse2D.Double(selection.x + selection.width - halfSelector, selection.y - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 7 ? new Ellipse2D.Double(selection.x - halfSelector, selection.y + selection.height / 2 - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 3 ? new Ellipse2D.Double(selection.x + selection.width - halfSelector, selection.y + selection.height / 2 - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 6 ? new Ellipse2D.Double(selection.x - halfSelector, selection.y + selection.height - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 5 ? new Ellipse2D.Double(selection.x + selection.width / 2 - halfSelector, selection.y + selection.height - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 4 ? new Ellipse2D.Double(selection.x + selection.width - halfSelector, selection.y + selection.height - halfSelector, halfSelector * 2, halfSelector * 2) : null)))))));
        g2d.setPaint(color);
        g2d.fill(buttonsShape);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    public static void drawWebIconedSelection(Graphics2D g2d, Rectangle selection, boolean resizableLR, boolean resizableUD, boolean drawConnectors) {
        LafUtils.drawWebIconedSelection(g2d, selection, resizableLR, resizableUD, drawConnectors, true);
    }

    public static void drawWebIconedSelection(Graphics2D g2d, Rectangle selection, boolean resizableLR, boolean resizableUD, boolean drawConnectors, boolean drawSideControls) {
        selection = GeometryUtils.validateRect((Rectangle)selection);
        Rectangle rect = LafUtils.calculateIconedRect(selection);
        if (drawConnectors) {
            if (!resizableLR && !resizableUD) {
                conn.paintIcon(g2d, rect);
            } else if (resizableLR && !resizableUD && drawSideControls) {
                lr_conn.paintIcon(g2d, rect);
            } else if (!resizableLR && resizableUD && drawSideControls) {
                ud_conn.paintIcon(g2d, rect);
            } else if (resizableLR && resizableUD) {
                if (drawSideControls) {
                    full_conn.paintIcon(g2d, rect);
                } else {
                    corners_conn.paintIcon(g2d, rect);
                }
            }
        } else if (resizableLR && !resizableUD && drawSideControls) {
            lr.paintIcon(g2d, rect);
        } else if (!resizableLR && resizableUD && drawSideControls) {
            ud.paintIcon(g2d, rect);
        } else if (resizableLR && resizableUD) {
            if (drawSideControls) {
                full.paintIcon(g2d, rect);
            } else {
                corners.paintIcon(g2d, rect);
            }
        }
    }

    public static void drawWebIconedSelector(Graphics2D g2d, Rectangle selection, int selector) {
        selection = GeometryUtils.validateRect((Rectangle)selection);
        Rectangle rect = LafUtils.calculateIconedRect(selection);
        LafUtils.getSelectorIcon(selector).paintIcon(g2d, rect);
    }

    public static void drawWebIconedGripper(Graphics2D g2d, Point point) {
        LafUtils.drawWebIconedGripper(g2d, point.x, point.y);
    }

    public static void drawWebIconedGripper(Graphics2D g2d, int x, int y) {
        g2d.drawImage(gripper.getImage(), x - gripper.getIconWidth() / 2, y - gripper.getIconHeight() / 2, null);
    }

    private static Rectangle calculateIconedRect(Rectangle selection) {
        return new Rectangle(selection.x - halfButton - shadeWidth, selection.y - halfButton - shadeWidth, selection.width + halfButton * 2 + shadeWidth * 2, selection.height + halfButton * 2 + shadeWidth * 2);
    }

    private static NinePatchIcon getSelectorIcon(int selector) {
        if (selectorCache.containsKey(selector)) {
            return selectorCache.get(selector);
        }
        NinePatchIcon npi = new NinePatchIcon(LafUtils.class.getResource("icons/selection/selector" + selector + ".9.png"));
        selectorCache.put(selector, npi);
        return npi;
    }

    public static void drawEtchedShape(Graphics2D g2d, BufferedImage topBg, BufferedImage bottomBg, Shape fullShape, Shape bevelShape) {
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Rectangle bounds = fullShape.getBounds();
        g2d.setPaint(new TexturePaint(topBg, new Rectangle(bounds.getLocation(), new Dimension(topBg.getWidth(), topBg.getHeight()))));
        g2d.fill(fullShape);
        Shape oldClip = g2d.getClip();
        Area newClip = new Area(oldClip);
        newClip.intersect(new Area(bevelShape));
        g2d.setClip(newClip);
        g2d.setPaint(new TexturePaint(bottomBg, new Rectangle(bounds.getLocation(), new Dimension(bottomBg.getWidth(), bottomBg.getHeight()))));
        g2d.fill(bevelShape);
        GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)bevelShape, (Color)Color.BLACK, (int)4);
        g2d.setClip(oldClip);
        g2d.setPaint(Color.DARK_GRAY);
        g2d.draw(bevelShape);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    public static void paintTextShadow(Graphics2D g2d, String s) {
        LafUtils.paintTextShadow(g2d, s, Color.LIGHT_GRAY);
    }

    public static void paintTextShadow(Graphics2D g2d, String s, Color c) {
        LafUtils.paintTextEffect(g2d, s, ColorUtils.removeAlpha((Color)c), 2, -2.0, -1.0, true);
    }

    public static void paintTextGlow(Graphics2D g2d, String s, Color glow) {
        LafUtils.paintTextEffect(g2d, s, ColorUtils.removeAlpha((Color)glow), 2, -2.0, -2.0, false);
    }

    public static void paintTextEffect(Graphics2D g2d, String s, Color c, int size, double tx, double ty, boolean isShadow) {
        float opacity = 0.8f;
        Composite oldComposite = g2d.getComposite();
        Color oldColor = g2d.getColor();
        float preAlpha = 0.4f;
        if (oldComposite instanceof AlphaComposite && ((AlphaComposite)oldComposite).getRule() == 3) {
            preAlpha = Math.min(((AlphaComposite)oldComposite).getAlpha(), preAlpha);
        }
        g2d.setColor(c);
        g2d.translate(tx, ty);
        int maxSize = isShadow ? size - 1 : size;
        for (int i = -size; i <= maxSize; ++i) {
            for (int j = -size; j <= maxSize; ++j) {
                double distance = i * i + j * j;
                float alpha = 0.8f;
                if (distance > 0.0) {
                    alpha = (float)(1.0 / (distance * (double)size * (double)0.8f));
                }
                if ((alpha *= preAlpha) > 1.0f) {
                    alpha = 1.0f;
                }
                g2d.setComposite(AlphaComposite.getInstance(3, alpha));
                g2d.drawString(s, i + size, j + size);
            }
        }
        g2d.translate(-tx, -ty);
        g2d.setComposite(oldComposite);
        g2d.setColor(oldColor);
        g2d.drawString(s, 0, 0);
    }

    public static void drawDashedRect(Graphics2D g2d, int x1, int y1, int x2, int y2, int stripeLength, int spaceLength) {
        LafUtils.drawDashedRect(g2d, x1, y1, x2, y2, stripeLength, spaceLength, 0.0f);
    }

    public static void drawDashedRect(Graphics2D g2d, int x1, int y1, int x2, int y2, int stripeLength, int spaceLength, float stripeStart) {
        if (x2 < x1 || y2 < y1) {
            return;
        }
        float[] dash = new float[]{stripeLength, spaceLength};
        BasicStroke stroke = new BasicStroke(1.0f, 1, 1, 10.0f, dash, stripeStart);
        Stroke oldStroke = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)stroke);
        g2d.drawRect(x1, y1, x2 - x1, y2 - y1);
        GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)oldStroke);
    }

    public static GeneralPath createRoundedRectShape(int x, int y, int w, int h, int arcW, int arcH) {
        GeneralPath gp = new GeneralPath(0);
        gp.moveTo(x, y + arcH);
        gp.quadTo(x, y, x + arcW, y);
        gp.lineTo(x + w - arcW, y);
        gp.quadTo(x + w, y, x + w, y + arcH);
        gp.lineTo(x + w, y + h - arcH);
        gp.quadTo(x + w, y + h, x + w - arcW, y + h);
        gp.lineTo(x + arcW, y + h);
        gp.quadTo(x, y + h, x, y + h - arcH);
        gp.closePath();
        return gp;
    }

    public static Point getTextCenterShear(FontMetrics fm, String text) {
        return new Point(LafUtils.getTextCenterShearX(fm, text), LafUtils.getTextCenterShearY(fm));
    }

    public static int getTextCenterShearX(FontMetrics fm, String text) {
        return -fm.stringWidth(text) / 2;
    }

    public static int getTextCenterShearY(FontMetrics fm) {
        return (fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
    }

    public static boolean updateBorder(Component component) {
        BorderMethods borderMethods = LafUtils.getBorderMethods(component);
        if (borderMethods != null) {
            borderMethods.updateBorder();
            return true;
        }
        return false;
    }

    public static BorderMethods getBorderMethods(Component component) {
        if (component instanceof BorderMethods) {
            return (BorderMethods)((Object)component);
        }
        Object ui = LafUtils.getUI(component);
        if (ui != null && ui instanceof BorderMethods) {
            return (BorderMethods)ui;
        }
        return null;
    }

    public static ShapeProvider getShapeProvider(Component component) {
        if (component instanceof ShapeProvider) {
            return (ShapeProvider)((Object)component);
        }
        Object ui = LafUtils.getUI(component);
        if (ui != null && ui instanceof ShapeProvider) {
            return (ShapeProvider)ui;
        }
        return null;
    }

    public static Styleable getStyleable(Component component) {
        if (component instanceof Styleable) {
            return (Styleable)((Object)component);
        }
        Object ui = LafUtils.getUI(component);
        if (ui != null && ui instanceof Styleable) {
            return (Styleable)ui;
        }
        return null;
    }

    public static Rectangle getLabelEditorBounds(WebLabel label, WebTextField editor) {
        editor.setFieldMargin(0, label.getIcon() != null ? label.getIconTextGap() : 0, 0, 0);
        Rectangle bounds = new Rectangle(0, 0, label.getWidth(), label.getHeight());
        Insets lm = label.getInsets();
        bounds.x += lm.left;
        bounds.y += lm.top;
        bounds.width -= lm.left + lm.right;
        bounds.height -= lm.top + lm.bottom;
        Insets fm = editor.getMargin();
        int dm = 1 + editor.getShadeWidth();
        bounds.x -= fm.left + dm;
        bounds.y -= fm.top + dm;
        bounds.width += fm.left + fm.right + dm * 2;
        bounds.height += fm.top + fm.bottom + dm * 2;
        ++bounds.width;
        return bounds;
    }

    public static TexturePainter loadTexturePainter(Object source) {
        return LafUtils.loadTexturePainter(XmlUtils.loadResourceFile((Object)source));
    }

    public static TexturePainter loadTexturePainter(ResourceFile resource) {
        return new TexturePainter(XmlUtils.loadImageIcon((ResourceFile)resource));
    }
}

