/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.skin.web;

import com.alee.extended.painter.AbstractPainter;
import com.alee.global.StyleConstants;
import com.alee.laf.scroll.ScrollBarPainter;
import com.alee.laf.scroll.WebScrollBarStyle;
import com.alee.utils.ColorUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;

public class WebScrollBarPainter<E extends JScrollBar>
extends AbstractPainter<E>
implements ScrollBarPainter<E> {
    protected boolean paintButtons = WebScrollBarStyle.paintButtons;
    protected boolean paintTrack = WebScrollBarStyle.paintTrack;
    protected int thumbRound = WebScrollBarStyle.thumbRound;
    protected Insets thumbMargin = WebScrollBarStyle.thumbMargin;
    protected Color trackBorderColor = WebScrollBarStyle.trackBorderColor;
    protected Color trackBackgroundColor = WebScrollBarStyle.trackBackgroundColor;
    protected Color thumbBorderColor = WebScrollBarStyle.thumbBorderColor;
    protected Color thumbBackgroundColor = WebScrollBarStyle.thumbBackgroundColor;
    protected Color thumbDisabledBorderColor = WebScrollBarStyle.thumbDisabledBorderColor;
    protected Color thumbDisabledBackgroundColor = WebScrollBarStyle.thumbDisabledBackgroundColor;
    protected Color thumbRolloverBorderColor = WebScrollBarStyle.thumbRolloverBorderColor;
    protected Color thumbRolloverBackgroundColor = WebScrollBarStyle.thumbRolloverBackgroundColor;
    protected Color thumbPressedBorderColor = WebScrollBarStyle.thumbPressedBorderColor;
    protected Color thumbPressedBackgroundColor = WebScrollBarStyle.thumbPressedBackgroundColor;
    protected boolean animated;
    protected WebTimer rolloverAnimator;
    protected float rolloverState;
    protected boolean rollover;
    protected boolean pressed;
    protected boolean dragged;
    protected Rectangle trackBounds;
    protected Rectangle thumbBounds;
    protected Insets thumbMarginR;
    protected Insets thumbMarginHL;
    protected Insets thumbMarginHR;
    protected MouseAdapter mouseAdapter;

    @Override
    public void install(E scrollbar) {
        super.install(scrollbar);
        this.animated = true;
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                WebScrollBarPainter.this.setPressed(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                WebScrollBarPainter.this.setPressed(false);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                WebScrollBarPainter.this.setRollover(WebScrollBarPainter.this.thumbBounds.contains(e.getPoint()));
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                WebScrollBarPainter.this.setRollover(WebScrollBarPainter.this.thumbBounds.contains(e.getPoint()));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WebScrollBarPainter.this.setRollover(false);
            }
        };
        ((Component)scrollbar).addMouseListener(this.mouseAdapter);
        ((Component)scrollbar).addMouseMotionListener(this.mouseAdapter);
    }

    @Override
    public void uninstall(E scrollbar) {
        ((Component)scrollbar).removeMouseListener(this.mouseAdapter);
        ((Component)scrollbar).removeMouseMotionListener(this.mouseAdapter);
        super.uninstall(scrollbar);
    }

    public boolean isPaintButtons() {
        return this.paintButtons;
    }

    @Override
    public void setPaintButtons(boolean paint) {
        if (this.paintButtons != paint) {
            this.paintButtons = paint;
            this.updateAll();
        }
    }

    public boolean isPaintTrack() {
        return this.paintTrack;
    }

    @Override
    public void setPaintTrack(boolean paint) {
        if (this.paintTrack != paint) {
            this.paintTrack = paint;
            this.updateAll();
        }
    }

    public int getThumbRound() {
        return this.thumbRound;
    }

    public void setThumbRound(int round) {
        if (this.thumbRound != round) {
            this.thumbRound = round;
            this.repaintThumb();
        }
    }

    public Insets getThumbMargin() {
        return this.thumbMargin;
    }

    public void setThumbMargin(Insets margin) {
        if (this.thumbMargin != margin) {
            this.thumbMargin = margin;
            this.updateThumbMargins();
            this.repaintThumb();
        } else if (this.thumbMarginR == null) {
            this.updateThumbMargins();
        }
    }

    protected void updateThumbMargins() {
        this.thumbMarginR = new Insets(this.thumbMargin.top, this.thumbMargin.right, this.thumbMargin.bottom, this.thumbMargin.left);
        this.thumbMarginHL = new Insets(this.thumbMargin.left, this.thumbMargin.bottom, this.thumbMargin.right, this.thumbMargin.top);
        this.thumbMarginHR = new Insets(this.thumbMargin.right, this.thumbMargin.top, this.thumbMargin.left, this.thumbMargin.bottom);
    }

    public Color getTrackBorderColor() {
        return this.trackBorderColor;
    }

    public void setTrackBorderColor(Color color) {
        if (this.trackBorderColor != color) {
            this.trackBorderColor = color;
            this.repaint();
        }
    }

    public Color getTrackBackgroundColor() {
        return this.trackBackgroundColor;
    }

    public void setTrackBackgroundColor(Color color) {
        if (this.trackBackgroundColor != color) {
            this.trackBackgroundColor = color;
            this.repaint();
        }
    }

    public Color getThumbBorderColor() {
        return this.thumbBorderColor;
    }

    public void setThumbBorderColor(Color color) {
        if (this.thumbBorderColor != color) {
            this.thumbBorderColor = color;
            this.repaintThumb();
        }
    }

    public Color getThumbBackgroundColor() {
        return this.thumbBackgroundColor;
    }

    public void setThumbBackgroundColor(Color color) {
        if (this.thumbBackgroundColor != color) {
            this.thumbBackgroundColor = color;
            this.repaintThumb();
        }
    }

    public Color getThumbDisabledBorderColor() {
        return this.thumbDisabledBorderColor;
    }

    public void setThumbDisabledBorderColor(Color color) {
        if (this.thumbDisabledBorderColor != color) {
            this.thumbDisabledBorderColor = color;
            this.repaintThumb();
        }
    }

    public Color getThumbDisabledBackgroundColor() {
        return this.thumbDisabledBackgroundColor;
    }

    public void setThumbDisabledBackgroundColor(Color color) {
        if (this.thumbDisabledBackgroundColor != color) {
            this.thumbDisabledBackgroundColor = color;
            this.repaintThumb();
        }
    }

    public Color getThumbRolloverBorderColor() {
        return this.thumbRolloverBorderColor;
    }

    public void setThumbRolloverBorderColor(Color color) {
        if (this.thumbRolloverBorderColor != color) {
            this.thumbRolloverBorderColor = color;
            this.repaintThumb();
        }
    }

    public Color getThumbRolloverBackgroundColor() {
        return this.thumbRolloverBackgroundColor;
    }

    public void setThumbRolloverBackgroundColor(Color color) {
        if (this.thumbRolloverBackgroundColor != color) {
            this.thumbRolloverBackgroundColor = color;
            this.repaintThumb();
        }
    }

    public Color getThumbPressedBorderColor() {
        return this.thumbPressedBorderColor;
    }

    public void setThumbPressedBorderColor(Color color) {
        if (this.thumbPressedBorderColor != color) {
            this.thumbPressedBorderColor = color;
            this.repaintThumb();
        }
    }

    public Color getThumbPressedBackgroundColor() {
        return this.thumbPressedBackgroundColor;
    }

    public void setThumbPressedBackgroundColor(Color color) {
        if (this.thumbPressedBackgroundColor != color) {
            this.thumbPressedBackgroundColor = color;
            this.repaintThumb();
        }
    }

    public boolean isRollover() {
        return this.rollover;
    }

    public void setRollover(boolean rollover) {
        if (this.rollover != rollover) {
            this.rollover = rollover;
            if (this.animated) {
                if (rollover) {
                    if (this.rolloverAnimator != null) {
                        this.rolloverAnimator.stop();
                    }
                    this.repaintThumb();
                } else {
                    if (this.rolloverAnimator == null) {
                        this.rolloverAnimator = new WebTimer(StyleConstants.avgAnimationDelay, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (WebScrollBarPainter.this.rolloverState > 0.0f) {
                                    WebScrollBarPainter.this.rolloverState -= 0.1f;
                                    WebScrollBarPainter.this.repaintThumb();
                                } else {
                                    WebScrollBarPainter.this.rolloverState = 0.0f;
                                    WebScrollBarPainter.this.rolloverAnimator.stop();
                                }
                            }
                        });
                    }
                    this.rolloverState = 1.0f;
                    this.rolloverAnimator.start();
                }
            } else {
                this.rolloverState = rollover ? 1.0f : 0.0f;
                this.repaintThumb();
            }
        }
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        if (this.pressed != pressed) {
            this.pressed = pressed;
            this.repaintThumb();
        }
    }

    @Override
    public void setDragged(boolean dragged) {
        this.dragged = dragged;
    }

    @Override
    public void setTrackBounds(Rectangle bounds) {
        this.trackBounds = bounds;
    }

    @Override
    public void setThumbBounds(Rectangle bounds) {
        this.thumbBounds = bounds;
    }

    @Override
    public Boolean isOpaque(E scrollbar) {
        return this.paintTrack;
    }

    @Override
    public Insets getMargin(E scrollbar) {
        if (this.paintTrack) {
            boolean hor = ((JScrollBar)scrollbar).getOrientation() == 0;
            return new Insets(hor ? 1 : 0, hor ? 0 : 1, 0, 0);
        }
        return null;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E scrollbar) {
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        this.paintBackground(g2d, scrollbar, bounds);
        this.paintTrack(g2d, scrollbar, this.trackBounds);
        this.paintThumb(g2d, scrollbar, this.thumbBounds);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    protected void paintBackground(Graphics2D g2d, E scrollbar, Rectangle bounds) {
        if (this.paintTrack) {
            g2d.setPaint(this.trackBackgroundColor);
            g2d.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            if (((JScrollBar)scrollbar).getOrientation() == 1) {
                boolean ltr = ((Component)scrollbar).getComponentOrientation().isLeftToRight();
                int x = ltr ? bounds.x : bounds.x + bounds.width - 1;
                g2d.setColor(this.trackBorderColor);
                g2d.drawLine(x, bounds.y, x, bounds.height - 1);
            } else {
                g2d.setColor(this.trackBorderColor);
                g2d.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y);
            }
        }
    }

    protected void paintTrack(Graphics2D g2d, E scrollbar, Rectangle bounds) {
    }

    protected void paintThumb(Graphics2D g2d, E scrollbar, Rectangle bounds) {
        Insets m = this.getCurrentThumbMargin(scrollbar);
        int w = bounds.width - m.left - m.right;
        int h = bounds.height - m.top - m.bottom;
        int round = MathUtils.min((int[])new int[]{this.thumbRound, w - 1, h - 1});
        g2d.setPaint(this.getCurrentThumbBackgroundColor(scrollbar));
        g2d.fillRoundRect(bounds.x + m.left, bounds.y + m.top, w, h, round, round);
        g2d.setPaint(this.getCurrentThumbBorderColor(scrollbar));
        g2d.drawRoundRect(bounds.x + m.left, bounds.y + m.top, w - 1, h - 1, round, round);
    }

    protected Insets getCurrentThumbMargin(E scrollbar) {
        if (this.thumbMargin != null) {
            if (this.thumbMarginR == null) {
                this.updateThumbMargins();
            }
            boolean ver = ((JScrollBar)scrollbar).getOrientation() == 1;
            boolean ltr = ((Component)scrollbar).getComponentOrientation().isLeftToRight();
            return ver ? (ltr ? this.thumbMargin : this.thumbMarginR) : (ltr ? this.thumbMarginHL : this.thumbMarginHR);
        }
        return new Insets(0, 0, 0, 0);
    }

    protected Color getCurrentThumbBorderColor(E scrollbar) {
        return ((Component)scrollbar).isEnabled() ? (this.pressed || this.dragged ? this.thumbPressedBorderColor : (this.rollover ? this.thumbRolloverBorderColor : ColorUtils.getIntermediateColor((Color)this.thumbBorderColor, (Color)this.thumbRolloverBorderColor, (float)this.rolloverState))) : this.thumbDisabledBorderColor;
    }

    protected Color getCurrentThumbBackgroundColor(E scrollbar) {
        return ((Component)scrollbar).isEnabled() ? (this.pressed || this.dragged ? this.thumbPressedBackgroundColor : (this.rollover ? this.thumbRolloverBackgroundColor : ColorUtils.getIntermediateColor((Color)this.thumbBackgroundColor, (Color)this.thumbRolloverBackgroundColor, (float)this.rolloverState))) : this.thumbDisabledBackgroundColor;
    }

    public void repaintThumb() {
        if (this.thumbBounds != null) {
            this.repaint(this.thumbBounds);
        } else {
            this.repaint();
        }
    }
}

