/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.skin.web;

import com.alee.extended.painter.AbstractPainter;
import com.alee.laf.button.WebButtonUI;
import com.alee.laf.scroll.ScrollBarButtonPainter;
import com.alee.laf.scroll.ScrollBarButtonType;
import com.alee.laf.scroll.WebScrollBarStyle;
import com.alee.utils.ShapeCache;
import com.alee.utils.swing.DataProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ButtonUI;

public class WebScrollBarButtonPainter<E extends AbstractButton>
extends AbstractPainter<E>
implements ScrollBarButtonPainter<E> {
    protected static final String ARROW_BUTTON_SHAPE = "arrow-button";
    protected Color borderColor = WebScrollBarStyle.thumbBorderColor;
    protected Color backgroundColor = WebScrollBarStyle.thumbBackgroundColor;
    protected Color disabledBorderColor = WebScrollBarStyle.thumbDisabledBorderColor;
    protected Color disabledBackgroundColor = WebScrollBarStyle.thumbDisabledBackgroundColor;
    protected Color rolloverBorderColor = WebScrollBarStyle.thumbRolloverBorderColor;
    protected Color rolloverBackgroundColor = WebScrollBarStyle.thumbRolloverBackgroundColor;
    protected Color pressedBorderColor = WebScrollBarStyle.thumbPressedBorderColor;
    protected Color pressedBackgroundColor = WebScrollBarStyle.thumbPressedBackgroundColor;
    protected ScrollBarButtonType buttonType;
    protected JScrollBar scrollbar;

    public WebScrollBarButtonPainter() {
        this.setPreferredSize(new Dimension(WebScrollBarStyle.buttonsSize));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (this.borderColor != color) {
            this.borderColor = color;
            this.repaint();
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        if (this.backgroundColor != color) {
            this.backgroundColor = color;
            this.repaint();
        }
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color color) {
        if (this.disabledBorderColor != color) {
            this.disabledBorderColor = color;
            this.repaint();
        }
    }

    public Color getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public void setDisabledBackgroundColor(Color color) {
        if (this.disabledBackgroundColor != color) {
            this.disabledBackgroundColor = color;
            this.repaint();
        }
    }

    public Color getRolloverBorderColor() {
        return this.rolloverBorderColor;
    }

    public void setRolloverBorderColor(Color color) {
        if (this.rolloverBorderColor != color) {
            this.rolloverBorderColor = color;
            this.repaint();
        }
    }

    public Color getRolloverBackgroundColor() {
        return this.rolloverBackgroundColor;
    }

    public void setRolloverBackgroundColor(Color color) {
        if (this.rolloverBackgroundColor != color) {
            this.rolloverBackgroundColor = color;
            this.repaint();
        }
    }

    public Color getPressedBorderColor() {
        return this.pressedBorderColor;
    }

    public void setPressedBorderColor(Color color) {
        if (this.pressedBorderColor != color) {
            this.pressedBorderColor = color;
            this.repaint();
        }
    }

    public Color getPressedBackgroundColor() {
        return this.pressedBackgroundColor;
    }

    public void setPressedBackgroundColor(Color color) {
        if (this.pressedBackgroundColor != color) {
            this.pressedBackgroundColor = color;
            this.repaint();
        }
    }

    @Override
    public void setButtonType(ScrollBarButtonType type) {
        this.buttonType = type;
    }

    @Override
    public void setScrollbar(JScrollBar scrollbar) {
        this.scrollbar = scrollbar;
    }

    @Override
    public Insets getMargin(E button) {
        boolean decr;
        boolean ver = this.scrollbar.getOrientation() == 1;
        boolean bl = decr = this.buttonType == ScrollBarButtonType.decrease;
        if (ver) {
            return new Insets(decr ? 1 : 0, 1, decr ? 0 : 1, 1);
        }
        return new Insets(1, decr ? 1 : 0, 1, decr ? 0 : 1);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E button) {
        ButtonModel model = ((AbstractButton)button).getModel();
        ButtonUI ui = ((AbstractButton)button).getUI();
        boolean enabled = ((Component)button).isEnabled();
        boolean pressed = model.isPressed() || model.isSelected();
        boolean rollover = ui instanceof WebButtonUI ? ((WebButtonUI)ui).isRollover() : model.isRollover();
        Shape shape = this.getArrowButtonShape(bounds, button);
        g2d.setPaint(enabled ? (pressed ? this.pressedBackgroundColor : (rollover ? this.rolloverBackgroundColor : this.backgroundColor)) : this.disabledBackgroundColor);
        g2d.fill(shape);
        g2d.setPaint(enabled ? (pressed ? this.pressedBorderColor : (rollover ? this.rolloverBorderColor : this.borderColor)) : this.disabledBorderColor);
        g2d.draw(shape);
    }

    protected Shape getArrowButtonShape(final Rectangle bounds, final E button) {
        return ShapeCache.getShape(button, (String)ARROW_BUTTON_SHAPE, (DataProvider)new DataProvider<Shape>(){

            public Shape provide() {
                return WebScrollBarButtonPainter.this.createArrowButtonShape(bounds, button);
            }
        }, (Object[])this.getCachedShapeSettings(button));
    }

    protected Object[] getCachedShapeSettings(E button) {
        return new Object[]{((Component)button).getSize(), ((JComponent)button).getInsets(), this.buttonType, ((Component)button).getComponentOrientation().isLeftToRight(), this.scrollbar.getOrientation()};
    }

    protected Shape createArrowButtonShape(Rectangle bounds, E button) {
        GeneralPath shape;
        int orientation = this.scrollbar.getOrientation();
        Insets i = ((JComponent)button).getInsets();
        int x = bounds.x + i.left;
        int y = bounds.y + i.top;
        int w = bounds.width - i.left - i.right - 1;
        int h = bounds.height - i.top - i.bottom - 1;
        if (orientation == 1) {
            if (this.buttonType == ScrollBarButtonType.decrease) {
                shape = new GeneralPath(0);
                shape.moveTo(x, y + h);
                shape.quadTo((float)x + (float)w / 2.0f, (float)y + (float)(h * 2) / 3.0f, x + w, y + h);
                shape.lineTo((float)x + (float)w / 2.0f, y);
                shape.closePath();
            } else {
                shape = new GeneralPath(0);
                shape.moveTo(x, y);
                shape.quadTo((float)x + (float)w / 2.0f, (float)y + (float)h / 3.0f, x + w, y);
                shape.lineTo((float)x + (float)w / 2.0f, y + h);
                shape.closePath();
            }
        } else {
            boolean ltr = this.scrollbar.getComponentOrientation().isLeftToRight();
            if (ltr ? this.buttonType == ScrollBarButtonType.decrease : this.buttonType == ScrollBarButtonType.increase) {
                shape = new GeneralPath(0);
                shape.moveTo(x + w, y);
                shape.quadTo((float)x + (float)(w * 2) / 3.0f, (float)y + (float)h / 2.0f, x + w, y + h);
                shape.lineTo(x, (float)y + (float)h / 2.0f);
                shape.closePath();
            } else {
                shape = new GeneralPath(0);
                shape.moveTo(x, y);
                shape.quadTo((float)x + (float)w / 3.0f, (float)y + (float)h / 2.0f, x, y + h);
                shape.lineTo(x + w, (float)y + (float)h / 2.0f);
                shape.closePath();
            }
        }
        return shape;
    }
}

