/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.skin.web;

import com.alee.extended.painter.AbstractPainter;
import com.alee.extended.painter.Painter;
import com.alee.global.StyleConstants;
import com.alee.laf.label.LabelPainter;
import com.alee.laf.label.WebLabelStyle;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.text.View;

public class WebLabelPainter<E extends JLabel>
extends AbstractPainter<E>
implements LabelPainter<E> {
    protected boolean drawShade = WebLabelStyle.drawShade;
    protected Color shadeColor = WebLabelStyle.shadeColor;
    protected Float transparency = WebLabelStyle.transparency;
    protected Painter backgroundPainter = WebLabelStyle.backgroundPainter;
    protected Rectangle paintIconR = new Rectangle();
    protected Rectangle paintTextR = new Rectangle();

    public WebLabelPainter() {
    }

    public WebLabelPainter(Painter backgroundPainter) {
        this.setBackgroundPainter(backgroundPainter);
    }

    public boolean isDrawShade() {
        return this.drawShade;
    }

    @Override
    public void setDrawShade(boolean drawShade) {
        this.drawShade = drawShade;
    }

    public Color getShadeColor() {
        return this.shadeColor;
    }

    public void setShadeColor(Color shadeColor) {
        this.shadeColor = shadeColor;
    }

    public Float getTransparency() {
        return this.transparency;
    }

    public void setTransparency(Float transparency) {
        this.transparency = transparency;
    }

    public Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public void setBackgroundPainter(Painter painter) {
        this.backgroundPainter = painter;
        this.updateAll();
    }

    @Override
    public Boolean isOpaque(E c) {
        return null;
    }

    @Override
    public Insets getMargin(E label) {
        return this.backgroundPainter != null ? this.backgroundPainter.getMargin(label) : super.getMargin(label);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E label) {
        Icon icon;
        Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)this.transparency, (this.transparency != null ? 1 : 0) != 0);
        Map textHints = this.drawShade ? StyleConstants.defaultTextRenderingHints : StyleConstants.textRenderingHints;
        Font oldFont = GraphicsUtils.setupFont((Graphics)g2d, (Font)((Component)label).getFont());
        Map oldHints = SwingUtils.setupTextAntialias(g2d, textHints);
        String text = ((JLabel)label).getText();
        Icon icon2 = icon = ((Component)label).isEnabled() ? ((JLabel)label).getIcon() : ((JLabel)label).getDisabledIcon();
        if (this.backgroundPainter != null) {
            this.backgroundPainter.paint(g2d, bounds, label);
        }
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = ((JComponent)label).getFontMetrics(((Component)label).getFont());
        String clippedText = this.layout(label, fm, ((JComponent)label).getWidth(), ((JComponent)label).getHeight());
        if (icon != null) {
            icon.paintIcon((Component)label, g2d, this.paintIconR.x, this.paintIconR.y);
        }
        if (text != null) {
            View v = (View)((JComponent)label).getClientProperty("html");
            if (v != null) {
                v.paint(g2d, this.paintTextR);
            } else {
                int textX = this.paintTextR.x;
                int textY = this.paintTextR.y + fm.getAscent();
                if (((Component)label).isEnabled()) {
                    this.paintEnabledText(label, g2d, clippedText, textX, textY);
                } else {
                    this.paintDisabledText(label, g2d, clippedText, textX, textY);
                }
            }
        }
        SwingUtils.restoreTextAntialias(g2d, oldHints);
        GraphicsUtils.restoreFont((Graphics)g2d, (Font)oldFont);
        GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (this.transparency != null ? 1 : 0) != 0);
    }

    protected String layout(E label, FontMetrics fm, int width, int height) {
        Insets insets = ((JComponent)label).getInsets(null);
        String text = ((JLabel)label).getText();
        Icon icon = ((Component)label).isEnabled() ? ((JLabel)label).getIcon() : ((JLabel)label).getDisabledIcon();
        Rectangle paintViewR = new Rectangle();
        paintViewR.x = insets.left;
        paintViewR.y = insets.top;
        paintViewR.width = width - (insets.left + insets.right);
        paintViewR.height = height - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        return this.layoutCL(label, fm, text, icon, paintViewR, this.paintIconR, this.paintTextR);
    }

    protected String layoutCL(E label, FontMetrics fm, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return SwingUtilities.layoutCompoundLabel(label, fm, text, icon, ((JLabel)label).getVerticalAlignment(), ((JLabel)label).getHorizontalAlignment(), ((JLabel)label).getVerticalTextPosition(), ((JLabel)label).getHorizontalTextPosition(), viewR, iconR, textR, ((JLabel)label).getIconTextGap());
    }

    protected void paintEnabledText(E label, Graphics2D g2d, String text, int textX, int textY) {
        if (this.drawShade) {
            g2d.setColor(((Component)label).getForeground());
            this.paintShadowText(g2d, text, textX, textY);
        } else {
            int mnemIndex = ((JLabel)label).getDisplayedMnemonicIndex();
            g2d.setColor(((Component)label).getForeground());
            SwingUtils.drawStringUnderlineCharAt(g2d, text, mnemIndex, textX, textY);
        }
    }

    protected void paintDisabledText(E label, Graphics2D g2d, String text, int textX, int textY) {
        if (((Component)label).isEnabled() && this.drawShade) {
            g2d.setColor(((Component)label).getBackground().darker());
            this.paintShadowText(g2d, text, textX, textY);
        } else {
            int accChar = ((JLabel)label).getDisplayedMnemonicIndex();
            Color background = ((Component)label).getBackground();
            g2d.setColor(background.brighter());
            SwingUtils.drawStringUnderlineCharAt(g2d, text, accChar, textX + 1, textY + 1);
            g2d.setColor(background.darker());
            SwingUtils.drawStringUnderlineCharAt(g2d, text, accChar, textX, textY);
        }
    }

    protected void paintShadowText(Graphics2D g2d, String text, int textX, int textY) {
        g2d.translate(textX, textY);
        LafUtils.paintTextShadow(g2d, text, this.shadeColor);
        g2d.translate(-textX, -textY);
    }

    @Override
    public Dimension getPreferredSize(E label) {
        String text = ((JLabel)label).getText();
        Icon icon = ((Component)label).isEnabled() ? ((JLabel)label).getIcon() : ((JLabel)label).getDisabledIcon();
        Insets insets = ((JComponent)label).getInsets(null);
        Font font = ((Component)label).getFont();
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        if (icon == null && (text == null || text != null && font == null)) {
            return new Dimension(dx, dy);
        }
        if (text == null || icon != null && font == null) {
            return new Dimension(icon.getIconWidth() + dx, icon.getIconHeight() + dy);
        }
        FontMetrics fm = ((JComponent)label).getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle();
        iconR.height = 0;
        iconR.width = 0;
        iconR.y = 0;
        iconR.x = 0;
        textR.height = 0;
        textR.width = 0;
        textR.y = 0;
        textR.x = 0;
        viewR.x = dx;
        viewR.y = dy;
        viewR.height = Short.MAX_VALUE;
        viewR.width = Short.MAX_VALUE;
        this.layoutCL(label, fm, text, icon, viewR, iconR, textR);
        int x1 = Math.min(iconR.x, textR.x);
        int x2 = Math.max(iconR.x + iconR.width, textR.x + textR.width);
        int y1 = Math.min(iconR.y, textR.y);
        int y2 = Math.max(iconR.y + iconR.height, textR.y + textR.height);
        Dimension rv = new Dimension(x2 - x1, y2 - y1);
        rv.width += dx;
        rv.height += dy;
        return rv;
    }
}

