/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.skin.ninepatch;

import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.FocusTracker;
import com.alee.managers.style.skin.web.WebLabelPainter;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class NPLabelPainter<E extends JLabel>
extends WebLabelPainter<E> {
    protected boolean undecorated = false;
    protected boolean paintFocus = false;
    protected NinePatchIcon backgroundIcon = null;
    protected NinePatchIcon focusedBackgroundIcon = null;
    protected FocusTracker focusTracker;
    protected boolean focused = false;

    public NPLabelPainter() {
    }

    public NPLabelPainter(NinePatchIcon backgroundIcon) {
        this.setBackgroundIcon(backgroundIcon);
    }

    public NPLabelPainter(NinePatchIcon backgroundIcon, NinePatchIcon focusedBackgroundIcon) {
        this.setBackgroundIcon(backgroundIcon);
        this.setFocusedBackgroundIcon(focusedBackgroundIcon);
    }

    @Override
    public void install(E c) {
        super.install(c);
        this.focusTracker = new DefaultFocusTracker(){

            @Override
            public boolean isTrackingEnabled() {
                return !NPLabelPainter.this.undecorated && NPLabelPainter.this.paintFocus;
            }

            @Override
            public void focusChanged(boolean focused) {
                NPLabelPainter.this.focused = focused;
                NPLabelPainter.this.repaint();
            }
        };
        FocusManager.addFocusTracker(c, this.focusTracker);
    }

    @Override
    public void uninstall(E c) {
        FocusManager.removeFocusTracker(this.focusTracker);
        this.focusTracker = null;
        super.uninstall(c);
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean undecorated) {
        if (this.undecorated != undecorated) {
            this.undecorated = undecorated;
            this.updateAll();
        }
    }

    public boolean isPaintFocus() {
        return this.paintFocus;
    }

    public void setPaintFocus(boolean paint) {
        if (this.paintFocus != paint) {
            this.paintFocus = paint;
            this.updateAll();
        }
    }

    public NinePatchIcon getBackgroundIcon() {
        return this.backgroundIcon;
    }

    public void setBackgroundIcon(NinePatchIcon icon) {
        this.backgroundIcon = icon;
        if (!(this.undecorated || this.paintFocus && this.focused)) {
            this.updateAll();
        }
    }

    public NinePatchIcon getFocusedBackgroundIcon() {
        return this.focusedBackgroundIcon;
    }

    public void setFocusedBackgroundIcon(NinePatchIcon icon) {
        this.focusedBackgroundIcon = icon;
        if (!this.undecorated && this.paintFocus && this.focused) {
            this.updateAll();
        }
    }

    @Override
    public Insets getMargin(E label) {
        NinePatchIcon backgroundIcon = this.getCurrentBackgroundIcon();
        return !this.undecorated && backgroundIcon != null ? backgroundIcon.getMargin() : super.getMargin(label);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c) {
        NinePatchIcon backgroundIcon;
        if (this.undecorated && ((JComponent)c).isOpaque()) {
            g2d.setPaint(((Component)c).getBackground());
            g2d.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if (!this.undecorated && (backgroundIcon = this.getCurrentBackgroundIcon()) != null) {
            backgroundIcon.paintIcon(g2d, bounds);
        }
        super.paint(g2d, bounds, c);
    }

    protected NinePatchIcon getCurrentBackgroundIcon() {
        return this.focused && this.focusedBackgroundIcon != null ? this.focusedBackgroundIcon : this.backgroundIcon;
    }
}

