/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.managers.style.StyleException;
import com.alee.managers.style.SupportedComponent;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.managers.style.data.IgnoredValue;
import com.alee.managers.style.data.PainterStyle;
import com.alee.utils.ReflectUtils;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class ComponentStyleConverter
extends ReflectionConverter {
    public static final String STYLE_NODE = "style";
    public static final String STYLE_ID_ATTRIBUTE = "id";
    public static final String COMPONENT_TYPE_ATTRIBUTE = "type";
    public static final String EXTENDS_ID_ATTRIBUTE = "extends";
    public static final String COMPONENT_NODE = "component";
    public static final String UI_NODE = "ui";
    public static final String PAINTER_NODE = "painter";
    public static final String PAINTER_ID_ATTRIBUTE = "id";
    public static final String PAINTER_CLASS_ATTRIBUTE = "class";
    public static final String IGNORED_ATTRIBUTE = "ignored";
    public static final String DEFAULT_STYLE_ID = "default";

    public ComponentStyleConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public boolean canConvert(Class type) {
        return type.equals(ComponentStyle.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        List<PainterStyle> painters;
        Map<String, Object> uiProperties;
        Map<String, Object> componentProperties;
        ComponentStyle componentStyle = (ComponentStyle)source;
        String componentStyleId = componentStyle.getId();
        writer.addAttribute("id", componentStyleId != null ? componentStyleId : DEFAULT_STYLE_ID);
        writer.addAttribute(COMPONENT_TYPE_ATTRIBUTE, componentStyle.getType().toString());
        String extendsId = componentStyle.getExtendsId();
        if (extendsId != null) {
            writer.addAttribute(EXTENDS_ID_ATTRIBUTE, extendsId);
        }
        if ((componentProperties = componentStyle.getComponentProperties()) != null) {
            writer.startNode(COMPONENT_NODE);
            for (Map.Entry<String, Object> property : componentProperties.entrySet()) {
                writer.startNode(property.getKey());
                context.convertAnother(property.getValue());
                writer.endNode();
            }
            writer.endNode();
        }
        if ((uiProperties = componentStyle.getUIProperties()) != null) {
            writer.startNode(UI_NODE);
            for (Map.Entry<String, Object> property : uiProperties.entrySet()) {
                writer.startNode(property.getKey());
                context.convertAnother(property.getValue());
                writer.endNode();
            }
            writer.endNode();
        }
        if ((painters = componentStyle.getPainters()) != null) {
            for (PainterStyle painterStyle : painters) {
                writer.startNode(PAINTER_NODE);
                writer.addAttribute("id", painterStyle.getId());
                writer.addAttribute(PAINTER_CLASS_ATTRIBUTE, painterStyle.getPainterClass());
                for (Map.Entry<String, Object> property : painterStyle.getProperties().entrySet()) {
                    writer.startNode(property.getKey());
                    context.convertAnother(property.getValue());
                    writer.endNode();
                }
                writer.endNode();
            }
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ComponentStyle componentStyle = new ComponentStyle();
        String componentStyleId = reader.getAttribute("id");
        componentStyle.setId(componentStyleId != null ? componentStyleId : DEFAULT_STYLE_ID);
        SupportedComponent type = SupportedComponent.valueOf(reader.getAttribute(COMPONENT_TYPE_ATTRIBUTE));
        componentStyle.setType(type);
        componentStyle.setExtendsId(reader.getAttribute(EXTENDS_ID_ATTRIBUTE));
        LinkedHashMap<String, Object> componentProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> uiProperties = new LinkedHashMap<String, Object>();
        ArrayList<PainterStyle> painters = new ArrayList<PainterStyle>();
        while (reader.hasMoreChildren()) {
            String propName;
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if (nodeName.equals(COMPONENT_NODE)) {
                Class<? extends JComponent> componentClass = type.getComponentClass();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    propName = reader.getNodeName();
                    this.readProperty(reader, context, componentStyleId, componentProperties, componentClass, propName);
                    reader.moveUp();
                }
            } else if (nodeName.equals(UI_NODE)) {
                Class<? extends ComponentUI> uiClass = type.getUIClass();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    propName = reader.getNodeName();
                    this.readProperty(reader, context, componentStyleId, uiProperties, uiClass, propName);
                    reader.moveUp();
                }
            } else if (nodeName.equals(PAINTER_NODE)) {
                String indicesString = reader.getAttribute("id");
                ArrayList<String> indices = new ArrayList<String>(1);
                if (indicesString.contains(",")) {
                    StringTokenizer st = new StringTokenizer(indicesString, ",", false);
                    while (st.hasMoreTokens()) {
                        indices.add(st.nextToken());
                    }
                } else {
                    indices.add(indicesString);
                }
                String painterClassName = reader.getAttribute(PAINTER_CLASS_ATTRIBUTE);
                ArrayList<PainterStyle> separateStyles = new ArrayList<PainterStyle>(indices.size());
                for (String id : indices) {
                    PainterStyle painterStyle = new PainterStyle();
                    painterStyle.setId(id);
                    painterStyle.setPainterClass(painterClassName);
                    separateStyles.add(painterStyle);
                }
                context.put((Object)PAINTER_CLASS_ATTRIBUTE, (Object)painterClassName);
                LinkedHashMap<String, Object> painterProperties = new LinkedHashMap<String, Object>();
                Class painterClass = ReflectUtils.getClassSafely((String)painterClassName);
                if (painterClass != null) {
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        String propName2 = reader.getNodeName();
                        this.readProperty(reader, context, componentStyleId, painterProperties, painterClass, propName2);
                        reader.moveUp();
                    }
                }
                for (PainterStyle painterStyle : separateStyles) {
                    painterStyle.setProperties(painterProperties);
                }
                painters.addAll(separateStyles);
            }
            reader.moveUp();
        }
        if (componentStyle.getExtendsId() == null) {
            if (painters.size() == 1) {
                ((PainterStyle)painters.get(0)).setBase(true);
            } else {
                boolean baseSet = false;
                for (PainterStyle painter : painters) {
                    if (!painter.isBase()) continue;
                    baseSet = true;
                    break;
                }
                if (!baseSet && painters.size() > 0) {
                    ((PainterStyle)painters.get(0)).setBase(true);
                }
            }
        }
        componentStyle.setComponentProperties(componentProperties);
        componentStyle.setUIProperties(uiProperties);
        componentStyle.setPainters(painters);
        return componentStyle;
    }

    protected void readProperty(HierarchicalStreamReader reader, UnmarshallingContext context, String componentStyleId, Map<String, Object> properties, Class propertyClass, String propertyName) {
        String ignored = reader.getAttribute(IGNORED_ATTRIBUTE);
        if (ignored != null && Boolean.parseBoolean(ignored)) {
            properties.put(propertyName, IgnoredValue.VALUE);
        } else {
            Class fieldClass = ReflectUtils.getFieldTypeSafely((Class)propertyClass, (String)propertyName);
            if (fieldClass != null) {
                properties.put(propertyName, context.convertAnother(properties, fieldClass));
            } else {
                Method getter = ReflectUtils.getFieldGetter((Class)propertyClass, (String)propertyName);
                if (getter != null) {
                    Class<?> rClass = getter.getReturnType();
                    properties.put(propertyName, context.convertAnother(properties, rClass));
                } else {
                    throw new StyleException("Component property \"" + propertyName + "\" type from style \"" + componentStyleId + "\" cannot be determined! Make sure it points to existing field or getter method.");
                }
            }
        }
    }
}

