/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings.processors;

import com.alee.extended.date.DateSelectionListener;
import com.alee.extended.date.WebDateField;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import java.util.Date;

public class WebDateFieldSettingsProcessor
extends SettingsProcessor<WebDateField, Long> {
    private DateSelectionListener selectionListener;

    public WebDateFieldSettingsProcessor(SettingsProcessorData data) {
        super(data);
    }

    protected void doInit(WebDateField dateField) {
        this.selectionListener = new DateSelectionListener(){

            @Override
            public void dateSelected(Date date) {
                WebDateFieldSettingsProcessor.this.save();
            }
        };
        dateField.addDateSelectionListener(this.selectionListener);
    }

    protected void doDestroy(WebDateField dateField) {
        dateField.removeDateSelectionListener(this.selectionListener);
        this.selectionListener = null;
    }

    protected void doLoad(WebDateField dateField) {
        Long date = (Long)this.loadValue();
        Date value = date != null ? new Date(date) : null;
        dateField.setDate(value);
    }

    protected void doSave(WebDateField dateField) {
        Date date = dateField.getDate();
        Long value = date != null ? Long.valueOf(date.getTime()) : null;
        this.saveValue(value);
    }
}

