/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.proxy;

import com.alee.extended.layout.TableLayout;
import com.alee.extended.optionpane.WebExtendedOptionPane;
import com.alee.extended.panel.GroupPanel;
import com.alee.laf.checkbox.WebCheckBox;
import com.alee.laf.label.WebLabel;
import com.alee.laf.separator.WebSeparator;
import com.alee.laf.text.WebPasswordField;
import com.alee.laf.text.WebTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.proxy.ProxyManager;
import com.alee.managers.proxy.ProxySettings;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.AncestorAdapter;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WebProxyAuthenticator
extends Authenticator {
    public static final ImageIcon AUTH_ICON = new ImageIcon(WebProxyAuthenticator.class.getResource("icons/auth.png"));
    private AuthDialog authDialog = null;

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        return this.getProxyAuthentification();
    }

    private PasswordAuthentication getProxyAuthentification() {
        PasswordAuthentication auth;
        ProxySettings proxySettings = ProxyManager.getProxySettings().clone();
        if (this.authDialog != null) {
            auth = null;
        } else if (proxySettings.isUseProxyAuthentification()) {
            auth = this.createAuthentification(proxySettings);
        } else {
            this.authDialog = new AuthDialog(proxySettings);
            this.authDialog.setVisible(true);
            if (this.authDialog.getResult() == 0) {
                proxySettings.setUseProxyAuthentification(true);
                proxySettings.setProxyLogin(this.authDialog.getLogin());
                proxySettings.setProxyPassword(new String(this.authDialog.getPassword()));
                ProxyManager.setProxySettings((ProxySettings)proxySettings, (boolean)this.authDialog.isSaveSettings());
                auth = this.createAuthentification(proxySettings);
            } else {
                ProxySettings updatedSettings = ProxyManager.getProxySettings();
                auth = updatedSettings.isUseProxyAuthentification() ? this.createAuthentification(updatedSettings) : null;
            }
            this.authDialog = null;
        }
        return auth;
    }

    private PasswordAuthentication createAuthentification(ProxySettings proxySettings) {
        return new PasswordAuthentication(proxySettings.getProxyLogin(), proxySettings.getProxyPassword().toCharArray());
    }

    private class AuthDialog
    extends WebExtendedOptionPane {
        private final WebTextField loginField;
        private final WebPasswordField passwordField;
        private final WebCheckBox saveSettings;

        public AuthDialog(ProxySettings proxySettings) {
            super(SwingUtils.getActiveWindow(), null, null, LanguageManager.get((String)"weblaf.proxy.auth.title"), 2, -1);
            JPanel authPanel = new JPanel();
            authPanel.setOpaque(false);
            TableLayout authLayout = new TableLayout(new double[][]{{-2.0, -1.0}, {-2.0, -2.0, -2.0, -2.0}});
            authLayout.setHGap(4);
            authLayout.setVGap(4);
            authPanel.setLayout(authLayout);
            WebLabel hostLabel = new WebLabel();
            hostLabel.setLanguage("weblaf.proxy.auth.host", new Object[0]);
            hostLabel.setHorizontalAlignment(4);
            hostLabel.setEnabled(false);
            authPanel.add((Component)hostLabel, "0,0");
            WebTextField hostValue = new WebTextField(proxySettings.getProxyHost(), 10);
            hostValue.setEnabled(false);
            hostValue.putClientProperty("fill.component.cell", true);
            WebLabel portLabel = new WebLabel();
            portLabel.setLanguage("weblaf.proxy.auth.port", new Object[0]);
            portLabel.setHorizontalAlignment(4);
            portLabel.setEnabled(false);
            WebTextField portValue = new WebTextField(proxySettings.getProxyPort());
            portValue.setEnabled(false);
            authPanel.add((Component)new GroupPanel(2, hostValue, portLabel, portValue), "1,0");
            authPanel.add((Component)new WebSeparator(0), "0,1,1,1");
            WebLabel loginLabel = new WebLabel();
            loginLabel.setLanguage("weblaf.proxy.auth.login", new Object[0]);
            loginLabel.setHorizontalAlignment(4);
            authPanel.add((Component)loginLabel, "0,2");
            this.loginField = new WebTextField(12);
            this.loginField.addAncestorListener((AncestorListener)new AncestorAdapter(){

                public void ancestorAdded(AncestorEvent event) {
                    AuthDialog.this.loginField.requestFocusInWindow();
                }
            });
            authPanel.add((Component)this.loginField, "1,2");
            WebLabel passLabel = new WebLabel();
            passLabel.setLanguage("weblaf.proxy.auth.pass", new Object[0]);
            passLabel.setHorizontalAlignment(4);
            authPanel.add((Component)passLabel, "0,3");
            this.passwordField = new WebPasswordField(12);
            authPanel.add((Component)this.passwordField, "1,3");
            HotkeyManager.registerHotkey((Component)authPanel, authPanel, Hotkey.ENTER, new HotkeyRunnable(){

                @Override
                public void run(KeyEvent e) {
                    AuthDialog.this.clickOk();
                }
            });
            HotkeyManager.registerHotkey((Component)authPanel, authPanel, Hotkey.ESCAPE, new HotkeyRunnable(){

                @Override
                public void run(KeyEvent e) {
                    AuthDialog.this.clickCancel();
                }
            });
            SwingUtils.equalizeComponentsHeights(hostValue, this.loginField, this.passwordField);
            this.setContent(authPanel);
            this.saveSettings = new WebCheckBox("Save proxy settings");
            this.saveSettings.registerSettings(ProxyManager.SETTINGS_GROUP, ProxyManager.SAVE_SETTINGS, (Object)true);
            this.setSpecialComponent(this.saveSettings);
        }

        public String getLogin() {
            return this.loginField.getText();
        }

        public char[] getPassword() {
            return this.passwordField.getPassword();
        }

        public boolean isSaveSettings() {
            return this.saveSettings.isSelected();
        }

        @Override
        protected ImageIcon getLargeIcon(int messageType) {
            return AUTH_ICON;
        }
    }
}

